/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.ShutdownMonitor;
import bk2010.Shutdownable;
import bk2010.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WaveWriter
implements Shutdownable {
    protected RandomAccessFile target;
    protected static final byte[] waveHeader;

    static {
        byte[] byArray = new byte[44];
        byArray[0] = 82;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 70;
        byArray[8] = 87;
        byArray[9] = 65;
        byArray[10] = 86;
        byArray[11] = 69;
        byArray[12] = 102;
        byArray[13] = 109;
        byArray[14] = 116;
        byArray[15] = 32;
        byArray[16] = 16;
        byArray[20] = 1;
        byArray[22] = 1;
        byArray[24] = -128;
        byArray[25] = -69;
        byArray[29] = 119;
        byArray[30] = 1;
        byArray[32] = 2;
        byArray[34] = 16;
        byArray[36] = 100;
        byArray[37] = 97;
        byArray[38] = 116;
        byArray[39] = 97;
        waveHeader = byArray;
    }

    public WaveWriter(File file) throws IOException {
        this.target = new RandomAccessFile(file, "rw");
        this.target.setLength(0L);
        this.target.write(waveHeader);
        ShutdownMonitor.add(this);
    }

    public boolean close() {
        if (this.target == null) {
            return false;
        }
        try {
            long length = this.target.length() - 8L;
            this.target.seek(4L);
            this.target.writeByte((byte)(length & 0xFFL));
            this.target.writeByte((byte)(length >> 8 & 0xFFL));
            this.target.writeByte((byte)(length >> 16 & 0xFFL));
            this.target.writeByte((byte)(length >> 24 & 0xFFL));
            this.target.seek(40L);
            this.target.writeByte((byte)((length -= 36L) & 0xFFL));
            this.target.writeByte((byte)(length >> 8 & 0xFFL));
            this.target.writeByte((byte)(length >> 16 & 0xFFL));
            this.target.writeByte((byte)(length >> 24 & 0xFFL));
            this.target.close();
        }
        catch (IOException e) {
            try {
                this.target.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.target = null;
        ShutdownMonitor.remove(this);
        return true;
    }

    public boolean append(byte[] b, int off, int len) {
        if (this.target == null) {
            return false;
        }
        try {
            this.target.write(b, off, len);
        }
        catch (IOException e) {
            Log.error(".WAV writer: error writing " + this.target.toString());
            this.close();
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void shutdown() {
        this.close();
    }

    public static void main(String[] args) {
        WaveWriter tt;
        try {
            tt = new WaveWriter(new File("test.wav"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        byte[] buf = new byte[218];
        int i = 0;
        while (i < buf.length / 2) {
            int pwr = (int)(Math.sin((double)(i * 2) * Math.PI / 109.0) * 8192.0);
            buf[i * 2] = (byte)pwr;
            buf[i * 2 + 1] = (byte)(pwr >> 8);
            ++i;
        }
        i = 0;
        while (i < 10000) {
            tt.append(buf, 0, buf.length);
            ++i;
        }
        tt.close();
    }
}

