/*
 * Decompiled with CFR 0.152.
 */
package bk2010.recorder;

import bk2010.recorder.FlicEncoder;
import bk2010.util.Log;
import java.io.Closeable;
import java.io.IOException;

public class VideoRecorder
implements Closeable {
    FlicEncoder fenc;
    byte[] upscaled;
    int srcWidth;
    int srcHeight;
    boolean upscale;

    public VideoRecorder(String fileName, int width, int height, byte[] palette, boolean doUpscale) {
        if (fileName == null) {
            fileName = "default.flc";
        }
        Log.l("Recording video to %s", fileName);
        this.srcWidth = width;
        this.srcHeight = height;
        this.upscale = doUpscale;
        int aspectX = 1;
        int aspectY = 1;
        if (doUpscale) {
            this.upscaled = new byte[(width *= 2) * (height *= 3)];
        } else {
            aspectX = 2;
            aspectY = 3;
        }
        this.fenc = new FlicEncoder(fileName, width, height, aspectX, aspectY, 20);
        this.fenc.encodeBlackFrame(palette);
    }

    private void upscaleFrame(byte[] raw) {
        int src = 0;
        int dst = 0;
        int y = 0;
        while (y < this.srcHeight) {
            int dp = dst;
            int i = 0;
            while (i < this.srcWidth) {
                byte b = raw[src++];
                this.upscaled[dp++] = b;
                this.upscaled[dp++] = b;
                ++i;
            }
            System.arraycopy(this.upscaled, dst, this.upscaled, dp, this.srcWidth * 2);
            System.arraycopy(this.upscaled, dst, this.upscaled, dp += this.srcWidth * 2, this.srcWidth * 2);
            dst = dp + this.srcWidth * 2;
            ++y;
        }
    }

    public void encodeFrame(byte[] raw) {
        byte[] outputFrame;
        if (this.upscale) {
            this.upscaleFrame(raw);
            outputFrame = this.upscaled;
        } else {
            outputFrame = raw;
        }
        int special = this.fenc.verifyIdentity(outputFrame);
        if (special == 0) {
            this.fenc.encodeBlackFrame(null);
            return;
        }
        if (special < 0) {
            this.fenc.encodeCopyFrame(null);
            return;
        }
        this.fenc.encodeRLEFrame(outputFrame, null);
    }

    @Override
    public void close() throws IOException {
        this.fenc.close();
    }
}

