/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.registers.HDDControllerIO;
import bk2010.hardware.smk.HDD;
import bk2010.hardware.smk.HDDPassport;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;

public class SimpleHDDController
extends HDDControllerIO {
    public static final int IDE_CMD = 65504;
    public static final int IDE_RESET = 65507;
    public static final int IDE_DEV_HEAD = 65506;
    public static final int IDE_TRK_LOW = 65508;
    public static final int IDE_TRK_HIGH = 65510;
    public static final int IDE_SECTOR = 65512;
    public static final int IDE_COUNT = 65514;
    public static final int IDE_FEATURES = 65516;
    public static final int IDE_DATA = 65518;
    public static final int IDE_STATUS = 65504;
    public static final int IDE_STATUS2 = 65507;
    public static final int IDE_ERROR = 65516;
    public static final int STAT_ERR = 1;
    public static final int STAT_DRQ = 8;
    public static final int STAT_DF = 32;
    public static final int STAT_DRDY = 64;
    public static final int STAT_BSY = 128;
    public static final int ERR_ABRT = 4;
    int ideError = 1;
    int ideTrkHigh;
    int ideTrkLow;
    int ideTrack;
    int ideDevHead;
    int ideSector;
    int ideCount;
    int ideFeatures;
    int ideStatus;
    boolean mounted = false;
    HDD drive;
    int cylinders = 65535;
    int heads = 16;
    int sectors = 255;
    int firstDataSector = 1;
    private static boolean traceEnabled = false;
    private static FileWriter tw;

    public SimpleHDDController() {
        if (traceEnabled) {
            try {
                tw = new FileWriter("hdd.log", false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mount(HDD newDrive) {
        if (newDrive == this.drive) {
            return;
        }
        if (this.drive != null) {
            this.drive.shutdown();
        }
        this.drive = newDrive;
        if (newDrive == null) {
            this.mounted = false;
            return;
        }
        this.mounted = true;
        HDDPassport pas = newDrive.getPassport();
        this.firstDataSector = 1;
        this.cylinders = pas.tracks;
        this.sectors = pas.sectors;
        this.heads = pas.heads;
        long totalSectors = newDrive.getSectorCount();
        if (totalSectors < (long)(this.firstDataSector + this.sectors)) {
            this.cylinders = 0;
            this.mounted = false;
            this.drive = null;
            return;
        }
        this.cylinders = (int)((totalSectors - (long)this.firstDataSector) / (long)(this.heads * this.sectors));
    }

    private boolean setGeometry(int newHeads, int newSectors) {
        if (this.drive == null || newHeads <= 0 || newSectors <= 0) {
            return false;
        }
        this.heads = newHeads;
        this.sectors = newSectors;
        this.cylinders = (int)((this.drive.getSectorCount() - (long)this.firstDataSector) / (long)(this.heads * this.sectors));
        return true;
    }

    final int translateCHS(int cylinder, int head, int sector) {
        if (cylinder >= this.cylinders || head >= this.heads || sector > this.sectors) {
            return -1;
        }
        return (cylinder * this.heads + head) * this.sectors + sector;
    }

    final int translateLBA(int cylinder, int head, int sector) {
        return -1;
    }

    int sectorFromCHS() {
        this.ideTrack = this.ideTrkHigh & 0xFF | (this.ideTrkLow & 0xFF) << 8;
        return this.translateCHS(this.ideTrack, this.ideDevHead & 0xF, this.ideSector & 0xFF);
    }

    protected void execWriteData(short data) {
        if (this.drive != null) {
            this.drive.writeWord(data);
        }
    }

    protected short execReadData() {
        if (this.drive != null) {
            short data = this.drive.readWord();
            return data;
        }
        return -1;
    }

    protected void execReset() {
        this.ideStatus = 64;
        this.ideError = 4;
    }

    protected void execCommand(int command) {
        int startSector = -1;
        command &= 0xFF;
        if (this.drive == null || !this.drive.enabled()) {
            this.ideStatus = 65;
            this.ideError = 4;
            return;
        }
        switch (command) {
            case 8: {
                this.execReset();
                break;
            }
            case 229: {
                this.ideCount = 255;
                this.ideStatus = 64;
                break;
            }
            case 144: {
                this.ideError = 1;
                break;
            }
            case 236: {
                this.ideStatus = 64;
                this.drive.startRead(0L, 1);
                break;
            }
            case 227: {
                this.ideStatus = 64;
                break;
            }
            case 225: {
                this.ideStatus = 64;
                break;
            }
            case 145: {
                int newSectors = this.ideCount & 0xFF;
                int newHeads = (this.ideDevHead & 0xF) + 1;
                SimpleHDDController.trace("Set H:S -> %d:%d", newHeads, newSectors);
                this.setGeometry(this.heads, this.sectors);
                this.ideStatus = 64;
                break;
            }
            case 0: {
                this.ideStatus = 65;
                this.ideError = 4;
                break;
            }
            case 196: {
                break;
            }
            case 32: 
            case 33: {
                this.ideStatus = 64;
                startSector = this.sectorFromCHS();
                SimpleHDDController.trace("Reading %d sectors starting from %d", this.ideCount, startSector);
                if (this.drive.startRead(startSector, this.ideCount)) break;
                this.ideStatus |= 1;
                break;
            }
            case 64: 
            case 65: {
                break;
            }
            case 112: {
                break;
            }
            case 239: {
                break;
            }
            case 198: {
                break;
            }
            case 230: {
                break;
            }
            case 226: {
                break;
            }
            case 224: {
                break;
            }
            case 197: {
                break;
            }
            case 48: 
            case 49: {
                this.ideStatus = 64;
                startSector = this.sectorFromCHS();
                SimpleHDDController.trace("Writing %d sectors starting from %d", this.ideCount, startSector);
                if (this.drive.startWrite(startSector, this.ideCount)) break;
                this.ideStatus |= 1;
                break;
            }
            default: {
                SimpleHDDController.trace("Unsupported command 0x%02x", command);
                this.ideStatus = 65;
                this.ideError = 4;
            }
        }
    }

    @Override
    public int getBaseAddress() {
        return 65504;
    }

    @Override
    public int getNumWords() {
        return 8;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean readWord(int addr, QBusReadDTO result, boolean opcode) {
        if (!this.mounted) {
            result.value = (short)-18831;
            return true;
        }
        int response = 0;
        switch (addr) {
            case 65504: {
                response = 64;
                if (this.drive.getDataRequest()) {
                    response |= 8;
                }
                SimpleHDDController.trace("get status");
                break;
            }
            case 65516: {
                response = this.ideError;
                break;
            }
            case 65506: {
                response = this.ideDevHead;
                break;
            }
            case 65510: {
                response = this.ideTrkHigh;
                break;
            }
            case 65508: {
                response = this.ideTrkLow;
                break;
            }
            case 65518: {
                response = this.execReadData() & 0xFFFF;
                SimpleHDDController.trace("read data: 0x%04x %06o", response, response);
                break;
            }
            case 65514: {
                response = this.ideCount;
                break;
            }
            case 65512: {
                response = this.ideSector;
            }
        }
        result.value = (short)(~response);
        return true;
    }

    @Override
    public boolean writeWord(int addr, short data) {
        if (!this.mounted) {
            return true;
        }
        int masked = ~data & 0xFFFF;
        SimpleHDDController.trace("Write %6o: 0x%04x %6o", addr, masked, masked);
        switch (addr) {
            case 65504: {
                if ((this.ideDevHead & 0x10) != 0) break;
                SimpleHDDController.trace("cmd");
                this.execCommand(masked);
                break;
            }
            case 65507: {
                SimpleHDDController.trace("reset");
                this.execReset();
                break;
            }
            case 65506: {
                SimpleHDDController.trace("set device/head");
                this.ideDevHead = masked & 0xF;
                break;
            }
            case 65510: {
                SimpleHDDController.trace("set track high");
                this.ideTrkHigh = masked;
                break;
            }
            case 65508: {
                SimpleHDDController.trace("set track low");
                this.ideTrkLow = masked;
                break;
            }
            case 65518: {
                this.execWriteData((short)masked);
                break;
            }
            case 65516: {
                SimpleHDDController.trace("set features");
                this.ideFeatures = masked;
                break;
            }
            case 65514: {
                SimpleHDDController.trace("set count");
                this.ideCount = masked;
                break;
            }
            case 65512: {
                SimpleHDDController.trace("set sector");
                this.ideSector = masked;
            }
        }
        return true;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        return this.writeWord(addr, data);
    }

    private static void trace(String line) {
        if (!traceEnabled) {
            return;
        }
        try {
            tw.append("HDD: " + line + '\n');
            tw.flush();
        }
        catch (IOException e) {
            traceEnabled = false;
        }
    }

    private static void trace(String format, Object ... args) {
        if (!traceEnabled) {
            return;
        }
        try {
            tw.append("HDD: " + String.format(Locale.ROOT, format, args) + '\n');
            tw.flush();
        }
        catch (IOException e) {
            traceEnabled = false;
        }
    }
}

