/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.helpers;

import bk2010.util.Log;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public final class Tools {
    public static final Font monoFont;
    public static final int fontHeight;
    public static final int fontWidth;
    public static final int fontBase;
    private static final String[] fontPreferenceOrder;
    private static final int MONO_FONT_HEIGHT = 14;
    private static final String[] monoTests;
    static boolean doExtendedSearch;

    static {
        fontPreferenceOrder = new String[]{"Fira Source Retina Mono", "Fira Source Retina Mono Regular", "Fira Source Mono", "Fira Source Mono Regular", "Liberation Mono", "DejaVu Sans Mono", "Inconsolata LGC", "Inconsolata", "Lucida Console", "Consolas"};
        monoTests = new String[]{"\u042b", "0", "i", "1", "W", "_", "O", "o", "l", "z"};
        doExtendedSearch = false;
        Font found = null;
        int foundPref = Integer.MAX_VALUE;
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        FontRenderContext dummyFrc = new FontRenderContext(null, true, true);
        Font[] fontArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            String fname = font.getFontName();
            if (doExtendedSearch) {
                int testWidth = (int)Math.ceil(font.getStringBounds(" ", dummyFrc).getWidth());
                boolean isMono = true;
                String[] stringArray = monoTests;
                int n3 = monoTests.length;
                int n4 = 0;
                while (n4 < n3) {
                    String test = stringArray[n4];
                    if (testWidth != (int)Math.ceil(font.getStringBounds(test, dummyFrc).getWidth())) {
                        isMono = false;
                    }
                    ++n4;
                }
                if (isMono) {
                    Log.verbose("Found candidate font \"%s\"\n", fname);
                }
            }
            int i = 0;
            while (i < fontPreferenceOrder.length) {
                String pfont = fontPreferenceOrder[i];
                if (pfont.equalsIgnoreCase(fname)) {
                    Log.verbose("Found monospaced font \"%s\"\n", fname);
                    if (foundPref > i) {
                        found = font;
                        foundPref = i;
                    }
                }
                ++i;
            }
            ++n2;
        }
        if (found == null) {
            Log.warning("Cannot find any known monospaced font, using fallback ...");
            found = new Font("Monospaced", 0, 14);
        } else {
            found = found.deriveFont(0, 14.0f);
        }
        monoFont = found;
        Rectangle2D lm = monoFont.getStringBounds("0", dummyFrc);
        fontHeight = (int)Math.max(Math.ceil(lm.getHeight()), 10.0);
        fontWidth = (int)Math.ceil(lm.getWidth());
        fontBase = (int)(-lm.getMinY());
        Log.l("Using font %s (%dx%d) as monospaced.", monoFont.getName(), fontWidth, fontHeight);
    }

    public static void main(String[] args) {
        System.out.println("(GUI tools initialization test)");
    }
}

