/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.helpers;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class FileExtensionFilter
extends FileFilter {
    String root;
    String[] extensionList;
    String description;

    public FileExtensionFilter(File rootDirectory, String extensions, String description) {
        try {
            this.root = rootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            this.root = rootDirectory.getAbsolutePath();
        }
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        this.extensionList = extensions.split(";");
        this.description = description;
    }

    @Override
    public boolean accept(File f) {
        String path;
        if (!f.canRead()) {
            return false;
        }
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            path = f.getAbsolutePath();
        }
        if (path.startsWith(this.root)) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.extensionList == null) {
                return true;
            }
            path = path.toLowerCase();
            String[] stringArray = this.extensionList;
            int n = this.extensionList.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (path.endsWith(ext)) {
                    return true;
                }
                ++n2;
            }
        }
        return f.isDirectory() && this.root.startsWith(path);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

