/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dialogs;

import bk2010.gui.helpers.FileExtensionFilter;
import bk2010.gui.helpers.SlickTextField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class SelectFilePanel
extends JPanel {
    SlickTextField fileNameInput;
    File file;
    JFileChooser fileChooser;

    private void showSelectFileDialog(String path, String extensions, String typeDescription) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(path);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(new FileExtensionFilter(new File(path), extensions, typeDescription));
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.file = this.fileChooser.getSelectedFile();
        }
        if (this.file != null) {
            this.fileNameInput.setText(this.file.getPath());
        }
    }

    public File getFile() {
        return new File(this.fileNameInput.getText());
    }

    public SelectFilePanel(final String path, final String extensions, final String typeDescription) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select " + typeDescription));
        this.setLayout(new BoxLayout(this, 1));
        Box box = Box.createHorizontalBox();
        this.fileNameInput = new SlickTextField(path.length() + 32);
        this.fileNameInput.setText(path);
        this.fileNameInput.setEditable(true);
        box.add(this.fileNameInput);
        box.add(Box.createRigidArea(new Dimension(10, 1)));
        JButton jbBrowse = new JButton("Browse");
        jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFilePanel.this.showSelectFileDialog(path, extensions, typeDescription);
            }
        });
        box.add(jbBrowse);
        this.add(box);
    }
}

