/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dialogs;

import bk2010.gui.dialogs.AudioAndTapePanel;
import bk2010.gui.dialogs.ConfigurationDialog;
import bk2010.gui.dialogs.DiskMountPanel;
import bk2010.gui.dialogs.VideoPanel;
import bk2010.gui.helpers.RadioButtonPanel;
import bk2010.preferences.MachineConfiguration;
import bk2010.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class LauncherHWConfigurationDialog
extends ConfigurationDialog {
    private MachineConfiguration selectedConfiguration;

    public LauncherHWConfigurationDialog(MachineConfiguration mc) {
        super("BK2010 Launcher");
        this.selectedConfiguration = mc;
        this.setIconImage(ResourceManager.getEmulatorIcon());
        AbstractAction launchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = true;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        };
        AbstractAction quitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = false;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        };
        this.add((Component)new AudioAndTapePanel(this.selectedConfiguration), "North");
        Box leftPanel = Box.createVerticalBox();
        leftPanel.add(new RadioButtonPanel(this.selectedConfiguration.machine));
        leftPanel.add(Box.createVerticalGlue());
        leftPanel.add(new VideoPanel(this.selectedConfiguration));
        this.add((Component)leftPanel, "West");
        Box okExitpanel = Box.createHorizontalBox();
        okExitpanel.add(Box.createHorizontalGlue());
        JButton jbStart = new JButton("Start emulator");
        jbStart.addActionListener(launchAction);
        okExitpanel.add(jbStart);
        JButton jbExit = new JButton("Quit");
        jbExit.addActionListener(quitAction);
        okExitpanel.add(jbExit);
        okExitpanel.add(Box.createHorizontalGlue());
        InputMap imap = okExitpanel.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(10, 0), "Launch");
        imap.put(KeyStroke.getKeyStroke(27, 0), "Quit");
        ActionMap amap = okExitpanel.getActionMap();
        amap.put("Launch", launchAction);
        amap.put("Quit", quitAction);
        this.add((Component)okExitpanel, "South");
        Box rPanel = Box.createVerticalBox();
        rPanel.add(new DiskMountPanel("Drive A:", this.selectedConfiguration.diskA, true));
        rPanel.add(new DiskMountPanel("Drive B:", this.selectedConfiguration.diskB, true));
        rPanel.add(new DiskMountPanel("HDD:", this.selectedConfiguration.diskIDE0, false));
        rPanel.add(Box.createVerticalGlue());
        this.add((Component)rPanel, "Center");
        this.pack();
        this.center();
        jbStart.requestFocusInWindow();
    }

    public LauncherHWConfigurationDialog() {
        this(new MachineConfiguration());
    }

    public static MachineConfiguration invoke(MachineConfiguration mc) {
        LauncherHWConfigurationDialog dlg = new LauncherHWConfigurationDialog(mc);
        dlg.setVisible(true);
        dlg.dispose();
        dlg.selectedConfiguration.saveToFile();
        return dlg.selectedConfiguration;
    }

    public static void main(String[] args) {
        MachineConfiguration hwConf = new MachineConfiguration();
        hwConf.readFromFile();
        hwConf.parseCommandLine(args);
        LauncherHWConfigurationDialog.invoke(hwConf);
        System.exit(0);
    }
}

