/*
 * Decompiled with CFR 0.152.
 */
package bk2010;

import bk2010.Shutdownable;
import bk2010.util.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ShutdownMonitor {
    private static final Set<Shutdownable> toShutdown = Collections.synchronizedSet(new HashSet());
    private static volatile boolean shuttingDown = false;
    private static Object addRemoveMutex = new Object();

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownMonitorThread());
    }

    private ShutdownMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Shutdownable obj) {
        Object object = addRemoveMutex;
        synchronized (object) {
            if (shuttingDown) {
                obj.shutdown();
            } else {
                toShutdown.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(Shutdownable obj) {
        Object object = addRemoveMutex;
        synchronized (object) {
            block4: {
                if (!shuttingDown) break block4;
                return false;
            }
            return toShutdown.remove(obj);
        }
    }

    private static final class ShutdownMonitorThread
    extends Thread {
        private ShutdownMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            shuttingDown = true;
            Log.l("Emulator shutdown");
            Object object = addRemoveMutex;
            synchronized (object) {
                for (Shutdownable obj : toShutdown) {
                    Log.l(" .. " + obj.toString());
                    obj.shutdown();
                }
                toShutdown.clear();
            }
        }
    }
}

