/*
 * Decompiled with CFR 0.152.
 */
package bk2010;

import bk2010.DebuggerState;
import bk2010.HeartbeatListener;
import bk2010.Version;
import bk2010.gui.BK2010Display;
import bk2010.gui.BK2010ExclusiveDisplay;
import bk2010.gui.BK2010WindowedDisplay;
import bk2010.gui.NoExclusiveModeException;
import bk2010.gui.Palette;
import bk2010.gui.debugger.DebuggerFrame;
import bk2010.gui.debugger.memscape.MemScapePanel;
import bk2010.gui.dialogs.DiskChangeDialog;
import bk2010.gui.dialogs.LauncherHWConfigurationDialog;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.TimeScaler;
import bk2010.hardware.TimeSource;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.bus.registers.AZAY;
import bk2010.hardware.bus.registers.FDDController;
import bk2010.hardware.bus.registers.HDDControllerIO;
import bk2010.hardware.bus.registers.SimpleHDDController;
import bk2010.hardware.cpu.K1801VM1;
import bk2010.hardware.smk.HDD;
import bk2010.io.FakeTape;
import bk2010.io.FloppyDisk;
import bk2010.io.JoystickMapper;
import bk2010.io.KeyMapper;
import bk2010.io.Mouse;
import bk2010.preferences.ColorModes;
import bk2010.preferences.MachineConfiguration;
import bk2010.preferences.MonoColor;
import bk2010.preferences.WindowSizes;
import bk2010.preferences.types.Disk;
import bk2010.recorder.VideoRecorder;
import bk2010.sound.AY8910;
import bk2010.sound.NoSoundException;
import bk2010.sound.SoundRenderer;
import bk2010.sound.StreamOutput;
import bk2010.sound.WaveReader;
import bk2010.sound.WaveWriter;
import bk2010.util.BootLog;
import bk2010.util.Log;
import bk2010.util.Profiler;
import bk2010.util.ScreenshotSaver;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.UIManager;

public final class Emulator {
    static final int maxSkippedFrames = 4;
    long cyclesPerFrame;
    static boolean isSilent = true;
    static int screenshots = 0;
    protected boolean realHDD;
    protected final boolean debuggerEnabled;
    protected boolean debuggerOn;
    protected DebuggerFrame debugger;
    protected DebuggerState debuggerState;
    protected MemScapePanel msp;
    protected MachineConfiguration hwConf;
    protected BK2010Display display;
    protected BaseBK001x machine;
    protected K1801VM1 cpu;
    protected AY8910 synthA;
    protected AY8910 synthB;
    protected TimeSource clock12MHz;
    protected FloppyDisk driveA;
    protected FloppyDisk driveB;
    protected HDDControllerIO hdd;
    protected byte[] frameBuffer;
    protected byte[] targetBuffer;
    protected byte[] singleBuffer;
    protected byte[][] mixBuffers;
    protected boolean fakeTape;
    protected boolean cfg11M;
    protected boolean mixFrames;
    protected int frameToggle;
    BufferedImage renderedImage;
    BufferedImage displayImage;
    boolean drawUpscaled;
    VideoRecorder recorder;
    SoundRenderer sr;
    StreamOutput so;
    static final long FRAME_NANOS = 20000000L;
    static final long FRAMESKIP_SLACK_NANOS = 30000000L;
    static final long MAX_SLACK_NANOS = 100000000L;
    ArrayList<HeartbeatListener> hbListeners;

    public Emulator(MachineConfiguration hwc, BK2010Display bdp, boolean useUpscaled) throws IOException {
        block37: {
            int cmode;
            long CPUfreq;
            boolean cfgDiskBasic;
            this.realHDD = true;
            this.debuggerState = new DebuggerState();
            this.frameToggle = 0;
            this.hbListeners = new ArrayList();
            this.hwConf = hwc;
            this.display = bdp;
            this.drawUpscaled = useUpscaled;
            String machineConf = this.hwConf.machine.getSelectedName();
            boolean cfgSMK = machineConf.indexOf("SMK") >= 0;
            boolean cfgDisk = cfgSMK || machineConf.indexOf("DISK") >= 0;
            boolean bl = cfgDiskBasic = cfgDisk && machineConf.indexOf("BASIC") >= 0;
            if (machineConf.indexOf("11M") >= 0) {
                cfgDisk = true;
                cfgDiskBasic = false;
                this.cfg11M = true;
            } else {
                this.cfg11M = false;
            }
            if (this.cfg11M) {
                CPUfreq = 4000000L;
                this.cyclesPerFrame = 81920L;
            } else {
                CPUfreq = 3000000L;
                this.cyclesPerFrame = 61440L;
            }
            this.machine = new BaseBK001x(this.display.getMouse(), cfgSMK);
            this.cpu = new K1801VM1(this.machine);
            this.machine.timer.setTimeSource(this.cpu);
            this.clock12MHz = new TimeScaler(this.cpu, (int)(12000000L / CPUfreq));
            this.machine.setTimeSource(this.clock12MHz, 12000000);
            if (this.hwConf.doProfile) {
                this.cpu.setProfiler(new Profiler().setEnable(true));
            }
            if ((cmode = ColorModes.values[this.hwConf.colorMode.getSelected()]) == 3) {
                cmode = this.cfg11M ? 2 : 1;
            }
            this.machine.setColorMode(cmode);
            if (cfgDisk) {
                this.driveA = new FloppyDisk(CPUfreq);
                this.driveB = new FloppyDisk(CPUfreq);
                FDDController fdc = new FDDController(this.driveA, this.driveB, this.cpu);
                this.machine.attach(fdc);
                if (this.hwConf.diskA.doMount.getState()) {
                    this.driveA.mountImage(this.hwConf.diskA.imageFile, this.hwConf.diskA.readOnly.getState());
                }
                if (this.hwConf.diskB.doMount.getState()) {
                    this.driveB.mountImage(this.hwConf.diskB.imageFile, this.hwConf.diskB.readOnly.getState());
                }
                this.machine.setFDD10Model();
                if (cfgDiskBasic) {
                    fdc.setMemorySelector(this.machine, false);
                }
                if (this.cfg11M) {
                    if (cfgSMK) {
                        this.machine.setSMK11Model();
                        fdc.setMemorySelector(this.machine, true);
                        if (this.realHDD) {
                            this.hdd = new SimpleHDDController();
                            this.hdd.mount(new HDD(this.hwConf.diskIDE0.imageFile));
                        } else {
                            this.hdd = new HDDControllerIO();
                        }
                        this.machine.attach(this.hdd);
                    } else {
                        this.machine.setFDD11MModel();
                    }
                } else {
                    this.machine.writeWord(-24576, (short)95);
                    this.machine.writeWord(-24574, (short)-8192);
                }
            }
            this.fakeTape = hwc.fakeTape.getState();
            if (hwc.readTape.useTape.getState()) {
                this.machine.setTapeReader(new WaveReader(hwc.readTape.tapeFile));
            }
            if (!hwc.noSound.getState()) {
                try {
                    this.so = new StreamOutput();
                    this.sr = new SoundRenderer(this.so, this.cpu, (float)((double)CPUfreq / 48000.0));
                    this.sr.setFilterEnable(hwc.filterSound.getState());
                    if (hwc.AY.getSelected() != 0) {
                        this.synthA = new AY8910(62.5f);
                        this.synthB = new AY8910(62.5f);
                        this.machine.setSynths(this.synthA, this.synthB);
                        this.sr.setSynths(this.synthA, this.synthB);
                        this.machine.attach(new AZAY(this.synthA, this.synthB));
                    }
                    this.machine.setSoundRenderer(this.sr);
                    this.machine.setCovoxMode(hwc.Covox.getSelected());
                    isSilent = false;
                    if (!hwc.writeTape.useTape.getState()) break block37;
                    try {
                        this.so.setWaveWriter(new WaveWriter(hwc.writeTape.tapeFile));
                    }
                    catch (IOException e1) {
                        Log.error("Can't write to the tape file " + hwc.writeTape.tapeFile.getCanonicalPath());
                    }
                }
                catch (NoSoundException e) {
                    Log.error("Cannot initialize audio");
                    isSilent = true;
                }
                catch (Exception e) {
                    Log.error("Cannot initialize audio: unexpected exception " + e.getMessage());
                    isSilent = true;
                }
            } else {
                isSilent = true;
            }
        }
        IndexColorModel colorModel = Palette.getBK2010ColorModel();
        this.renderedImage = new BufferedImage(512, 256, 13, colorModel);
        this.displayImage = new BufferedImage(1024, 768, 13, colorModel);
        this.display.setDisplay(this.drawUpscaled ? this.displayImage : this.renderedImage);
        this.frameBuffer = new byte[131072];
        if (hwc.mixFrames.getState()) {
            this.mixFrames = true;
            this.mixBuffers = new byte[2][];
            this.mixBuffers[0] = new byte[131072];
            this.mixBuffers[1] = new byte[131072];
            this.targetBuffer = this.mixBuffers[this.frameToggle];
        } else {
            this.singleBuffer = this.frameBuffer;
            this.targetBuffer = this.frameBuffer;
        }
        this.machine.setRaster(this.targetBuffer);
        if (hwc.doRecordVideo) {
            this.recorder = new VideoRecorder(null, 512, 256, Palette.getBK2010Palette(), true);
        }
        this.cpu.reset();
        if (hwc.debugger.getState()) {
            if (hwc.fullScreen.getState()) {
                BootLog.l("Cannot enable debugger in fullscreen mode!");
                this.debuggerEnabled = false;
            } else {
                BootLog.l("Enabling debugger mode");
                this.debuggerEnabled = true;
                this.debugger = new DebuggerFrame(this.cpu, this.machine.timer, this.debuggerState);
                this.msp = MemScapePanel.createFramed();
                this.machine.addObserver(this.msp.display);
                this.msp.paintImmediately(0, 0, this.msp.getWidth(), this.msp.getHeight());
                this.display.requestFocus();
            }
        } else {
            this.debuggerEnabled = false;
        }
        String bin = hwc.launchBin;
        if (bin != null && bin != "") {
            BootLog.l("Forcing load of " + bin);
            int loadaddr = FakeTape.forceLoad(this.machine, bin, this.cfg11M) & 0xFFFE;
            if (loadaddr >= 0) {
                short resetAddr = (short)(this.cfg11M ? 49152 : 40960);
                int fillTo = Math.min(loadaddr, 512);
                int addr = 0;
                while (addr < fillTo) {
                    this.machine.writeWord(addr, resetAddr);
                    addr += 2;
                }
                if (loadaddr < 512) {
                    int sp = Math.max(loadaddr, 474) & 0xFFFE;
                    QBusReadDTO dto = new QBusReadDTO();
                    this.machine.peekWord(sp);
                    this.cpu.regs[7] = dto.value;
                    this.cpu.regs[6] = (short)(sp + 2);
                } else {
                    this.cpu.regs[7] = (short)loadaddr;
                    this.cpu.regs[6] = 510;
                }
            }
        }
        this.addHeartbeatListeners(this.machine.getHeartbeatListeners());
    }

    protected void doMixFrames() {
        byte[] lut = Palette.getBKColorMixLUT();
        byte[] t = this.frameBuffer;
        byte[] a = this.mixBuffers[0];
        byte[] b = this.mixBuffers[1];
        int i = 0;
        while (i < 131072) {
            t[i] = lut[a[i] & 0xFF | (b[i] & 0xFF) << 8];
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void runFrame() {
        block9: {
            oldFrame = this.machine.getFrameCounter();
            if (!this.cfg11M) ** GOTO lbl24
            while (this.machine.getFrameCounter() == oldFrame) {
                if (this.debuggerOn) {
                    this.debuggerOn = this.debugger.invokeDebugger();
                    if (!this.debuggerOn) {
                        this.display.requestFocus();
                    }
                }
                this.debuggerOn |= this.cpu.exec_insn(this.debuggerOn == false) & this.debuggerEnabled;
                if (this.fakeTape && (this.cpu.regs[7] & 65535) == 55692) {
                    FakeTape.fakeTape(this.machine, this.cpu.regs, true);
                }
                this.machine.updateRaster();
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                if (this.debuggerOn) {
                    this.debuggerOn = this.debugger.invokeDebugger();
                    if (!this.debuggerOn) {
                        this.display.requestFocus();
                    }
                }
                this.debuggerOn |= this.cpu.exec_insn(this.debuggerOn == false) & this.debuggerEnabled;
                if (this.fakeTape && (this.cpu.regs[7] & 65535) == 39998) {
                    FakeTape.fakeTape(this.machine, this.cpu.regs, false);
                }
                this.machine.updateRaster();
lbl24:
                // 2 sources

                ** while (this.machine.getFrameCounter() == oldFrame)
            }
        }
        if (this.cfg11M && this.machine.timerEnabled()) {
            this.cpu.irq2();
        }
    }

    protected boolean processInput() {
        KeyMapper keyMapper = this.display.getKeyMapper();
        int keyCode = keyMapper.pollKey();
        if (keyCode > -1) {
            this.machine.keyboard.punch((byte)keyCode);
        } else {
            this.machine.keyboard.setKeyDown(keyMapper.pollKeyHold());
        }
        int eventBits = keyMapper.pollEvents();
        if (!this.display.isFullScreen()) {
            Disk ndc;
            Disk dc;
            if ((eventBits & 0x20) != 0 && this.driveA != null && !(dc = this.hwConf.diskA).equals(ndc = DiskChangeDialog.invoke("Drive A:", dc))) {
                this.hwConf.diskA = ndc;
                this.driveA.unmountImage();
                if (ndc.doMount.getState()) {
                    this.driveA.mountImage(ndc.imageFile, ndc.readOnly.getState());
                }
            }
            if ((eventBits & 0x40) != 0 && this.driveB != null && !(dc = this.hwConf.diskB).equals(ndc = DiskChangeDialog.invoke("Drive B:", dc))) {
                this.hwConf.diskB = ndc;
                this.driveB.unmountImage();
                if (ndc.doMount.getState()) {
                    this.driveB.mountImage(ndc.imageFile, ndc.readOnly.getState());
                }
            }
        }
        if ((eventBits & 1) != 0 && this.machine.stopKeyEnabled()) {
            this.cpu.irq1();
        }
        if ((eventBits & 0x100) != 0) {
            this.machine.cycleVideomodes();
        }
        if ((eventBits & 0x200) != 0) {
            this.machine.forceGray();
        }
        if ((eventBits & 2) != 0) {
            this.machine.coldReset();
            this.cpu.reset();
        }
        if ((eventBits & 0x400) != 0) {
            this.takeScreenShot(false);
        }
        if ((eventBits & 0x1000) != 0) {
            this.takeScreenShot(true);
        }
        if ((eventBits & 0x800) != 0) {
            this.takeClipboardScreenShot(false);
        }
        if ((eventBits & 0x2000) != 0) {
            this.takeClipboardScreenShot(true);
        }
        if (this.debuggerEnabled) {
            if ((eventBits & 8) != 0) {
                this.cpu.toggleTracing();
            }
            if ((eventBits & 4) != 0) {
                this.debuggerOn = true;
            }
        }
        if ((eventBits & 0x10000) != 0) {
            return false;
        }
        this.machine.joystick.setState(keyMapper.getJoystickState());
        return true;
    }

    public void addHeartbeatListener(HeartbeatListener listener) {
        if (listener != null) {
            this.hbListeners.add(listener);
        }
    }

    public void addHeartbeatListeners(Collection<HeartbeatListener> listeners) {
        this.hbListeners.addAll(listeners);
    }

    public void runEmulator() {
        BootLog.l("Entering emulation loop");
        long expectedTimeNanos = System.nanoTime();
        while (!Thread.interrupted()) {
            this.runFrame();
            this.machine.updateRaster();
            if (this.mixFrames) {
                this.doMixFrames();
                this.frameToggle ^= 1;
                this.targetBuffer = this.mixBuffers[this.frameToggle];
                this.machine.setRaster(this.targetBuffer);
            }
            this.renderedImage.getRaster().setDataElements(0, 0, 512, 256, this.frameBuffer);
            Graphics2D g2 = this.displayImage.createGraphics();
            g2.drawImage(this.renderedImage, 0, 0, 1024, 768, null);
            g2.dispose();
            this.display.repaint();
            for (HeartbeatListener hbListener : this.hbListeners) {
                hbListener.invoke();
            }
            if (this.msp != null) {
                this.msp.display.newFrame();
            }
            if (this.recorder != null) {
                this.recorder.encodeFrame(this.frameBuffer);
            }
            expectedTimeNanos += 20000000L;
            if (!isSilent) {
                this.sr.push();
            } else {
                long currentTimeNanos = System.nanoTime();
                long slack = expectedTimeNanos - currentTimeNanos;
                if (slack < -100000000L) {
                    expectedTimeNanos -= slack;
                    Log.l("Stalled for %d us\n", (int)(-slack / 1000L));
                } else if (slack > 20000000L) {
                    try {
                        Thread.sleep(slack / 1000000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            if (!this.processInput()) break;
        }
        Log.l("\nRendered %d frames\n", this.machine.getFrameCounter());
        if (this.recorder != null) {
            try {
                this.recorder.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Log.l("Finished recording video");
        }
    }

    void takeScreenShot(boolean unscaled) {
        Log.l("Saving screenshot ...");
        ScreenshotSaver.save(unscaled ? this.renderedImage : this.displayImage);
    }

    void takeClipboardScreenShot(boolean unscaled) {
        Log.l("Saving screenshot to clipboard");
        ScreenshotSaver.saveToClipBoard(unscaled ? this.renderedImage : this.displayImage);
    }

    public static void main(String[] args) throws IOException {
        BootLog.l("BK2010 emulator version " + Version.get() + "\n");
        BootLog.l("Current date/time is " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        String systemLaF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(systemLaF);
            BootLog.l("Using the %s LaF as the system default.\n", systemLaF);
        }
        catch (Exception e) {
            Log.warning("Found the %s LaF as the system default, but could not use it because of: %s\n", systemLaF, e.getMessage());
        }
        MachineConfiguration hwConf = new MachineConfiguration();
        hwConf.readFromFile();
        if (!hwConf.parseCommandLine(args)) {
            LauncherHWConfigurationDialog.invoke(hwConf);
        }
        if (!hwConf.doLaunch) {
            System.exit(0);
        }
        String machineName = hwConf.machine.getSelectedName();
        BootLog.l("Starting up as " + machineName);
        JoystickMapper joyMapper = new JoystickMapper();
        KeyMapper keyMapper = new KeyMapper(joyMapper);
        Mouse mouse = new Mouse();
        int windowSizeIndex = hwConf.windowSize.getSelected();
        int[] windowSize = WindowSizes.sizes[windowSizeIndex];
        BaseBK001x.setMonochromeColor(MonoColor.values[hwConf.monoColor.getSelected()]);
        BK2010Display bkDisplay = null;
        if (hwConf.fullScreen.getState()) {
            try {
                BK2010ExclusiveDisplay exDisplay = new BK2010ExclusiveDisplay(keyMapper, mouse, machineName);
                bkDisplay = exDisplay;
                BootLog.l("Entered the fullscreen mode on " + exDisplay.getDeviceName());
            }
            catch (NoExclusiveModeException e) {
                BootLog.l("Unable to enter fullscreen mode");
            }
        }
        if (bkDisplay == null) {
            BootLog.l("Creating a %dx%d main window", windowSize[0], windowSize[1]);
            bkDisplay = new BK2010WindowedDisplay(keyMapper, mouse, windowSize[0], windowSize[1], machineName);
        }
        if (hwConf.noHUD) {
            bkDisplay.hideHUD();
        }
        boolean interpolated = false;
        boolean upscaled = windowSizeIndex > 1;
        switch (hwConf.interpolation.getSelected()) {
            case 0: {
                upscaled = false;
                break;
            }
            case 1: {
                interpolated = true;
                upscaled = false;
                break;
            }
            case 2: {
                interpolated = true;
                break;
            }
            default: {
                interpolated = true;
            }
        }
        BootLog.l("Pixel interpolation " + (interpolated ? "enabled" : "disabled"));
        if (upscaled) {
            BootLog.l(" ... in pixel edge mode");
        }
        bkDisplay.setInterpolate(interpolated);
        Emulator emu = new Emulator(hwConf, bkDisplay, upscaled);
        if (hwConf.doTrace) {
            short triggerAddress = hwConf.traceTrigger;
            if (triggerAddress == 0) {
                emu.cpu.enableTracing(true);
            } else {
                emu.cpu.setTraceTrigger(triggerAddress);
            }
        }
        emu.runEmulator();
        System.exit(0);
    }
}

