#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometrySubdivideParams
{
    uint max_faces_num;
    uint surfaces_num;
    uint surface_idx;
    uint attribute_mask;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _94;

layout(set = 0, binding = 2, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _97;

layout(set = 0, binding = 3, std140) uniform GeometrySubdivideParamsBuffer
{
    GeometrySubdivideParams geometry_subdivide_params;
} _120;

GeometryInformationAttribute GeometryInformationAttributeGetDefault(uint gat)
{
    GeometryInformationAttribute gia;
    gia.stride = 0u;
    gia.offset = 4294967295u;
    if (gat == 0u)
    {
        gia.stride = 3u;
    }
    if (gat == 1u)
    {
        gia.stride = 3u;
    }
    if (gat == 2u)
    {
        gia.stride = 3u;
    }
    if (gat == 3u)
    {
        gia.stride = 2u;
    }
    if (gat == 4u)
    {
        gia.stride = 2u;
    }
    if (gat == 5u)
    {
        gia.stride = 2u;
    }
    if (gat == 6u)
    {
        gia.stride = 1u;
    }
    if (gat == 7u)
    {
        gia.stride = 1u;
    }
    return gia;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    if (thread_idx == 0u)
    {
        _94.output_geometry_information.vtx_num += _97.input_geometry_information.vtx_num;
        _94.output_geometry_information.aux_tracking_1 = _94.output_geometry_information.vtx_num;
        _94.output_geometry_information.vtx_num += _94.output_geometry_information.aux_tracking_0;
        _94.output_geometry_information.surfaces_num = _120.geometry_subdivide_params.surfaces_num;
        _94.output_geometry_information.builtin_attribute_mask = 3u;
        _94.output_geometry_information.builtin_attribute_mask &= _97.input_geometry_information.builtin_attribute_mask;
        _94.output_geometry_information.builtin_attribute_mask &= _120.geometry_subdivide_params.attribute_mask;
        int i = 0;
        for (;;)
        {
            if (uint(i) < 8u)
            {
                _94.output_geometry_information.attributes[i].stride = _97.input_geometry_information.attributes[i].stride;
                _94.output_geometry_information.attributes[i].offset = 4294967295u;
                i++;
                continue;
            }
            else
            {
                break;
            }
        }
        bool input_has_custom0 = (_97.input_geometry_information.builtin_attribute_mask & 64u) != 0u;
        if ((_120.geometry_subdivide_params.export_factor_as_custom0 != 0) || input_has_custom0)
        {
            uint param = 6u;
            GeometryInformationAttribute gia_custom0 = GeometryInformationAttributeGetDefault(param);
            GeometryInformationAttribute _181;
            _181.offset = gia_custom0.offset;
            _181.stride = gia_custom0.stride;
            _181._pad0 = gia_custom0._pad0;
            _181._pad1 = gia_custom0._pad1;
            _94.output_geometry_information.attributes[6] = _181;
            _94.output_geometry_information.builtin_attribute_mask |= 64u;
        }
    }
}

 