#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 3, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _22;

layout(set = 0, binding = 4, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _38;

layout(set = 0, binding = 1, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

layout(set = 0, binding = 2, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _68;

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_22.geometry_copy_deform_params.surface_idx);
    uint src_vtx_num = _38.input_geometry_information.vtx_num;
    uint src_vtx_idx = thread_idx;
    for (;;)
    {
        if (src_vtx_idx < src_vtx_num)
        {
            vtx_copy_flag_data.data[src_vtx_idx] = src_vtx_idx + 1u;
            src_vtx_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
    _68.output_geometry_information.faces_num_per_surface[surface_idx] = _38.input_geometry_information.faces_num_per_surface[surface_idx];
    _68.output_geometry_information.vtx_num = _38.input_geometry_information.vtx_num;
}

 