#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    float param1;
    float param2;
    float param3;
    float param4;
    vec4 param_color;
    TextureResourceParams txt_params;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams params;
} _72;

layout(set = 0, binding = 3) uniform sampler2D sSource;
layout(set = 0, binding = 2, rgba16f) uniform writeonly image2D imDest;

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    float depth00 = texelFetch(sSource, ivec2(pixel_pos), 0).x;
    float depth10 = texelFetch(sSource, ivec2(pixel_pos) + ivec2(1, 0), 0).x;
    float depth01 = texelFetch(sSource, ivec2(pixel_pos) + ivec2(0, 1), 0).x;
    vec3 n00 = vec3(0.0, 0.0, depth00 * _72.params.param1);
    vec3 n10 = vec3(1.0, 0.0, depth10 * _72.params.param1);
    vec3 n01 = vec3(0.0, 1.0, depth01 * _72.params.param1);
    vec3 n = (cross(normalize(n10 - n00), normalize(n01 - n00)) * 0.5) + vec3(0.5);
    imageStore(imDest, ivec2(pixel_pos), vec4(n, 0.0));
}

 