#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct DrawElementsIndirectParams
{
    uint count;
    uint instance_count;
    uint first_index;
    uint base_vertex;
    uint base_instance;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 3, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _31;

layout(set = 0, binding = 1, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _44;

layout(set = 0, binding = 2, std430) buffer TransformedDataDrawIndirectParamsBuffer
{
    DrawElementsIndirectParams transformed_data_draw_indirect_params[];
} _99;

void main()
{
    if (gl_LocalInvocationIndex == 0u)
    {
        uint i = 0u;
        for (;;)
        {
            if (i < _31.transform_geometry_params.instance_idx)
            {
                uint num_faces = _44.transformed_data_location[i].last_face_idx + 1u;
                uint first_idx = 0u;
                if (i > 0u)
                {
                    num_faces -= (_44.transformed_data_location[i - 1u].last_face_idx + 1u);
                    first_idx = _44.transformed_data_location[i - 1u].last_face_idx + 1u;
                }
                bool _71 = _31.transform_geometry_params.raytrace != 0u;
                bool _78;
                if (_71)
                {
                    _78 = _44.transformed_data_location[i].raytrace == 0u;
                }
                else
                {
                    _78 = _71;
                }
                if (_78)
                {
                    num_faces = 0u;
                }
                bool _84 = _31.transform_geometry_params.voxelize != 0u;
                bool _92;
                if (_84)
                {
                    _92 = _44.transformed_data_location[i].voxelize == 0u;
                }
                else
                {
                    _92 = _84;
                }
                if (_92)
                {
                    num_faces = 0u;
                }
                _99.transformed_data_draw_indirect_params[i].count = num_faces * 3u;
                _99.transformed_data_draw_indirect_params[i].instance_count = 1u;
                _99.transformed_data_draw_indirect_params[i].first_index = first_idx * 3u;
                _99.transformed_data_draw_indirect_params[i].base_vertex = 0u;
                _99.transformed_data_draw_indirect_params[i].base_instance = 0u;
                i++;
                continue;
            }
            else
            {
                break;
            }
        }
    }
}

 