#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct CompositeParams
{
    float ssr_scaling_factor;
    int composite_output_mode;
    float raytrace_scaling_factor;
    float _pad1;
};

const float _531[7] = float[](0.071303434669971466064453125, 0.13151411712169647216796875, 0.189879238605499267578125, 0.2146064341068267822265625, 0.189879238605499267578125, 0.13151411712169647216796875, 0.071303434669971466064453125);

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float _pad0;
    float _pad1;
    float _pad2;
    vec2 taa_jitter;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _312;

layout(set = 0, binding = 2, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_params;
} _347;

layout(set = 0, binding = 3, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _637;

layout(set = 0, binding = 4, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 5, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1899;

layout(set = 0, binding = 11) uniform sampler2D sSSR;
layout(set = 0, binding = 12) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 13) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 14) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 15) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 16) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 17) uniform sampler2D sAlbedo;
layout(set = 0, binding = 18) uniform sampler2D sShadow;
layout(set = 0, binding = 19) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 20) uniform sampler2D sVoxelOcclusion;
layout(set = 0, binding = 21) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 22) uniform sampler2D sParticles;
layout(set = 0, binding = 23) uniform sampler2D sEmissive;
layout(set = 0, binding = 24) uniform sampler2D sRaytrace;
layout(set = 0, binding = 25) uniform sampler2D sDebug;
layout(set = 0, binding = 6, rgba32f) uniform readonly image2D imRaytraceHitDirectionPrimitiveIdReflection;
layout(set = 0, binding = 7, rgba32f) uniform readonly image2D imRaytraceHitDirectionPrimitiveIdTransparency;
layout(set = 0, binding = 8, rgba16f) uniform readonly image2D imRaytraceShadedReflection;
layout(set = 0, binding = 9, rgba16f) uniform readonly image2D imRaytraceShadedTransparency;
layout(set = 0, binding = 26) uniform sampler2D sWireframeColor;
layout(set = 0, binding = 27) uniform sampler2D sWireframeDepth;
layout(set = 0, binding = 10, rgba16f) uniform writeonly image2D imTarget;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _141;
    if (nor.x > 0.0)
    {
        _141 = -t;
    }
    else
    {
        _141 = t;
    }
    nor.x += _141;
    float _156;
    if (nor.y > 0.0)
    {
        _156 = -t;
    }
    else
    {
        _156 = t;
    }
    nor.y += _156;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _312.dispatch_setup.near_far_plane.z / ((_312.dispatch_setup.near_far_plane.y + _312.dispatch_setup.near_far_plane.x) - (d * _312.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_312.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec4 sample_ssr(inout vec2 p, float depth)
{
    p *= _347.composite_params.ssr_scaling_factor;
    float s = 0.0;
    vec4 v = vec4(0.0);
    float r = 10.5 * clamp(1.0 / depth, 0.5, 2.0);
    v = textureLod(sSSR, p, 0.0);
    s = v.w;
    vec4 _372 = v;
    vec3 _374 = _372.xyz * s;
    v.x = _374.x;
    v.y = _374.y;
    v.z = _374.z;
    int y = -2;
    for (;;)
    {
        if (y <= 2)
        {
            int x = -2;
            for (;;)
            {
                if (x <= 2)
                {
                    if ((x == 0) && (y == 0))
                    {
                        int _470 = x;
                        x = _470 + 1;
                        continue;
                    }
                    if (s < 1.0)
                    {
                        ivec2 smpl_pos = ivec2(p * _312.dispatch_setup.resolution) + ivec2(x, y);
                        vec3 blue_noise = texelFetch(s_BlueNoise, ivec3(smpl_pos % ivec2(128), 0), 0).xyz;
                        vec4 pxl = textureLod(sSSR, vec2(smpl_pos) * _312.dispatch_setup.inv_resolution, 0.0);
                        if (pxl.w > s)
                        {
                            vec3 _461 = pxl.xyz * pxl.w;
                            v.x = _461.x;
                            v.y = _461.y;
                            v.z = _461.z;
                            s = pxl.w;
                        }
                    }
                    int _470 = x;
                    x = _470 + 1;
                    continue;
                }
                else
                {
                    break;
                }
            }
            y++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec4(v.xyz, s);
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _637.composite_setup.fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _637.composite_setup.fill_color.xyz) + specular, 1.0);
}

vec4 sample_volumetric_fog(uvec2 pixel_pos, float ref_depth, uint ref_material_idx)
{
    vec4 c0 = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
    vec4 vc = vec4(0.0);
    float total_w = 1.0;
    int y = -3;
    for (;;)
    {
        if (y <= 3)
        {
            int x = -3;
            for (;;)
            {
                if (x <= 3)
                {
                    if ((x == 0) && (y == 0))
                    {
                        int _593 = x;
                        x = _593 + 1;
                        continue;
                    }
                    ivec2 sampling_pos = ivec2(pixel_pos) + ivec2(x, y);
                    float w = _531[x + 3] * _531[y + 3];
                    uvec4 param = texelFetch(sMetalnessRoughnessMaterialTags, sampling_pos, 0);
                    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
                    if (ref_material_idx != metalness_roughness_material_tags.material_index)
                    {
                        w = 0.0;
                    }
                    float depth = texelFetch(sTextureDepth, sampling_pos, 0).x;
                    if (abs(depth - ref_depth) > 0.00999999977648258209228515625)
                    {
                        w = 0.0;
                    }
                    if (w > 0.0)
                    {
                        vec4 c = texelFetch(sVolumetricFog, sampling_pos, 0);
                        vc += (c * w);
                        total_w += w;
                    }
                    int _593 = x;
                    x = _593 + 1;
                    continue;
                }
                else
                {
                    break;
                }
            }
            y++;
            continue;
        }
        else
        {
            break;
        }
    }
    return (c0 + vc) / vec4(total_w);
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_312.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_312.dispatch_setup.camera_projection_params.z) + ((_312.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _312.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_312.dispatch_setup.camera_projection_params.w) + ((_312.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _312.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 _728 = decode_normal(param);
    vec3 normal = _728;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    float voxel_occlusion_diffuse = 0.0;
    float voxel_occlusion_specular = 0.0;
    float voxel_occlusion_combined = 0.0;
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _312.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _312.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _312.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        voxel_occlusion_combined = voxel_light.w;
        vec2 voxel_occlusion = texelFetch(sVoxelOcclusion, ivec2(pixel_pos), 0).xy;
        voxel_occlusion_diffuse = voxel_occlusion.x;
        voxel_occlusion_specular = voxel_occlusion.y;
        vec4 color_1 = vec4(0.0);
        vec3 _826 = abs(local_normal);
        color_1.x = _826.x;
        color_1.y = _826.y;
        color_1.z = _826.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_637.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _637.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec4 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_5);
    uint materialIndex = metalness_roughness_material_tags.material_index;
    if (is_background == false)
    {
        MaterialPropertiesGPU _896;
        _896.diffuse = materials.material_properties[materialIndex].diffuse;
        _896.transparency = materials.material_properties[materialIndex].transparency;
        _896.emissive = materials.material_properties[materialIndex].emissive;
        _896.roughness = materials.material_properties[materialIndex].roughness;
        _896.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _896.refraction = materials.material_properties[materialIndex].refraction;
        _896.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _896.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _896.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _896.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _896.metalness = materials.material_properties[materialIndex].metalness;
        _896.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _896.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _896.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _896.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _896.flags = materials.material_properties[materialIndex].flags;
        _896._pad0 = materials.material_properties[materialIndex]._pad0;
        _896._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _896;
    }
    vec4 _897 = shadow;
    vec4 _905 = shadow;
    vec3 _907 = _905.xyz + ((_897.xyz * voxel_light.xyz) * _637.composite_setup.global_illumination_strength);
    shadow.x = _907.x;
    shadow.y = _907.y;
    shadow.z = _907.z;
    vec4 _919 = shadow;
    vec3 _921 = _919.xyz + (voxel_light.xyz * _637.composite_setup.global_illumination_base_strength);
    shadow.x = _921.x;
    shadow.y = _921.y;
    shadow.z = _921.z;
    if ((material.flags & 8u) != 0u)
    {
        vec2 param_6 = vec2(pixel_pos) * _312.dispatch_setup.inv_resolution;
        float param_7 = depth;
        vec4 _942 = sample_ssr(param_6, param_7);
        ssr = _942;
        ssr_factor = 1.0;
    }
    vec3 param_8 = world;
    vec3 param_9 = local_normal;
    vec3 param_10 = vec3(0.0);
    vec3 param_11 = vec3(0.0);
    float param_12 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_8, param_9, param_10, param_11, param_12);
    vec4 _959 = shadow;
    vec3 _961 = _959.xyz + fill_color.xyz;
    shadow.x = _961.x;
    shadow.y = _961.y;
    shadow.z = _961.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _984 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _637.composite_setup.ambient_color.xyz;
        color.x = _984.x;
        color.y = _984.y;
        color.z = _984.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _1003 = color;
    vec3 _1005 = _1003.xyz + (ssr.xyz * 4.0);
    color.x = _1005.x;
    color.y = _1005.y;
    color.z = _1005.z;
    vec4 _1014 = color;
    vec3 _1017 = _1014.xyz + vec3(shadow.w);
    color.x = _1017.x;
    color.y = _1017.y;
    color.z = _1017.z;
    if (_347.composite_params.composite_output_mode == 0)
    {
        float fog_density = linear_depth;
        if (_637.composite_setup.fog_range > 0.0)
        {
            fog_density /= _637.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _637.composite_setup.fog_height, 0.0, 1.0)) * _637.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _637.composite_setup.fog_color.xyz;
        vec4 _1070 = color;
        vec3 _1075 = mix(_1070.xyz, fog_color, vec3(fog_density));
        color.x = _1075.x;
        color.y = _1075.y;
        color.z = _1075.z;
        uvec2 param_13 = pixel_pos;
        float param_14 = depth;
        uint param_15 = materialIndex;
        vec4 volumetric_fog_color = sample_volumetric_fog(param_13, param_14, param_15);
        if (_637.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _1096 = volumetric_fog_color;
            vec3 _1101 = pow(_1096.xyz, vec3(_637.composite_setup.volumetric_fog_intensity));
            volumetric_fog_color.x = _1101.x;
            volumetric_fog_color.y = _1101.y;
            volumetric_fog_color.z = _1101.z;
        }
        float volumetric_fog_blend = volumetric_fog_color.w;
        if (true)
        {
            volumetric_fog_blend = 1.0 - volumetric_fog_blend;
            if (_637.composite_setup.volumetric_fog_strength > 0.0)
            {
                volumetric_fog_blend = exp((-volumetric_fog_blend) / _637.composite_setup.volumetric_fog_strength);
            }
            else
            {
                volumetric_fog_blend = 0.0;
            }
            volumetric_fog_blend = clamp(volumetric_fog_blend * _637.composite_setup.volumetric_fog_intensity, 0.0, 1.0);
        }
        vec4 _1133 = color;
        vec3 _1139 = mix(_1133.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _1139.x;
        color.y = _1139.y;
        color.z = _1139.z;
        if (_637.composite_setup.transparency_blend == 0u)
        {
            vec4 _1158 = color;
            vec3 _1160 = _1158.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _1160.x;
            color.y = _1160.y;
            color.z = _1160.z;
        }
        if (_637.composite_setup.transparency_blend == 1u)
        {
            vec4 _1172 = color;
            vec3 _1180 = mix(_1172.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _1180.x;
            color.y = _1180.y;
            color.z = _1180.z;
        }
    }
    else
    {
        if (_347.composite_params.composite_output_mode == 1)
        {
            color.x = albedo.xyz.x;
            color.y = albedo.xyz.y;
            color.z = albedo.xyz.z;
        }
        else
        {
            if (_347.composite_params.composite_output_mode == 2)
            {
                vec3 _1213 = texelFetch(sEmissive, ivec2(pixel_pos), 0).xyz;
                color.x = _1213.x;
                color.y = _1213.y;
                color.z = _1213.z;
            }
            else
            {
                if (_347.composite_params.composite_output_mode == 3)
                {
                    vec3 _1229 = (normal * 0.5) + vec3(0.5);
                    color.x = _1229.x;
                    color.y = _1229.y;
                    color.z = _1229.z;
                }
                else
                {
                    if (_347.composite_params.composite_output_mode == 4)
                    {
                        vec3 _1244 = vec3(metalness_roughness_material_tags.roughness);
                        color.x = _1244.x;
                        color.y = _1244.y;
                        color.z = _1244.z;
                    }
                    else
                    {
                        if (_347.composite_params.composite_output_mode == 5)
                        {
                            vec3 _1262 = texelFetch(sShadow, ivec2(pixel_pos), 0).xyz;
                            color.x = _1262.x;
                            color.y = _1262.y;
                            color.z = _1262.z;
                        }
                        else
                        {
                            if (_347.composite_params.composite_output_mode == 7)
                            {
                                vec3 _1289 = max(texelFetch(sShadow, ivec2(pixel_pos), 0).xyz, (albedo.xyz * voxel_light.xyz) * _637.composite_setup.global_illumination_strength);
                                color.x = _1289.x;
                                color.y = _1289.y;
                                color.z = _1289.z;
                            }
                            else
                            {
                                if (_347.composite_params.composite_output_mode == 6)
                                {
                                    vec3 _1307 = voxel_light.xyz * _637.composite_setup.global_illumination_strength;
                                    color.x = _1307.x;
                                    color.y = _1307.y;
                                    color.z = _1307.z;
                                }
                                else
                                {
                                    if (_347.composite_params.composite_output_mode == 8)
                                    {
                                        float vx_ao = 1.0 - max(voxel_occlusion_diffuse, 0.0);
                                        vx_ao = 0.1500000059604644775390625 + (vx_ao * 0.85000002384185791015625);
                                        vec3 _1330 = vec3(vx_ao);
                                        color.x = _1330.x;
                                        color.y = _1330.y;
                                        color.z = _1330.z;
                                    }
                                    else
                                    {
                                        if (_347.composite_params.composite_output_mode == 9)
                                        {
                                            float ao = 1.0 - max(voxel_occlusion_specular, 0.0);
                                            vec3 _1348 = vec3(ao);
                                            color.x = _1348.x;
                                            color.y = _1348.y;
                                            color.z = _1348.z;
                                        }
                                        else
                                        {
                                            if (_347.composite_params.composite_output_mode == 11)
                                            {
                                                float ss_ao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
                                                float vx_ao_1 = 1.0 - max(voxel_occlusion_diffuse, 0.0);
                                                vx_ao_1 = 0.1500000059604644775390625 + (vx_ao_1 * 0.85000002384185791015625);
                                                ss_ao = 1.0 - clamp((1.0 - ss_ao) * _637.composite_setup.occlusion_strength, 0.0, 1.0);
                                                vx_ao_1 = 1.0 - clamp((1.0 - vx_ao_1) * _637.composite_setup.occlusion_strength, 0.0, 1.0);
                                                float ao_1 = min(ss_ao, vx_ao_1);
                                                vec3 _1395 = vec3(ao_1);
                                                color.x = _1395.x;
                                                color.y = _1395.y;
                                                color.z = _1395.z;
                                            }
                                            else
                                            {
                                                if (_347.composite_params.composite_output_mode == 10)
                                                {
                                                    float hbao_1 = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
                                                    vec3 _1417 = vec3(hbao_1);
                                                    color.x = _1417.x;
                                                    color.y = _1417.y;
                                                    color.z = _1417.z;
                                                }
                                                else
                                                {
                                                    if (_347.composite_params.composite_output_mode == 12)
                                                    {
                                                        vec3 _1432 = vec3(float(materialIndex));
                                                        color.x = _1432.x;
                                                        color.y = _1432.y;
                                                        color.z = _1432.z;
                                                    }
                                                    else
                                                    {
                                                        if (_347.composite_params.composite_output_mode == 13)
                                                        {
                                                            uint material_flags = material.flags;
                                                            if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
                                                            {
                                                                material_flags &= 4294967280u;
                                                                material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
                                                            }
                                                            vec4 _1462 = color;
                                                            vec3 _1467 = clamp(_1462.xyz, vec3(0.0), vec3(1.0)) * 0.1500000059604644775390625;
                                                            color.x = _1467.x;
                                                            color.y = _1467.y;
                                                            color.z = _1467.z;
                                                            if ((material_flags & 1u) != 0u)
                                                            {
                                                                color.x = 1.0;
                                                            }
                                                            if ((material_flags & 32u) != 0u)
                                                            {
                                                                color.y = 1.0;
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if (_347.composite_params.composite_output_mode == 14)
                                                            {
                                                                vec3 _1503 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _347.composite_params.raytrace_scaling_factor), 0).xyz;
                                                                color.x = _1503.x;
                                                                color.y = _1503.y;
                                                                color.z = _1503.z;
                                                            }
                                                            else
                                                            {
                                                                if (_347.composite_params.composite_output_mode == 15)
                                                                {
                                                                    vec3 _1525 = texelFetch(sRaytrace, ivec2(vec2(pixel_pos) * _347.composite_params.raytrace_scaling_factor), 0).www;
                                                                    color.x = _1525.x;
                                                                    color.y = _1525.y;
                                                                    color.z = _1525.z;
                                                                }
                                                                else
                                                                {
                                                                    if (_347.composite_params.composite_output_mode == 16)
                                                                    {
                                                                        uvec2 param_16 = pixel_pos;
                                                                        float param_17 = depth;
                                                                        uint param_18 = materialIndex;
                                                                        vec4 f = sample_volumetric_fog(param_16, param_17, param_18);
                                                                        float blend = exp((-f.w) / _637.composite_setup.volumetric_fog_strength);
                                                                        color.x = f.xyz.x;
                                                                        color.y = f.xyz.y;
                                                                        color.z = f.xyz.z;
                                                                    }
                                                                    else
                                                                    {
                                                                        if (_347.composite_params.composite_output_mode == 17)
                                                                        {
                                                                            vec3 _1571 = abs(particles.xyz);
                                                                            color.x = _1571.x;
                                                                            color.y = _1571.y;
                                                                            color.z = _1571.z;
                                                                        }
                                                                        else
                                                                        {
                                                                            if (_347.composite_params.composite_output_mode == 18)
                                                                            {
                                                                                vec3 _1591 = vec3(fract(float(metalness_roughness_material_tags.component_tags) / 16.0));
                                                                                color.x = _1591.x;
                                                                                color.y = _1591.y;
                                                                                color.z = _1591.z;
                                                                            }
                                                                            else
                                                                            {
                                                                                if (_347.composite_params.composite_output_mode == 19)
                                                                                {
                                                                                    vec3 _1611 = texelFetch(sDebug, ivec2(pixel_pos), 0).xyz;
                                                                                    color.x = _1611.x;
                                                                                    color.y = _1611.y;
                                                                                    color.z = _1611.z;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (false)
    {
        vec4 hit_direction_primitiveID = imageLoad(imRaytraceHitDirectionPrimitiveIdReflection, ivec2(pixel_pos));
        float param_19 = hit_direction_primitiveID.w;
        uint hit_primitiveID = asuint(param_19);
        if (hit_primitiveID != 4294967295u)
        {
            float param_20 = fract(float(hit_primitiveID) * 0.13452999293804168701171875);
            vec3 _1644 = TurboColormap(param_20);
            vec3 _1648 = vec3(_1644);
            color.x = _1648.x;
            color.y = _1648.y;
            color.z = _1648.z;
        }
    }
    if (false)
    {
        vec4 hit_direction_primitiveID_1 = imageLoad(imRaytraceHitDirectionPrimitiveIdTransparency, ivec2(pixel_pos));
        float param_21 = hit_direction_primitiveID_1.w;
        uint hit_primitiveID_1 = asuint(param_21);
        if (hit_primitiveID_1 != 4294967295u)
        {
            float param_22 = fract(float(hit_primitiveID_1) * 0.13452999293804168701171875);
            vec3 _1677 = TurboColormap(param_22);
            vec3 _1681 = vec3(_1677);
            color.x = _1681.x;
            color.y = _1681.y;
            color.z = _1681.z;
        }
        else
        {
            color.x = 0.0;
        }
    }
    if (false)
    {
        vec4 rt_shaded_reflection = imageLoad(imRaytraceShadedReflection, ivec2(pixel_pos));
        if (rt_shaded_reflection.w != 0.0)
        {
            color.x = rt_shaded_reflection.xyz.x;
            color.y = rt_shaded_reflection.xyz.y;
            color.z = rt_shaded_reflection.xyz.z;
        }
    }
    if (false)
    {
        vec4 rt_shaded_transparency = imageLoad(imRaytraceShadedTransparency, ivec2(pixel_pos));
        if (rt_shaded_transparency.w != 0.0)
        {
            color.x = rt_shaded_transparency.xyz.x;
            color.y = rt_shaded_transparency.xyz.y;
            color.z = rt_shaded_transparency.xyz.z;
        }
    }
    if (false)
    {
        vec4 rt_shaded_reflection_1 = imageLoad(imRaytraceShadedReflection, ivec2(pixel_pos));
        vec4 rt_shaded_transparency_1 = imageLoad(imRaytraceShadedTransparency, ivec2(pixel_pos));
        if (rt_shaded_transparency_1.w != 0.0)
        {
            color.x = rt_shaded_transparency_1.xyz.x;
            color.y = rt_shaded_transparency_1.xyz.y;
            color.z = rt_shaded_transparency_1.xyz.z;
            vec4 _1761 = color;
            vec3 _1763 = _1761.xyz + rt_shaded_reflection_1.xyz;
            color.x = _1763.x;
            color.y = _1763.y;
            color.z = _1763.z;
        }
        else
        {
            color.x = 1.0;
            color.y = 1.0;
            color.z = 1.0;
        }
    }
    if (true)
    {
        int search_dist = 1;
        vec4 wc = texelFetch(sWireframeColor, ivec2(pixel_pos), 0);
        float wd = texelFetch(sWireframeDepth, ivec2(pixel_pos), 0).x;
        int _1798 = -search_dist;
        int iy = _1798;
        for (;;)
        {
            if (iy < search_dist)
            {
                int _1809 = -search_dist;
                int ix = _1809;
                for (;;)
                {
                    if (ix < search_dist)
                    {
                        if ((ix == 0) && (iy == 0))
                        {
                            int _1852 = ix;
                            ix = _1852 + 1;
                            continue;
                        }
                        float wd_neighborhood = texelFetch(sWireframeDepth, ivec2(pixel_pos) + ivec2(ix, iy), 0).x;
                        if (wd_neighborhood < wd)
                        {
                            wd = wd_neighborhood;
                            wc = texelFetch(sWireframeColor, ivec2(pixel_pos) + ivec2(ix, iy), 0);
                        }
                        int _1852 = ix;
                        ix = _1852 + 1;
                        continue;
                    }
                    else
                    {
                        break;
                    }
                }
                iy++;
                continue;
            }
            else
            {
                break;
            }
        }
        if (wd < 1.0)
        {
            bool _1862 = wd < depth;
            bool _1871;
            if (!_1862)
            {
                _1871 = (wd >= depth) && is_background;
            }
            else
            {
                _1871 = _1862;
            }
            if (_1871)
            {
                vec4 _1874 = color;
                vec3 _1883 = mix(_1874.xyz, wc.xyz, vec3(0.89999997615814208984375 * wc.w));
                color.x = _1883.x;
                color.y = _1883.y;
                color.z = _1883.z;
            }
            else
            {
                if (wd < 1.0)
                {
                    float t = float(_1899.globals.monotonic & 65535) * 1.10000002384185791015625;
                    float pattern = step(0.5, fract(t + (((float(pixel_pos.x) * _312.dispatch_setup.inv_resolution.x) + (float(pixel_pos.y) * _312.dispatch_setup.inv_resolution.y)) * 60.009998321533203125)));
                    pattern = (pattern * 0.4000000059604644775390625) + 0.60000002384185791015625;
                    vec4 _1932 = color;
                    vec3 _1943 = mix(_1932.xyz, (wc.xyz * pattern) * 0.5, vec3(0.89999997615814208984375 * wc.w));
                    color.x = _1943.x;
                    color.y = _1943.y;
                    color.z = _1943.z;
                }
            }
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 