#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _49
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    float transparency;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
    uint primitiveID;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _38;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _59;

layout(location = 1) in _49 vtx_input;

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

void main()
{
    MaterialPropertiesGPU _46;
    _46.diffuse = materials.material_properties[_38.materialIndex].diffuse;
    _46.transparency = materials.material_properties[_38.materialIndex].transparency;
    _46.emissive = materials.material_properties[_38.materialIndex].emissive;
    _46.roughness = materials.material_properties[_38.materialIndex].roughness;
    _46.triplanar_factor = materials.material_properties[_38.materialIndex].triplanar_factor;
    _46.refraction = materials.material_properties[_38.materialIndex].refraction;
    _46.normal_factor = materials.material_properties[_38.materialIndex].normal_factor;
    _46.emissive_factor = materials.material_properties[_38.materialIndex].emissive_factor;
    _46.temporal_accumulation_factor = materials.material_properties[_38.materialIndex].temporal_accumulation_factor;
    _46.shadowmap_bias = materials.material_properties[_38.materialIndex].shadowmap_bias;
    _46.metalness = materials.material_properties[_38.materialIndex].metalness;
    _46.albedo_sampler = materials.material_properties[_38.materialIndex].albedo_sampler;
    _46.emissive_sampler = materials.material_properties[_38.materialIndex].emissive_sampler;
    _46.normal_sampler = materials.material_properties[_38.materialIndex].normal_sampler;
    _46.metalic_roughness_sampler = materials.material_properties[_38.materialIndex].metalic_roughness_sampler;
    _46.flags = materials.material_properties[_38.materialIndex].flags;
    _46._pad0 = materials.material_properties[_38.materialIndex]._pad0;
    _46._pad1 = materials.material_properties[_38.materialIndex]._pad1;
    MaterialPropertiesGPU material = _46;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _59.transform_params.vCameraPosition;
    float factor = 1.0;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _38.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = 0.0;
    material_eval.metalness = 0.0;
    material_eval.transparency = 0.0;
    material_eval.is_discarded = false;
    material_eval.normal = vec3(0.0);
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    MaterialEvalInput eval_input;
    eval_input.uv0 = vtx_input.vUV0;
    eval_input.normal = vtx_input.vNorm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    eval_input.primitiveID = uint(gl_PrimitiveID);
    MaterialPropertiesGPU param = material;
    vec3 param_1 = worldPos;
    vec3 param_2 = vtx_input.vLocalPos;
    vec3 param_3 = vtx_input.vNorm;
    vec3 param_4 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param, param_1, param_2, param_3, param_4);
    if (to_discard)
    {
        discard;
    }
}

 