#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    int merge_op;
    int output_as_source2;
    float source1_factor;
    float source2_factor;
    float source1_base;
    float source2_base;
    int _pad0;
    int _pad1;
    vec2 source1_image_scale;
    vec2 source2_image_scale;
    TextureResourceParams source1_txt_params;
    TextureResourceParams source2_txt_params;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams texture_process_params;
} _115;

layout(set = 0, binding = 3) uniform sampler2D sSource1;
layout(set = 0, binding = 4) uniform sampler2D sSource2;
layout(set = 0, binding = 2, r16f) uniform image2D imDest;

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 s1_size = uvec2(textureSize(sSource1, 0));
    uvec2 s2_size = uvec2(textureSize(sSource2, 0));
    vec2 param = (vec2(pixel_pos) / vec2(s1_size)) * _115.texture_process_params.source1_image_scale;
    float param_1 = 0.0;
    TextureResourceParams _128;
    _128.flip_y = _115.texture_process_params.source1_txt_params.flip_y;
    _128.clamp_range_01 = _115.texture_process_params.source1_txt_params.clamp_range_01;
    _128.remap_range_start = _115.texture_process_params.source1_txt_params.remap_range_start;
    _128.remap_range_end = _115.texture_process_params.source1_txt_params.remap_range_end;
    TextureResourceParams param_2 = _128;
    vec4 _129 = texture_sample_lod_with_params(sSource1, param, param_1, param_2);
    vec4 s1 = _129;
    vec2 param_3 = (vec2(pixel_pos) / vec2(s2_size)) * _115.texture_process_params.source2_image_scale;
    float param_4 = 0.0;
    TextureResourceParams _146;
    _146.flip_y = _115.texture_process_params.source2_txt_params.flip_y;
    _146.clamp_range_01 = _115.texture_process_params.source2_txt_params.clamp_range_01;
    _146.remap_range_start = _115.texture_process_params.source2_txt_params.remap_range_start;
    _146.remap_range_end = _115.texture_process_params.source2_txt_params.remap_range_end;
    TextureResourceParams param_5 = _146;
    vec4 _147 = texture_sample_lod_with_params(sSource2, param_3, param_4, param_5);
    vec4 s2 = _147;
    if (_115.texture_process_params.output_as_source2 != 0)
    {
        s2 = imageLoad(imDest, ivec2(pixel_pos));
    }
    s1 = (s1 * _115.texture_process_params.source1_factor) + vec4(_115.texture_process_params.source1_base);
    s2 = (s2 * _115.texture_process_params.source2_factor) + vec4(_115.texture_process_params.source2_base);
    vec4 d = vec4(0.0);
    if (_115.texture_process_params.merge_op == 0)
    {
        d = s1;
    }
    else
    {
        if (_115.texture_process_params.merge_op == 1)
        {
            d = s1 + s2;
        }
        else
        {
            if (_115.texture_process_params.merge_op == 2)
            {
                d = s1 * s2;
            }
        }
    }
    bool _212 = isnan(d.x);
    bool _219;
    if (!_212)
    {
        _219 = isnan(d.y);
    }
    else
    {
        _219 = _212;
    }
    bool _227;
    if (!_219)
    {
        _227 = isnan(d.z);
    }
    else
    {
        _227 = _219;
    }
    bool _234;
    if (!_227)
    {
        _234 = isnan(d.z);
    }
    else
    {
        _234 = _227;
    }
    if (_234)
    {
        d = vec4(0.0);
    }
    bool _239 = isinf(d.x);
    bool _246;
    if (!_239)
    {
        _246 = isinf(d.y);
    }
    else
    {
        _246 = _239;
    }
    bool _253;
    if (!_246)
    {
        _253 = isinf(d.z);
    }
    else
    {
        _253 = _246;
    }
    bool _260;
    if (!_253)
    {
        _260 = isinf(d.z);
    }
    else
    {
        _260 = _253;
    }
    if (_260)
    {
        d = vec4(0.0);
    }
    imageStore(imDest, ivec2(pixel_pos), d);
}

 