#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct PostDepthOfFieldParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float far_plane;
    float debug_blur_size;
    float focus_depth;
    float focus_range;
    float adaptation_speed;
    int auto_focus;
    float auto_focus_area;
    int auto_focus_points;
    float auto_focus_bias;
    float ts;
    int _pad1;
    int _pad2;
};

struct PostDepthOfFieldDynamicParams
{
    float focus_depth;
    float focus_range;
    int initialized;
    int _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform PostDepthOfFieldParamsBuffer
{
    PostDepthOfFieldParams dof_params;
} _37;

layout(set = 1, binding = 2, std140) uniform PostDepthOfFieldDynamicParamsBuffer
{
    PostDepthOfFieldDynamicParams dof_dynamic_params;
} _170;

layout(set = 1, binding = 3) uniform sampler2D sCoCDepth;
layout(set = 1, binding = 4) uniform sampler2D sColor;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

vec3 depthOfField(vec2 texCoord, float focusPoint, float focusScale)
{
    vec2 coc_depth = texture(sCoCDepth, texCoord).xy;
    float centerDepth = coc_depth.y * _37.dof_params.far_plane;
    float centerSize = coc_depth.x;
    vec3 color = texture(sColor, texCoord).xyz;
    if (_37.dof_params.debug_blur_size != 0.0)
    {
        return vec3(centerSize * 0.00999999977648258209228515625);
    }
    if (focusPoint == 0.0)
    {
        return color;
    }
    float tot = 1.0;
    float radius = 0.699999988079071044921875;
    vec2 inv_resolution = vec2(0.0005208333604969084262847900390625, 0.000925925909541547298431396484375);
    float ang = 0.0;
    for (;;)
    {
        if (radius < 20.0)
        {
            vec2 tc = texCoord + ((vec2(cos(ang), sin(ang)) * inv_resolution) * radius);
            vec3 sampleColor = texture(sColor, tc).xyz;
            coc_depth = texture(sCoCDepth, tc).xy;
            float sampleDepth = coc_depth.y * _37.dof_params.far_plane;
            float sampleSize = coc_depth.x;
            if (sampleDepth > centerDepth)
            {
                sampleSize = clamp(sampleSize, 0.0, centerSize * 2.0);
            }
            float m = smoothstep(radius - 0.5, radius + 0.5, sampleSize);
            color += mix(color / vec3(tot), sampleColor, vec3(m));
            tot += 1.0;
            radius += (0.699999988079071044921875 / radius);
            ang += 2.3999631404876708984375;
            continue;
        }
        else
        {
            break;
        }
    }
    vec3 _159 = color;
    vec3 _161 = _159 / vec3(tot);
    color = _161;
    return _161;
}

void main()
{
    vec2 param = vTexcoord0;
    float param_1 = _170.dof_dynamic_params.focus_depth;
    float param_2 = _170.dof_dynamic_params.focus_range;
    vec3 c = depthOfField(param, param_1, param_2);
    outColor = vec4(c, 1.0);
}

 