#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _1990
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _277;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1549;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1560;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1648;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1840;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1881;

layout(set = 0, binding = 13, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1894;

layout(set = 0, binding = 14, std140) uniform VM1
{
    VertexModifierDisplaceParams VM1_params;
} _1909;

layout(set = 0, binding = 15, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _1929;

layout(set = 0, binding = 16, std140) uniform VM3
{
    VertexModifierDisplaceParams VM3_params;
} _1942;

layout(set = 0, binding = 17, std140) uniform VM4
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM4_params;
} _1962;

layout(set = 0, binding = 18, std140) uniform VM5
{
    VertexModifierDisplaceParams VM5_params;
} _1976;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2085;

layout(set = 0, binding = 19) uniform sampler2D s_NoiseRGBA;
layout(set = 0, binding = 20) uniform sampler2D s_Curves;

layout(location = 1) out _1990 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _277.geometry_information.attributes[0].stride;
    idx += _277.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _277.geometry_information.attributes[2].stride;
    idx += _277.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _277.geometry_information.attributes[1].stride;
    idx += _277.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _277.geometry_information.attributes[3].stride;
    idx += _277.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _277.geometry_information.attributes[6].stride;
    idx += _277.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    int k = -1;
    for (;;)
    {
        if (k <= 1)
        {
            int j = -1;
            for (;;)
            {
                if (j <= 1)
                {
                    int i = -1;
                    for (;;)
                    {
                        if (i <= 1)
                        {
                            vec3 b = vec3(float(i), float(j), float(k));
                            vec3 param = p + b;
                            vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                            float d = dot(r, r);
                            if (d < res.x)
                            {
                                id = dot(p + b, vec3(1.0, 57.0, 113.0));
                                res = vec2(d, res.x);
                            }
                            else
                            {
                                if (d < res.y)
                                {
                                    res.y = d;
                                }
                            }
                            i++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    j++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            k++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1122 = vector_transform_by_mat43(param, param_1);
        coords = _1122;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1129 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1129;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _927 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _927;
    return n;
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1073 = vector_transform_by_mat43(param, param_1);
        coords = _1073;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1080 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1080;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1234 = vector_transform_by_mat43(param, param_1);
        coords = _1234;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1245 = vector_transform_by_mat43(param_2, param_3);
            coords = _1245;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1255 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1255;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_1549.instance_params.stride > 0)
    {
        uint flipbook_card = _1560.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_277.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_277.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _1582 = vtx_coords_load(param);
    vtx_input.pos = _1582;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_277.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1600 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1600.x;
        vtx_input.color.y = _1600.y;
        vtx_input.color.z = _1600.z;
    }
    if ((_277.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1615 = vtx_normals_load(param_2);
        vtx_input.norm = _1615;
    }
    if ((_277.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1626 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1626;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_1549.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1648.instance_transform[(gl_InstanceIndex * _1549.instance_params.stride) + 0];
        vec4 inst_m1 = _1648.instance_transform[(gl_InstanceIndex * _1549.instance_params.stride) + 1];
        vec4 inst_m2 = _1648.instance_transform[(gl_InstanceIndex * _1549.instance_params.stride) + 2];
        vec3 _1679 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1679.x;
        mat_instance_model[0].y = _1679.y;
        mat_instance_model[0].z = _1679.z;
        vec3 _1692 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1692.x;
        mat_instance_model[1].y = _1692.y;
        mat_instance_model[1].z = _1692.z;
        vec3 _1705 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1705.x;
        mat_instance_model[2].y = _1705.y;
        mat_instance_model[2].z = _1705.z;
        vec3 _1718 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1718.x;
        mat_instance_model[3].y = _1718.y;
        mat_instance_model[3].z = _1718.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_1549.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1840.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_277.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1863 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1863;
    }
    if ((_277.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1874 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1874;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1881.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1881.transform_params.mModelInv;
    ModifierFactorNoise_Params _1899;
    _1899.transform_local_to_gizmo = _1894.VM0_params.transform_local_to_gizmo;
    _1899.noise_domain_scale = _1894.VM0_params.noise_domain_scale;
    _1899.modifier_function = _1894.VM0_params.modifier_function;
    _1899.noise_domain_offset = _1894.VM0_params.noise_domain_offset;
    _1899.noise_value_scale = _1894.VM0_params.noise_value_scale;
    _1899.noise_value_offset = _1894.VM0_params.noise_value_offset;
    _1899.influence_scope = _1894.VM0_params.influence_scope;
    _1899._pad0 = _1894.VM0_params._pad0;
    _1899._pad1 = _1894.VM0_params._pad1;
    ModifierFactorNoise_Params param_7 = _1899;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_noise_voronoi(param_7, param_8, param_9);
    modifier_factor = param_8;
    VertexModifierDisplaceParams _1914;
    _1914.displace_normal = _1909.VM1_params.displace_normal;
    _1914.displace_normal_modifier_factor = _1909.VM1_params.displace_normal_modifier_factor;
    _1914.displace_base = _1909.VM1_params.displace_base;
    _1914.displace_base_modifier_factor = _1909.VM1_params.displace_base_modifier_factor;
    _1914.influence_scope = _1909.VM1_params.influence_scope;
    VertexModifierDisplaceParams param_10 = _1914;
    ModifierFactor param_11 = modifier_factor;
    VertexInput param_12 = vtx_input;
    CoordinateSystemTrasforms param_13 = cs_transforms;
    vertex_modifier_displace_apply(param_10, param_11, param_12, param_13);
    modifier_factor = param_11;
    vtx_input = param_12;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorNoise_Params _1933;
    _1933.transform_local_to_gizmo = _1929.VM2_params.transform_local_to_gizmo;
    _1933.noise_domain_scale = _1929.VM2_params.noise_domain_scale;
    _1933.modifier_function = _1929.VM2_params.modifier_function;
    _1933.noise_domain_offset = _1929.VM2_params.noise_domain_offset;
    _1933.noise_value_scale = _1929.VM2_params.noise_value_scale;
    _1933.noise_value_offset = _1929.VM2_params.noise_value_offset;
    _1933.influence_scope = _1929.VM2_params.influence_scope;
    _1933._pad0 = _1929.VM2_params._pad0;
    _1933._pad1 = _1929.VM2_params._pad1;
    ModifierFactorNoise_Params param_14 = _1933;
    ModifierFactor param_15 = modifier_factor;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    modifier_factor_noise_simplex2(param_14, param_15, param_16);
    modifier_factor = param_15;
    VertexModifierDisplaceParams _1946;
    _1946.displace_normal = _1942.VM3_params.displace_normal;
    _1946.displace_normal_modifier_factor = _1942.VM3_params.displace_normal_modifier_factor;
    _1946.displace_base = _1942.VM3_params.displace_base;
    _1946.displace_base_modifier_factor = _1942.VM3_params.displace_base_modifier_factor;
    _1946.influence_scope = _1942.VM3_params.influence_scope;
    VertexModifierDisplaceParams param_17 = _1946;
    ModifierFactor param_18 = modifier_factor;
    VertexInput param_19 = vtx_input;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    vertex_modifier_displace_apply(param_17, param_18, param_19, param_20);
    modifier_factor = param_18;
    vtx_input = param_19;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorDistanceRadial_Params _1967;
    _1967.transform_local_to_gizmo = _1962.VM4_params.transform_local_to_gizmo;
    _1967.falloff_curve_idx = _1962.VM4_params.falloff_curve_idx;
    _1967.falloff_inverse = _1962.VM4_params.falloff_inverse;
    _1967.domain_repeat_x = _1962.VM4_params.domain_repeat_x;
    _1967.domain_repeat_y = _1962.VM4_params.domain_repeat_y;
    _1967.domain_repeat_z = _1962.VM4_params.domain_repeat_z;
    _1967.influence_scope = _1962.VM4_params.influence_scope;
    _1967.modifier_function = _1962.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_21 = _1967;
    ModifierFactor param_22 = modifier_factor;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    modifier_factor_distance_radial(param_21, param_22, param_23);
    modifier_factor = param_22;
    VertexModifierDisplaceParams _1980;
    _1980.displace_normal = _1976.VM5_params.displace_normal;
    _1980.displace_normal_modifier_factor = _1976.VM5_params.displace_normal_modifier_factor;
    _1980.displace_base = _1976.VM5_params.displace_base;
    _1980.displace_base_modifier_factor = _1976.VM5_params.displace_base_modifier_factor;
    _1980.influence_scope = _1976.VM5_params.influence_scope;
    VertexModifierDisplaceParams param_24 = _1980;
    ModifierFactor param_25 = modifier_factor;
    VertexInput param_26 = vtx_input;
    CoordinateSystemTrasforms param_27 = cs_transforms;
    vertex_modifier_displace_apply(param_24, param_25, param_26, param_27);
    modifier_factor = param_25;
    vtx_input = param_26;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_1549.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1648.instance_transform[(gl_InstanceIndex * _1549.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1648.instance_transform[(gl_InstanceIndex * _1549.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1648.instance_transform[(gl_InstanceIndex * _1549.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_28 = vtx_input.norm;
        mat4 param_29 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_28, param_29));
        vec2 _2091 = unpackHalf2x16(_2085.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _2091.x;
        inst_c.y = _2091.y;
        vec2 _2101 = unpackHalf2x16(_2085.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _2101.x;
        inst_c.w = _2101.y;
        vec4 _2107 = vtx_input.color;
        vec3 _2111 = _2107.xyz * inst_c.xyz;
        vtx_input.color.x = _2111.x;
        vtx_input.color.y = _2111.y;
        vtx_input.color.z = _2111.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_30 = vtx_input.pos;
    mat4 param_31 = _1881.transform_params.mModel;
    vec3 _2131 = vector_transform_by_mat43(param_30, param_31);
    vec3 vPosModel = _2131;
    vec3 param_32 = vtx_input.norm;
    mat4 param_33 = _1881.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_32, param_33);
    vec3 param_34 = vPosModel;
    mat4 param_35 = _1881.transform_params.mView;
    vec3 _2146 = vector_transform_by_mat43(param_34, param_35);
    vec3 vPosModelView = _2146;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1881.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1881.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1881.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1881.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_36 = vtx_output.vCoords;
    mat4 param_37 = _1881.transform_params.mProjection;
    vec4 _2199 = vector_transform_by_mat_projection(param_36, param_37);
    gl_Position = _2199;
}

 