#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 1, std430) buffer GPUOnlyMemoryAllocatorInfoBuffer
{
    uint offset;
    uint num_allocations;
    uint _pad0;
    uint _pad1;
} gpu_allocator_data;

layout(set = 0, binding = 3, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _221;

layout(set = 0, binding = 4, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _237;

layout(set = 0, binding = 2, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _248;

GeometryInformationAttribute GeometryInformationAttributeGetDefault(uint gat)
{
    GeometryInformationAttribute gia;
    gia.stride = 0u;
    gia.offset = 4294967295u;
    if (gat == 0u)
    {
        gia.stride = 3u;
    }
    if (gat == 1u)
    {
        gia.stride = 3u;
    }
    if (gat == 2u)
    {
        gia.stride = 3u;
    }
    if (gat == 3u)
    {
        gia.stride = 2u;
    }
    if (gat == 4u)
    {
        gia.stride = 2u;
    }
    if (gat == 5u)
    {
        gia.stride = 2u;
    }
    if (gat == 6u)
    {
        gia.stride = 1u;
    }
    if (gat == 7u)
    {
        gia.stride = 1u;
    }
    return gia;
}

GeometryInformation GPUMemoryAllocateForGeometry(inout GeometryInformation geometry_information)
{
    uint id = gl_GlobalInvocationID.x;
    uint allocation_size = 0u;
    uint faces_num = 0u;
    int i = 0;
    for (;;)
    {
        if (uint(i) < geometry_information.surfaces_num)
        {
            faces_num += geometry_information.faces_num_per_surface[i];
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    uint _124 = atomicAdd(gpu_allocator_data.offset, (faces_num * 3u) * 4u);
    uint idx_buffer_offset = _124;
    geometry_information.idx_buffer_offset = idx_buffer_offset / 4u;
    allocation_size += ((faces_num * 3u) * 4u);
    int i_1 = 0;
    for (;;)
    {
        if (uint(i_1) < 8u)
        {
            if (geometry_information.attributes[i_1].stride > 0u)
            {
                uint _159 = atomicAdd(gpu_allocator_data.offset, (geometry_information.vtx_num * geometry_information.attributes[i_1].stride) * 4u);
                uint attribute_buffer_offset = _159;
                geometry_information.attributes[i_1].offset = attribute_buffer_offset / 4u;
                allocation_size += ((geometry_information.vtx_num * geometry_information.attributes[i_1].stride) * 4u);
            }
            i_1++;
            continue;
        }
        else
        {
            break;
        }
    }
    geometry_information.vtx_num = 0u;
    int i_2 = 0;
    for (;;)
    {
        if (uint(i_2) < geometry_information.surfaces_num)
        {
            geometry_information.faces_num_per_surface[i_2] = 0u;
            i_2++;
            continue;
        }
        else
        {
            break;
        }
    }
    geometry_information.gpu_memory_allocation_size = allocation_size;
    geometry_information.gpu_memory_allocation_size_total = gpu_allocator_data.offset;
    geometry_information.is_gpu_allocated = 1u;
    uint _201 = atomicAdd(gpu_allocator_data.num_allocations, 1u);
    return geometry_information;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    if (thread_idx == 0u)
    {
        bool is_original_mesh = false;
        if (_221.input_geometry_information.is_gpu_allocated == 0u)
        {
            is_original_mesh = true;
        }
        bool allocate_copy = false;
        bool _243;
        if (!is_original_mesh)
        {
            _243 = _237.geometry_copy_deform_params.create_copy != 0;
        }
        else
        {
            _243 = is_original_mesh;
        }
        if (_243)
        {
            allocate_copy = true;
        }
        _248.output_geometry_information.surfaces_num = _221.input_geometry_information.surfaces_num;
        _248.output_geometry_information.builtin_attribute_mask = _221.input_geometry_information.builtin_attribute_mask;
        _248.output_geometry_information.builtin_attribute_mask &= uint(_237.geometry_copy_deform_params.attribute_mask);
        if (allocate_copy)
        {
            int i = 0;
            for (;;)
            {
                if (uint(i) < 8u)
                {
                    _248.output_geometry_information.attributes[i].stride = _221.input_geometry_information.attributes[i].stride;
                    _248.output_geometry_information.attributes[i].offset = 4294967295u;
                    i++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            if (_237.geometry_copy_deform_params.export_factor_as_custom0 != 0)
            {
                uint param = 6u;
                GeometryInformationAttribute gia_custom0 = GeometryInformationAttributeGetDefault(param);
                GeometryInformationAttribute _295;
                _295.offset = gia_custom0.offset;
                _295.stride = gia_custom0.stride;
                _295._pad0 = gia_custom0._pad0;
                _295._pad1 = gia_custom0._pad1;
                _248.output_geometry_information.attributes[6] = _295;
                _248.output_geometry_information.builtin_attribute_mask |= 64u;
            }
            uint vtx_num = _248.output_geometry_information.vtx_num;
            GeometryInformation _307;
            _307.vtx_num = _248.output_geometry_information.vtx_num;
            _307.surfaces_num = _248.output_geometry_information.surfaces_num;
            _307.builtin_attribute_mask = _248.output_geometry_information.builtin_attribute_mask;
            _307.flipbook_cards_num = _248.output_geometry_information.flipbook_cards_num;
            _307.idx_buffer_offset = _248.output_geometry_information.idx_buffer_offset;
            _307.is_gpu_allocated = _248.output_geometry_information.is_gpu_allocated;
            _307.gpu_memory_allocation_size = _248.output_geometry_information.gpu_memory_allocation_size;
            _307.gpu_memory_allocation_size_total = _248.output_geometry_information.gpu_memory_allocation_size_total;
            _307.aux_tracking_0 = _248.output_geometry_information.aux_tracking_0;
            _307.aux_tracking_1 = _248.output_geometry_information.aux_tracking_1;
            _307.aux_tracking_2 = _248.output_geometry_information.aux_tracking_2;
            _307.aux_tracking_3 = _248.output_geometry_information.aux_tracking_3;
            _307.attributes[0].offset = _248.output_geometry_information.attributes[0].offset;
            _307.attributes[0].stride = _248.output_geometry_information.attributes[0].stride;
            _307.attributes[0]._pad0 = _248.output_geometry_information.attributes[0]._pad0;
            _307.attributes[0]._pad1 = _248.output_geometry_information.attributes[0]._pad1;
            _307.attributes[1].offset = _248.output_geometry_information.attributes[1].offset;
            _307.attributes[1].stride = _248.output_geometry_information.attributes[1].stride;
            _307.attributes[1]._pad0 = _248.output_geometry_information.attributes[1]._pad0;
            _307.attributes[1]._pad1 = _248.output_geometry_information.attributes[1]._pad1;
            _307.attributes[2].offset = _248.output_geometry_information.attributes[2].offset;
            _307.attributes[2].stride = _248.output_geometry_information.attributes[2].stride;
            _307.attributes[2]._pad0 = _248.output_geometry_information.attributes[2]._pad0;
            _307.attributes[2]._pad1 = _248.output_geometry_information.attributes[2]._pad1;
            _307.attributes[3].offset = _248.output_geometry_information.attributes[3].offset;
            _307.attributes[3].stride = _248.output_geometry_information.attributes[3].stride;
            _307.attributes[3]._pad0 = _248.output_geometry_information.attributes[3]._pad0;
            _307.attributes[3]._pad1 = _248.output_geometry_information.attributes[3]._pad1;
            _307.attributes[4].offset = _248.output_geometry_information.attributes[4].offset;
            _307.attributes[4].stride = _248.output_geometry_information.attributes[4].stride;
            _307.attributes[4]._pad0 = _248.output_geometry_information.attributes[4]._pad0;
            _307.attributes[4]._pad1 = _248.output_geometry_information.attributes[4]._pad1;
            _307.attributes[5].offset = _248.output_geometry_information.attributes[5].offset;
            _307.attributes[5].stride = _248.output_geometry_information.attributes[5].stride;
            _307.attributes[5]._pad0 = _248.output_geometry_information.attributes[5]._pad0;
            _307.attributes[5]._pad1 = _248.output_geometry_information.attributes[5]._pad1;
            _307.attributes[6].offset = _248.output_geometry_information.attributes[6].offset;
            _307.attributes[6].stride = _248.output_geometry_information.attributes[6].stride;
            _307.attributes[6]._pad0 = _248.output_geometry_information.attributes[6]._pad0;
            _307.attributes[6]._pad1 = _248.output_geometry_information.attributes[6]._pad1;
            _307.attributes[7].offset = _248.output_geometry_information.attributes[7].offset;
            _307.attributes[7].stride = _248.output_geometry_information.attributes[7].stride;
            _307.attributes[7]._pad0 = _248.output_geometry_information.attributes[7]._pad0;
            _307.attributes[7]._pad1 = _248.output_geometry_information.attributes[7]._pad1;
            _307.faces_num_per_surface[0] = _248.output_geometry_information.faces_num_per_surface[0];
            _307.faces_num_per_surface[1] = _248.output_geometry_information.faces_num_per_surface[1];
            _307.faces_num_per_surface[2] = _248.output_geometry_information.faces_num_per_surface[2];
            _307.faces_num_per_surface[3] = _248.output_geometry_information.faces_num_per_surface[3];
            _307.faces_num_per_surface[4] = _248.output_geometry_information.faces_num_per_surface[4];
            _307.faces_num_per_surface[5] = _248.output_geometry_information.faces_num_per_surface[5];
            _307.faces_num_per_surface[6] = _248.output_geometry_information.faces_num_per_surface[6];
            _307.faces_num_per_surface[7] = _248.output_geometry_information.faces_num_per_surface[7];
            _307.faces_num_per_surface[8] = _248.output_geometry_information.faces_num_per_surface[8];
            _307.faces_num_per_surface[9] = _248.output_geometry_information.faces_num_per_surface[9];
            _307.faces_num_per_surface[10] = _248.output_geometry_information.faces_num_per_surface[10];
            _307.faces_num_per_surface[11] = _248.output_geometry_information.faces_num_per_surface[11];
            _307.faces_num_per_surface[12] = _248.output_geometry_information.faces_num_per_surface[12];
            _307.faces_num_per_surface[13] = _248.output_geometry_information.faces_num_per_surface[13];
            _307.faces_num_per_surface[14] = _248.output_geometry_information.faces_num_per_surface[14];
            _307.faces_num_per_surface[15] = _248.output_geometry_information.faces_num_per_surface[15];
            _307.faces_num_per_surface[16] = _248.output_geometry_information.faces_num_per_surface[16];
            _307.faces_num_per_surface[17] = _248.output_geometry_information.faces_num_per_surface[17];
            _307.faces_num_per_surface[18] = _248.output_geometry_information.faces_num_per_surface[18];
            _307.faces_num_per_surface[19] = _248.output_geometry_information.faces_num_per_surface[19];
            _307.faces_num_per_surface[20] = _248.output_geometry_information.faces_num_per_surface[20];
            _307.faces_num_per_surface[21] = _248.output_geometry_information.faces_num_per_surface[21];
            _307.faces_num_per_surface[22] = _248.output_geometry_information.faces_num_per_surface[22];
            _307.faces_num_per_surface[23] = _248.output_geometry_information.faces_num_per_surface[23];
            _307.faces_num_per_surface[24] = _248.output_geometry_information.faces_num_per_surface[24];
            _307.faces_num_per_surface[25] = _248.output_geometry_information.faces_num_per_surface[25];
            _307.faces_num_per_surface[26] = _248.output_geometry_information.faces_num_per_surface[26];
            _307.faces_num_per_surface[27] = _248.output_geometry_information.faces_num_per_surface[27];
            _307.faces_num_per_surface[28] = _248.output_geometry_information.faces_num_per_surface[28];
            _307.faces_num_per_surface[29] = _248.output_geometry_information.faces_num_per_surface[29];
            _307.faces_num_per_surface[30] = _248.output_geometry_information.faces_num_per_surface[30];
            _307.faces_num_per_surface[31] = _248.output_geometry_information.faces_num_per_surface[31];
            _307.faces_num_per_surface[32] = _248.output_geometry_information.faces_num_per_surface[32];
            _307.faces_num_per_surface[33] = _248.output_geometry_information.faces_num_per_surface[33];
            _307.faces_num_per_surface[34] = _248.output_geometry_information.faces_num_per_surface[34];
            _307.faces_num_per_surface[35] = _248.output_geometry_information.faces_num_per_surface[35];
            _307.faces_num_per_surface[36] = _248.output_geometry_information.faces_num_per_surface[36];
            _307.faces_num_per_surface[37] = _248.output_geometry_information.faces_num_per_surface[37];
            _307.faces_num_per_surface[38] = _248.output_geometry_information.faces_num_per_surface[38];
            _307.faces_num_per_surface[39] = _248.output_geometry_information.faces_num_per_surface[39];
            _307.faces_num_per_surface[40] = _248.output_geometry_information.faces_num_per_surface[40];
            _307.faces_num_per_surface[41] = _248.output_geometry_information.faces_num_per_surface[41];
            _307.faces_num_per_surface[42] = _248.output_geometry_information.faces_num_per_surface[42];
            _307.faces_num_per_surface[43] = _248.output_geometry_information.faces_num_per_surface[43];
            _307.faces_num_per_surface[44] = _248.output_geometry_information.faces_num_per_surface[44];
            _307.faces_num_per_surface[45] = _248.output_geometry_information.faces_num_per_surface[45];
            _307.faces_num_per_surface[46] = _248.output_geometry_information.faces_num_per_surface[46];
            _307.faces_num_per_surface[47] = _248.output_geometry_information.faces_num_per_surface[47];
            _307.faces_num_per_surface[48] = _248.output_geometry_information.faces_num_per_surface[48];
            _307.faces_num_per_surface[49] = _248.output_geometry_information.faces_num_per_surface[49];
            _307.faces_num_per_surface[50] = _248.output_geometry_information.faces_num_per_surface[50];
            _307.faces_num_per_surface[51] = _248.output_geometry_information.faces_num_per_surface[51];
            _307.faces_num_per_surface[52] = _248.output_geometry_information.faces_num_per_surface[52];
            _307.faces_num_per_surface[53] = _248.output_geometry_information.faces_num_per_surface[53];
            _307.faces_num_per_surface[54] = _248.output_geometry_information.faces_num_per_surface[54];
            _307.faces_num_per_surface[55] = _248.output_geometry_information.faces_num_per_surface[55];
            _307.faces_num_per_surface[56] = _248.output_geometry_information.faces_num_per_surface[56];
            _307.faces_num_per_surface[57] = _248.output_geometry_information.faces_num_per_surface[57];
            _307.faces_num_per_surface[58] = _248.output_geometry_information.faces_num_per_surface[58];
            _307.faces_num_per_surface[59] = _248.output_geometry_information.faces_num_per_surface[59];
            _307.faces_num_per_surface[60] = _248.output_geometry_information.faces_num_per_surface[60];
            _307.faces_num_per_surface[61] = _248.output_geometry_information.faces_num_per_surface[61];
            _307.faces_num_per_surface[62] = _248.output_geometry_information.faces_num_per_surface[62];
            _307.faces_num_per_surface[63] = _248.output_geometry_information.faces_num_per_surface[63];
            GeometryInformation param_1 = _307;
            GeometryInformation _308 = GPUMemoryAllocateForGeometry(param_1);
            GeometryInformation _310;
            _310.vtx_num = _308.vtx_num;
            _310.surfaces_num = _308.surfaces_num;
            _310.builtin_attribute_mask = _308.builtin_attribute_mask;
            _310.flipbook_cards_num = _308.flipbook_cards_num;
            _310.idx_buffer_offset = _308.idx_buffer_offset;
            _310.is_gpu_allocated = _308.is_gpu_allocated;
            _310.gpu_memory_allocation_size = _308.gpu_memory_allocation_size;
            _310.gpu_memory_allocation_size_total = _308.gpu_memory_allocation_size_total;
            _310.aux_tracking_0 = _308.aux_tracking_0;
            _310.aux_tracking_1 = _308.aux_tracking_1;
            _310.aux_tracking_2 = _308.aux_tracking_2;
            _310.aux_tracking_3 = _308.aux_tracking_3;
            _310.attributes[0].offset = _308.attributes[0].offset;
            _310.attributes[0].stride = _308.attributes[0].stride;
            _310.attributes[0]._pad0 = _308.attributes[0]._pad0;
            _310.attributes[0]._pad1 = _308.attributes[0]._pad1;
            _310.attributes[1].offset = _308.attributes[1].offset;
            _310.attributes[1].stride = _308.attributes[1].stride;
            _310.attributes[1]._pad0 = _308.attributes[1]._pad0;
            _310.attributes[1]._pad1 = _308.attributes[1]._pad1;
            _310.attributes[2].offset = _308.attributes[2].offset;
            _310.attributes[2].stride = _308.attributes[2].stride;
            _310.attributes[2]._pad0 = _308.attributes[2]._pad0;
            _310.attributes[2]._pad1 = _308.attributes[2]._pad1;
            _310.attributes[3].offset = _308.attributes[3].offset;
            _310.attributes[3].stride = _308.attributes[3].stride;
            _310.attributes[3]._pad0 = _308.attributes[3]._pad0;
            _310.attributes[3]._pad1 = _308.attributes[3]._pad1;
            _310.attributes[4].offset = _308.attributes[4].offset;
            _310.attributes[4].stride = _308.attributes[4].stride;
            _310.attributes[4]._pad0 = _308.attributes[4]._pad0;
            _310.attributes[4]._pad1 = _308.attributes[4]._pad1;
            _310.attributes[5].offset = _308.attributes[5].offset;
            _310.attributes[5].stride = _308.attributes[5].stride;
            _310.attributes[5]._pad0 = _308.attributes[5]._pad0;
            _310.attributes[5]._pad1 = _308.attributes[5]._pad1;
            _310.attributes[6].offset = _308.attributes[6].offset;
            _310.attributes[6].stride = _308.attributes[6].stride;
            _310.attributes[6]._pad0 = _308.attributes[6]._pad0;
            _310.attributes[6]._pad1 = _308.attributes[6]._pad1;
            _310.attributes[7].offset = _308.attributes[7].offset;
            _310.attributes[7].stride = _308.attributes[7].stride;
            _310.attributes[7]._pad0 = _308.attributes[7]._pad0;
            _310.attributes[7]._pad1 = _308.attributes[7]._pad1;
            _310.faces_num_per_surface[0] = _308.faces_num_per_surface[0];
            _310.faces_num_per_surface[1] = _308.faces_num_per_surface[1];
            _310.faces_num_per_surface[2] = _308.faces_num_per_surface[2];
            _310.faces_num_per_surface[3] = _308.faces_num_per_surface[3];
            _310.faces_num_per_surface[4] = _308.faces_num_per_surface[4];
            _310.faces_num_per_surface[5] = _308.faces_num_per_surface[5];
            _310.faces_num_per_surface[6] = _308.faces_num_per_surface[6];
            _310.faces_num_per_surface[7] = _308.faces_num_per_surface[7];
            _310.faces_num_per_surface[8] = _308.faces_num_per_surface[8];
            _310.faces_num_per_surface[9] = _308.faces_num_per_surface[9];
            _310.faces_num_per_surface[10] = _308.faces_num_per_surface[10];
            _310.faces_num_per_surface[11] = _308.faces_num_per_surface[11];
            _310.faces_num_per_surface[12] = _308.faces_num_per_surface[12];
            _310.faces_num_per_surface[13] = _308.faces_num_per_surface[13];
            _310.faces_num_per_surface[14] = _308.faces_num_per_surface[14];
            _310.faces_num_per_surface[15] = _308.faces_num_per_surface[15];
            _310.faces_num_per_surface[16] = _308.faces_num_per_surface[16];
            _310.faces_num_per_surface[17] = _308.faces_num_per_surface[17];
            _310.faces_num_per_surface[18] = _308.faces_num_per_surface[18];
            _310.faces_num_per_surface[19] = _308.faces_num_per_surface[19];
            _310.faces_num_per_surface[20] = _308.faces_num_per_surface[20];
            _310.faces_num_per_surface[21] = _308.faces_num_per_surface[21];
            _310.faces_num_per_surface[22] = _308.faces_num_per_surface[22];
            _310.faces_num_per_surface[23] = _308.faces_num_per_surface[23];
            _310.faces_num_per_surface[24] = _308.faces_num_per_surface[24];
            _310.faces_num_per_surface[25] = _308.faces_num_per_surface[25];
            _310.faces_num_per_surface[26] = _308.faces_num_per_surface[26];
            _310.faces_num_per_surface[27] = _308.faces_num_per_surface[27];
            _310.faces_num_per_surface[28] = _308.faces_num_per_surface[28];
            _310.faces_num_per_surface[29] = _308.faces_num_per_surface[29];
            _310.faces_num_per_surface[30] = _308.faces_num_per_surface[30];
            _310.faces_num_per_surface[31] = _308.faces_num_per_surface[31];
            _310.faces_num_per_surface[32] = _308.faces_num_per_surface[32];
            _310.faces_num_per_surface[33] = _308.faces_num_per_surface[33];
            _310.faces_num_per_surface[34] = _308.faces_num_per_surface[34];
            _310.faces_num_per_surface[35] = _308.faces_num_per_surface[35];
            _310.faces_num_per_surface[36] = _308.faces_num_per_surface[36];
            _310.faces_num_per_surface[37] = _308.faces_num_per_surface[37];
            _310.faces_num_per_surface[38] = _308.faces_num_per_surface[38];
            _310.faces_num_per_surface[39] = _308.faces_num_per_surface[39];
            _310.faces_num_per_surface[40] = _308.faces_num_per_surface[40];
            _310.faces_num_per_surface[41] = _308.faces_num_per_surface[41];
            _310.faces_num_per_surface[42] = _308.faces_num_per_surface[42];
            _310.faces_num_per_surface[43] = _308.faces_num_per_surface[43];
            _310.faces_num_per_surface[44] = _308.faces_num_per_surface[44];
            _310.faces_num_per_surface[45] = _308.faces_num_per_surface[45];
            _310.faces_num_per_surface[46] = _308.faces_num_per_surface[46];
            _310.faces_num_per_surface[47] = _308.faces_num_per_surface[47];
            _310.faces_num_per_surface[48] = _308.faces_num_per_surface[48];
            _310.faces_num_per_surface[49] = _308.faces_num_per_surface[49];
            _310.faces_num_per_surface[50] = _308.faces_num_per_surface[50];
            _310.faces_num_per_surface[51] = _308.faces_num_per_surface[51];
            _310.faces_num_per_surface[52] = _308.faces_num_per_surface[52];
            _310.faces_num_per_surface[53] = _308.faces_num_per_surface[53];
            _310.faces_num_per_surface[54] = _308.faces_num_per_surface[54];
            _310.faces_num_per_surface[55] = _308.faces_num_per_surface[55];
            _310.faces_num_per_surface[56] = _308.faces_num_per_surface[56];
            _310.faces_num_per_surface[57] = _308.faces_num_per_surface[57];
            _310.faces_num_per_surface[58] = _308.faces_num_per_surface[58];
            _310.faces_num_per_surface[59] = _308.faces_num_per_surface[59];
            _310.faces_num_per_surface[60] = _308.faces_num_per_surface[60];
            _310.faces_num_per_surface[61] = _308.faces_num_per_surface[61];
            _310.faces_num_per_surface[62] = _308.faces_num_per_surface[62];
            _310.faces_num_per_surface[63] = _308.faces_num_per_surface[63];
            _248.output_geometry_information = _310;
            _248.output_geometry_information.vtx_num = vtx_num;
            int i_1 = 0;
            for (;;)
            {
                if (uint(i_1) < _221.input_geometry_information.surfaces_num)
                {
                    _248.output_geometry_information.faces_num_per_surface[i_1] = 0u;
                    i_1++;
                    continue;
                }
                else
                {
                    break;
                }
            }
        }
        else
        {
            int i_2 = 0;
            for (;;)
            {
                if (uint(i_2) < 8u)
                {
                    _248.output_geometry_information.attributes[i_2].stride = _221.input_geometry_information.attributes[i_2].stride;
                    _248.output_geometry_information.attributes[i_2].offset = _221.input_geometry_information.attributes[i_2].offset;
                    i_2++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            if ((_248.output_geometry_information.builtin_attribute_mask & 64u) == 0u)
            {
                if (_237.geometry_copy_deform_params.export_factor_as_custom0 != 0)
                {
                    uint param_2 = 6u;
                    GeometryInformationAttribute gia_custom0_1 = GeometryInformationAttributeGetDefault(param_2);
                    GeometryInformationAttribute _366;
                    _366.offset = gia_custom0_1.offset;
                    _366.stride = gia_custom0_1.stride;
                    _366._pad0 = gia_custom0_1._pad0;
                    _366._pad1 = gia_custom0_1._pad1;
                    _248.output_geometry_information.attributes[6] = _366;
                    _248.output_geometry_information.builtin_attribute_mask |= 64u;
                }
            }
            _248.output_geometry_information.idx_buffer_offset = _221.input_geometry_information.idx_buffer_offset;
            _248.output_geometry_information.gpu_memory_allocation_size = 0u;
            _248.output_geometry_information.gpu_memory_allocation_size_total = _221.input_geometry_information.gpu_memory_allocation_size_total;
            _248.output_geometry_information.vtx_num = 0u;
            int i_3 = 0;
            for (;;)
            {
                if (uint(i_3) < _221.input_geometry_information.surfaces_num)
                {
                    _248.output_geometry_information.faces_num_per_surface[i_3] = 0u;
                    i_3++;
                    continue;
                }
                else
                {
                    break;
                }
            }
        }
    }
}

 