#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct _1586
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _302;

layout(set = 0, binding = 4, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _342;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1107;

layout(set = 0, binding = 6, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1120;

layout(set = 0, binding = 7, std140) uniform VM1
{
    VertexModifierColorizeParams VM1_params;
} _1135;

layout(set = 0, binding = 2, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 3, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 9) uniform sampler2D s_Gradients;

layout(location = 0) out uint instanceID;
layout(location = 1) out _1586 vtx_output;

bool prt_is_alive(uint id)
{
    return _302.prt_states[id].life_time < _302.prt_states[id].life_span;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _342.ribbon_render_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _342.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _342.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _342.ribbon_render_params.max_segments;
    }
    int vidx = ((ribbon_segment * _342.ribbon_render_params.particles_per_segment) + ribbon_id) + _342.ribbon_render_params.base_idx;
    return vidx;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _302.prt_states[id].color;
    vec3 _329 = color_convert_uint_to_float3(param);
    c.x = _329.x;
    c.y = _329.y;
    c.z = _329.z;
    return c;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _904 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _904;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _922 = vector_transform_by_mat43(param, param_1);
        coords = _922;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _929 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _929;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _1057 = vtx.color;
    vec3 _1063 = mix(_1057.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _1063.x;
    vtx.color.y = _1063.y;
    vtx.color.z = _1063.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

vec3 apply_vtx_modifier(inout vec3 pos, vec3 norm, inout vec3 color, uint ribbon_id)
{
    VertexInput vtx_input;
    vtx_input.id = ribbon_id;
    vtx_input.pos = pos;
    vtx_input.norm = norm;
    vtx_input.color = vec4(color, 1.0);
    vtx_input.uv0 = vec2(0.0);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = ribbon_id;
    modifier_factor.id = ribbon_id;
    modifier_factor.instance_id = ribbon_id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1107.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _1107.transform_params.mModelInv;
    ModifierFactorNoise_Params _1125;
    _1125.transform_local_to_gizmo = _1120.VM0_params.transform_local_to_gizmo;
    _1125.noise_domain_scale = _1120.VM0_params.noise_domain_scale;
    _1125.modifier_function = _1120.VM0_params.modifier_function;
    _1125.noise_domain_offset = _1120.VM0_params.noise_domain_offset;
    _1125.noise_value_scale = _1120.VM0_params.noise_value_scale;
    _1125.noise_value_offset = _1120.VM0_params.noise_value_offset;
    _1125.influence_scope = _1120.VM0_params.influence_scope;
    _1125._pad0 = _1120.VM0_params._pad0;
    _1125._pad1 = _1120.VM0_params._pad1;
    ModifierFactorNoise_Params param = _1125;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_simplex2(param, param_1, param_2);
    modifier_factor = param_1;
    VertexModifierColorizeParams _1140;
    _1140.color = _1135.VM1_params.color;
    _1140.alpha = _1135.VM1_params.alpha;
    _1140.use_gradient = _1135.VM1_params.use_gradient;
    _1140.color_blend = _1135.VM1_params.color_blend;
    _1140.alpha_blend = _1135.VM1_params.alpha_blend;
    _1140.color_gradient_idx = _1135.VM1_params.color_gradient_idx;
    _1140.mixing_mode = _1135.VM1_params.mixing_mode;
    VertexModifierColorizeParams param_3 = _1140;
    ModifierFactor param_4 = modifier_factor;
    VertexInput param_5 = vtx_input;
    vertex_modifier_colorize_apply(param_3, param_4, param_5);
    modifier_factor = param_4;
    vtx_input = param_5;
    pos = vtx_input.pos;
    color = vtx_input.color.xyz;
    return pos;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _319;
    _319.life_time = _302.prt_states[id].life_time;
    _319.life_span = _302.prt_states[id].life_span;
    _319.generation_id = _302.prt_states[id].generation_id;
    _319.color = _302.prt_states[id].color;
    ParticleState _318 = _319;
    return _318;
}

vec3 get_ribbon_transformed_segment_position(int ribbon_id, int segment_idx)
{
    int param = ribbon_id;
    int param_1 = segment_idx;
    int _1161 = calculate_vidx_for_ribbon_segment(param, param_1);
    int vidx = _1161;
    vec3 p = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 dummy_normal = vec3(0.0);
    vec3 dummy_color = vec3(0.0);
    vec3 param_2 = p;
    vec3 param_3 = dummy_normal;
    vec3 param_4 = dummy_color;
    uint param_5 = uint(ribbon_id);
    vec3 _1195 = apply_vtx_modifier(param_2, param_3, param_4, param_5);
    dummy_color = param_4;
    vec3 modified_p = _1195;
    vec3 param_6 = modified_p;
    mat4 param_7 = _1107.transform_params.mModelView;
    vec3 _1202 = vector_transform_by_mat43(param_6, param_7);
    return _1202;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 ray_cyl_intersect(vec3 ro, vec3 rd, vec3 cb, vec3 ca, float cr)
{
    vec3 oc = ro - cb;
    float caca = dot(ca, ca);
    float card = dot(ca, rd);
    float caoc = dot(ca, oc);
    float a = 1.0 - (card * card);
    float b = dot(oc, rd) - (caoc * card);
    float c = (dot(oc, oc) - (caoc * caoc)) - (cr * cr);
    float h = (b * b) - (a * c);
    if (h < 0.0)
    {
        return vec4(-1.0);
    }
    h = sqrt(h);
    float t = ((-b) - h) / a;
    float y = caoc + (t * card);
    vec3 n = ((oc + (rd * t)) - ((ca * y) / vec3(caca))) / vec3(cr);
    return vec4(t, n.x, n.y, n.z);
}

void main()
{
    instanceID = uint(gl_InstanceIndex);
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    if (_342.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        ribbon_segment = gl_VertexIndex / 2;
    }
    else
    {
        uint max_segments_uint = uint(_342.ribbon_render_params.max_segments);
        ribbon_segment = gl_VertexIndex / 2;
        ribbon_id = (gl_InstanceIndex * 64) + int(uint(ribbon_segment) / max_segments_uint);
        ribbon_segment = int(uint(ribbon_segment) % max_segments_uint);
    }
    if (false)
    {
        uint param = uint(ribbon_id);
        if (!prt_is_alive(param))
        {
            gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
            return;
        }
    }
    int ribbon_segments = max(0, (min(_342.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    ribbon_segment = min(ribbon_segment, ribbon_segments);
    int param_1 = ribbon_id;
    int param_2 = ribbon_segment;
    int _1386 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx = _1386;
    vec3 vInstPosition = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_3 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_3);
    vec3 param_4 = vInstPosition;
    vec3 param_5 = vInstNormal;
    vec3 param_6 = vInstColor.xyz;
    uint param_7 = uint(ribbon_id);
    vec3 _1421 = apply_vtx_modifier(param_4, param_5, param_6, param_7);
    vInstColor.x = param_6.x;
    vInstColor.y = param_6.y;
    vInstColor.z = param_6.z;
    vInstPosition = _1421;
    uint param_8 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_8);
    bool is_last = ribbon_segment >= ribbon_segments;
    bool is_first = ribbon_segment == 0;
    vec3 extrusion = vec3(0.0);
    vec3 modelview_cylinder_axis = vec3(0.0, 0.0, 1.0);
    int second_segment_offset = -1;
    if (ribbon_segment == 0)
    {
        second_segment_offset = 1;
    }
    if (true)
    {
        float shrink_factor = _342.ribbon_render_params.first_segment_time_factor;
        float min_shrink_modifier = 0.1500000059604644775390625;
        int param_9 = ribbon_id;
        int param_10 = ribbon_segment;
        vec3 currPosition = get_ribbon_transformed_segment_position(param_9, param_10);
        int param_11 = ribbon_id;
        int param_12 = ribbon_segment + second_segment_offset;
        vec3 nextPosition = get_ribbon_transformed_segment_position(param_11, param_12);
        modelview_cylinder_axis = currPosition - nextPosition;
        if (length(modelview_cylinder_axis) <= 9.9999997473787516355514526367188e-05)
        {
            if (ribbon_segment > 1)
            {
                int param_13 = ribbon_id;
                int param_14 = ribbon_segment + (second_segment_offset * 2);
                nextPosition = get_ribbon_transformed_segment_position(param_13, param_14);
                modelview_cylinder_axis = currPosition - nextPosition;
            }
        }
        modelview_cylinder_axis = normalize(modelview_cylinder_axis);
        vec2 dir2d = normalize(currPosition.xy - nextPosition.xy);
        dir2d = vec2(-dir2d.y, dir2d.x);
        vec3 dir = vec3(dir2d, 0.0);
        if ((ribbon_segment == ribbon_segments) && (ribbon_segments > 1))
        {
        }
        if (is_first)
        {
            dir *= (-min_shrink_modifier);
        }
        else
        {
            if (is_last)
            {
                dir *= min_shrink_modifier;
            }
            else
            {
                if ((ribbon_segment == 1) && (ribbon_segments > 2))
                {
                    dir *= max(min_shrink_modifier, shrink_factor);
                }
                if ((ribbon_segment == (ribbon_segments - 1)) && (ribbon_segments == 2))
                {
                    dir *= max(min_shrink_modifier, shrink_factor);
                }
            }
        }
        extrusion = dir * _342.ribbon_render_params.thickness;
    }
    if (ribbon_segment == 0)
    {
        modelview_cylinder_axis *= (-1.0);
    }
    uint param_15 = uint(ribbon_id);
    if (!prt_is_alive(param_15))
    {
        gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
        return;
    }
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_16 = vPos1;
    mat4 param_17 = _1107.transform_params.mModelView;
    vec3 _1600 = vector_transform_by_mat43(param_16, param_17);
    vec3 vPos = _1600;
    if (vPos.z > 1.0)
    {
        mat4 projection_no_jitter = _1107.transform_params.mProjection;
        projection_no_jitter[2].x = 0.0;
        projection_no_jitter[2].y = 0.0;
        vec3 param_18 = vec3(extrusion.xy, vPos.z);
        mat4 param_19 = projection_no_jitter;
        vec4 _1622 = vector_transform_by_mat_projection(param_18, param_19);
        vec4 projected_extrusion = _1622;
        vec4 _1623 = projected_extrusion;
        float _1626 = projected_extrusion.w;
        vec3 _1628 = _1623.xyz / vec3(_1626);
        projected_extrusion.x = _1628.x;
        projected_extrusion.y = _1628.y;
        projected_extrusion.z = _1628.z;
        float min_extrusion_size = 0.0006500000017695128917694091796875;
        float projected_extrusion_size = length(projected_extrusion.xy);
        if (projected_extrusion_size > 0.0)
        {
            if (projected_extrusion_size < min_extrusion_size)
            {
                float scale = min_extrusion_size / projected_extrusion_size;
                extrusion *= scale;
            }
        }
    }
    vPos += (extrusion * float(odd_even));
    MaterialPropertiesGPU _1677;
    _1677.diffuse = materials.material_properties[_342.ribbon_render_params.material_index].diffuse;
    _1677.transparency = materials.material_properties[_342.ribbon_render_params.material_index].transparency;
    _1677.emissive = materials.material_properties[_342.ribbon_render_params.material_index].emissive;
    _1677.roughness = materials.material_properties[_342.ribbon_render_params.material_index].roughness;
    _1677.triplanar_factor = materials.material_properties[_342.ribbon_render_params.material_index].triplanar_factor;
    _1677.refraction = materials.material_properties[_342.ribbon_render_params.material_index].refraction;
    _1677.normal_factor = materials.material_properties[_342.ribbon_render_params.material_index].normal_factor;
    _1677.emissive_factor = materials.material_properties[_342.ribbon_render_params.material_index].emissive_factor;
    _1677.temporal_accumulation_factor = materials.material_properties[_342.ribbon_render_params.material_index].temporal_accumulation_factor;
    _1677.shadowmap_bias = materials.material_properties[_342.ribbon_render_params.material_index].shadowmap_bias;
    _1677.metalness = materials.material_properties[_342.ribbon_render_params.material_index].metalness;
    _1677.albedo_sampler = materials.material_properties[_342.ribbon_render_params.material_index].albedo_sampler;
    _1677.emissive_sampler = materials.material_properties[_342.ribbon_render_params.material_index].emissive_sampler;
    _1677.normal_sampler = materials.material_properties[_342.ribbon_render_params.material_index].normal_sampler;
    _1677.metalic_roughness_sampler = materials.material_properties[_342.ribbon_render_params.material_index].metalic_roughness_sampler;
    _1677.flags = materials.material_properties[_342.ribbon_render_params.material_index].flags;
    _1677._pad0 = materials.material_properties[_342.ribbon_render_params.material_index]._pad0;
    _1677._pad1 = materials.material_properties[_342.ribbon_render_params.material_index]._pad1;
    MaterialPropertiesGPU material = _1677;
    vec3 param_20 = vPos1 + (extrusion * float(odd_even));
    mat4 param_21 = _1107.transform_params.mModel;
    vec3 _1688 = vector_transform_by_mat43(param_20, param_21);
    vtx_output.vWorldPos = _1688;
    vtx_output.vWorldPos -= _1107.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = vec3(vInstPosition);
    vtx_output.vNorm = vInstNormal;
    vtx_output.vCoords = vPos;
    vtx_output.vNorm = vec3(float(odd_even), 0.0, -0.5);
    vec3 param_22 = modelview_cylinder_axis;
    mat4 param_23 = _1107.transform_params.mViewInv;
    vec3 model_cylinder_axis = vector_transform_by_mat33(param_22, param_23);
    vec3 param_24 = vPos;
    mat4 param_25 = _1107.transform_params.mViewInv;
    vec3 _1724 = vector_transform_by_mat43(param_24, param_25);
    vec3 model_on_cylinder_pos = _1724;
    vec3 param_26 = vInstPosition;
    mat4 param_27 = _1107.transform_params.mModel;
    vec3 _1731 = vector_transform_by_mat43(param_26, param_27);
    vec3 model_cylinder_pos = _1731;
    vec3 param_28 = _1107.transform_params.vCameraPosition;
    vec3 param_29 = normalize(model_on_cylinder_pos - _1107.transform_params.vCameraPosition);
    vec3 param_30 = model_cylinder_pos;
    vec3 param_31 = model_cylinder_axis;
    float param_32 = length(extrusion) * 2.0;
    vec4 cylinder_intersect = ray_cyl_intersect(param_28, param_29, param_30, param_31, param_32);
    vtx_output.vWorldNorm = -vec3(cylinder_intersect.yzw);
    if (cylinder_intersect.x == (-1.0))
    {
    }
    float life_time_factor = min(1.0, vState.life_time / vState.life_span);
    life_time_factor = 1.0 - sin((life_time_factor * 3.1415927410125732421875) * 0.5);
    vec4 _1782 = vInstColor;
    vec3 _1784 = _1782.xyz * (1.0 - pow(life_time_factor, 4.0));
    vInstColor.x = _1784.x;
    vInstColor.y = _1784.y;
    vInstColor.z = _1784.z;
    vtx_output.vColor = vec4(vInstColor);
    vec3 param_33 = vPos;
    mat4 param_34 = _1107.transform_params.mProjection;
    vec4 _1803 = vector_transform_by_mat_projection(param_33, param_34);
    gl_Position = _1803;
}

 