#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

struct BuildDrawTrianglesIndirectFromGeometryInformationParams
{
    uint indirect_buffer_idx;
    uint first_surface_idx;
    uint last_surface_idx;
    uint _pad0;
};

struct DrawElementsIndirectParams
{
    uint count;
    uint instance_count;
    uint first_index;
    uint base_vertex;
    uint base_instance;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform BuildDrawTrianglesIndirectFromGeometryInformationParamsBuffer
{
    BuildDrawTrianglesIndirectFromGeometryInformationParams params;
} _26;

layout(set = 0, binding = 1, std430) buffer DrawElementsIndirectParamsBuffer
{
    DrawElementsIndirectParams draw_indirect_params[];
} _50;

layout(set = 0, binding = 3, scalar) uniform DrawIndirectGeometryInformationParamsBuffer
{
    GeometryInformation draw_indirect_geometry_information;
} _60;

layout(set = 0, binding = 4, std140) uniform DrawIndirectInstanceParamsBuffer
{
    InstanceParams draw_indirect_instance_params;
} _73;

void main()
{
    uint idx = gl_GlobalInvocationID.x;
    if (idx == 0u)
    {
        uint indirect_buffer_idx = _26.params.indirect_buffer_idx;
        uint si = _26.params.first_surface_idx;
        for (;;)
        {
            if (si <= _26.params.last_surface_idx)
            {
                _50.draw_indirect_params[indirect_buffer_idx].count = _60.draw_indirect_geometry_information.faces_num_per_surface[si] * 3u;
                _50.draw_indirect_params[indirect_buffer_idx].instance_count = uint(min(_73.draw_indirect_instance_params.buffer_capacity, _73.draw_indirect_instance_params.instance_count));
                _50.draw_indirect_params[indirect_buffer_idx].first_index = _60.draw_indirect_geometry_information.idx_buffer_offset;
                _50.draw_indirect_params[indirect_buffer_idx].base_vertex = 0u;
                _50.draw_indirect_params[indirect_buffer_idx].base_instance = 0u;
                indirect_buffer_idx++;
                si++;
                continue;
            }
            else
            {
                break;
            }
        }
    }
}

 