#ifndef COMMONS_INSTANCING_BUFFERS_H
#define COMMONS_INSTANCING_BUFFERS_H

layout(std430) buffer InstanceTransformBuffer
{
	vec4 instance_transform[];
};

layout(std430) buffer InstanceColorBuffer
{
	uint instance_color[];
};


layout(std430) buffer InstanceFlipbookCardBuffer
{
	uint instance_flipbook_card[];
};

// This buffer is here so we can identify the instance when shader is randomly putting them in the buffer.
// Some instancers have const amount of spawned items and there is no problem, but some of them use buffer
// append and the order can be random. When using some modifiers  we might want to have same instance to be
// modified in the same way. 
layout(std430) buffer InstanceHashBuffer
{
	uint instance_hash[];
};

// NOTE: This structure is copied into fx_particle_emitter_instances.cpp, so modify there if required... fix this

struct InstanceParams
{
	int buffer_capacity;
	int stride;
	int indices_per_instance;
	int instance_count;
};

#ifndef INSTANCE_PARAMS_BUFFER_WRITABLE
layout(std140) uniform InstanceParamsBuffer
{
	InstanceParams instance_params;
};
#else
layout(std430) buffer InstanceParamsBuffer
{
	InstanceParams instance_params;
};
#endif

struct Instance
{
	vec4  m0;
	vec4  m1;
	vec4  m2;
	vec4  c;
	uint  hash;
	uint  flipbook_card;
};

#endif