uniform float iTime;

vec3 coloring(float t)
{
    vec3 a = vec3(0.5);
    vec3 b = vec3(0.5);
    vec3 c = vec3(1.);
    vec3 d = vec3(0., 0.33333, 0.66667);

    return a + b*cos( 6.28318*(c*t+d) ); //6.28318 ~= 2pi
}

void main()
{

    vec2 iResolution = vec2(1920., 1080.);

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_TexCoord[0].xy; // fragCoord/iResolution.xy * 2. - 1.;
    uv = uv * 2. - 1.;

    uv.x *= iResolution.x / iResolution.y;



    uv *= 6.;
    uv = abs(uv);
    
    float a = 1.4;
    float b = 0.3;
    
    vec2 o = vec2(1. - pow(a * uv.x, 2.) + uv.y, b * uv.x);
    //vec2 o = vec2(1. - pow(a * fragCoord.x, 2.) + fragCoord.y, b * fragCoord.x);
    
    float c = length(o + iTime);
    
    vec3 col = coloring(c);
    // utput to screen
    gl_FragColor = vec4(col,1.0);
}