#ifndef FBO_H
#define FBO_H

#include "gl.h"

typedef struct {
    GLuint framebuffer;
    GLuint texture;
    GLuint depth;
    GLint width;
    GLint height;
    int owns_texture;
} fbo_t;

GLuint create_texture(GLsizei width, GLsizei height, GLint internal_format,
                      GLenum format, GLenum type, GLint min_filter,
                      GLint mag_filter, GLint wrap);

GLuint create_depth(GLsizei width, GLsizei height);

fbo_t *fbo_init_with_texture(GLuint texture, GLint level, GLuint depth);

fbo_t *fbo_init(GLsizei width, GLsizei height, GLint filter, GLuint depth);

void fbo_deinit(fbo_t *fbo);

#endif
