#!/usr/bin/python3
#|----------------------------------------------------------------------------|#
#| Project: Generative Sountrack Music for Video Games.
#| Script: effects_generator.py
#| Description: Generate effects based on tool sounds effects played randomly 
#|   with this script. Part of a toolkit for generative audio. 
#| Event: XGNR 2023
#| Author: 4lf0n (clan chiwire) <siempregaming@proton.me>
#| License: AGPLv3
#|----------------------------------------------------------------------------|#
# Modules.
import random
from time import sleep
import pygame

# Class.
class EffectsGenerator:
    # Init.
    def __init__(self):
        pygame.mixer.init()
        self.effects = [
            "Effects/knife_sharpening.ogg",
            "Effects/electric_drill.ogg",
            "Effects/electrostatic.ogg",
            "Effects/electric_grinding.ogg",
            "Effects/radio_sample.ogg",
            "Effects/morse_transmission.ogg"
        ]


    # Choice effects.
    def choice_effects(self):
        effect = random.choice(self.effects)
        pygame.mixer.music.load(effect)
        pygame.mixer.music.play()


    # Generate effects.
    def generate_effects(self, num_effects):
        for _ in range(num_effects):
            self.choice_effects()
            sleep(1)
            pygame.time.delay(1000)


# Main.
if __name__ == "__main__":
    generator = EffectsGenerator()
    generator.generate_effects(num_effects=20)
