@echo off

IF DEFINED PROJECTCONFIG GOTO PROJECTCONFIGDEFINED
set PROJECTCONFIG=Fast
:PROJECTCONFIGDEFINED

rem Clinkler libs
set LIBS=/LIBPATH:libs opengl32.lib winmm.lib kernel32.lib user32.lib gdi32.lib

rem Clinkler options (fast)
set OPTSFAST=  /ENTRY:start /CRINKLER /RANGE:kernel32 /RANGE:user32 /RANGE:gdi32 /RANGE:opengl32 /RANGE:winmm /HASHTRIES:100 /REUSEMODE:OFF /COMPMODE:FAST    /ORDERTRIES:100  /REPORT:out.html /HASHSIZE:250 /TINYIMPORT /UNSAFEIMPORT /UNALIGNCODE /SATURATE /NOINITIALIZERS /TRANSFORM:CALLS /TRUNCATEFLOATS:32 /SUBSYSTEM:WINDOWS

rem Clinkler options (medium)
set OPTSMEDIUM=/ENTRY:start /CRINKLER /RANGE:kernel32 /RANGE:user32 /RANGE:gdi32 /RANGE:opengl32 /RANGE:winmm /HASHTRIES:500 /REUSEMODE:OFF /COMPMODE:SLOW    /ORDERTRIES:500  /REPORT:out.html /HASHSIZE:500 /TINYIMPORT /UNSAFEIMPORT /UNALIGNCODE /SATURATE /NOINITIALIZERS /TRANSFORM:CALLS /TRUNCATEFLOATS:32 /SUBSYSTEM:WINDOWS

rem Clinkler options (slow, but with fast model, gives better results ...)
rem set OPTSSLOW=/ENTRY:start /CRINKLER /RANGE:kernel32 /RANGE:user32 /RANGE:gdi32 /RANGE:opengl32 /RANGE:winmm /HASHTRIES:5000 /REUSEMODE:OFF /COMPMODE:FAST     /ORDERTRIES:50000 /REPORT:out.html /HASHSIZE:1000 /TINYIMPORT /UNSAFEIMPORT /SATURATE /UNALIGNCODE /NOINITIALIZERS /TRANSFORM:CALLS /TRUNCATEFLOATS:32 /SUBSYSTEM:WINDOWS

rem Clinkler options (suuuuper slow, takes 4.5 minutes on my Ryzen9 5900X)
set OPTSSLOW=/ENTRY:start /CRINKLER /RANGE:kernel32 /RANGE:user32 /RANGE:gdi32 /RANGE:opengl32 /RANGE:winmm /HASHTRIES:5000 /REUSEMODE:OFF /COMPMODE:VERYSLOW /ORDERTRIES:50000 /REPORT:out.html /HASHSIZE:1000 /TINYIMPORT /UNSAFEIMPORT /SATURATE /UNALIGNCODE /NOINITIALIZERS /TRANSFORM:CALLS /TRUNCATEFLOATS:32 /SUBSYSTEM:WINDOWS
 
rem Minimify MainEffect
shader_minifier.exe -v --no-renaming-list amain,bmain,cmain --preserve-externals --move-declarations --aggressive-inlining --format nasm -o fragment.inz fragment.frag
IF ERRORLEVEL 1 GOTO BUILDFAIL
findstr /V /B "_var_" fragment.inz > fragment.inc
del /F /Q fragment.inz

rem Compile music player (clinkster)
rem echo Compile clinkster.asm
rem nasm -w-orphan-labels -fwin32 -o clinkster.obj clinkster.asm
rem IF ERRORLEVEL 1 GOTO BUILDFAIL

rem Compile music player (4klang)
echo Compile 4klang.asm
nasm -w-orphan-labels -fwin32 -o 4klang.obj 4klang.asm
IF ERRORLEVEL 1 GOTO BUILDFAIL

rem Compile main module
echo Compile intro.asm
nasm -w-orphan-labels -fwin32 -o intro.obj intro.asm
IF ERRORLEVEL 1 GOTO BUILDFAIL

rem Link all
if "%PROJECTCONFIG%"=="Fast" call set OPTSNOW=%OPTSFAST%
if "%PROJECTCONFIG%"=="Normal" call set OPTSNOW=%OPTSMEDIUM%
if "%PROJECTCONFIG%"=="Slow" call set OPTSNOW=%OPTSSLOW%

rem crinkler.exe %OPTSNOW% %LIBS% intro.obj clinkster.obj /OUT:add4k-%PROJECTCONFIG%.exe
crinkler.exe %OPTSNOW% %LIBS% intro.obj 4klang.obj /OUT:add8k-%PROJECTCONFIG%.exe
IF ERRORLEVEL 1 GOTO BUILDFAIL

echo All done!
GOTO BUILDSUCC
:BUILDFAIL
echo Something is fucked!
:BUILDSUCC
pause