%macro export_func 1
   global _%1
   _%1:
%endmacro
%define USE_SECTIONS
%define SAMPLE_RATE	44100
%define MAX_INSTRUMENTS	9
%define MAX_VOICES 2
%define HLD 1
%define BPM 240.000000
%define MAX_PATTERNS 122
%define PATTERN_SIZE_SHIFT 4
%define PATTERN_SIZE (1 << PATTERN_SIZE_SHIFT)
%define	MAX_TICKS (MAX_PATTERNS*PATTERN_SIZE)
%define	SAMPLES_PER_TICK 2756
%define DEF_LFO_NORMALIZE 0.0000907029
%define	MAX_SAMPLES	(SAMPLES_PER_TICK*MAX_TICKS)
;%define 	GO4K_USE_16BIT_OUTPUT
;%define 	GO4K_USE_GROOVE_PATTERN
;%define 	GO4K_USE_ENVELOPE_RECORDINGS
;%define 	GO4K_USE_NOTE_RECORDINGS
%define 	GO4K_CLIP_OUTPUT
%define 	GO4K_USE_DST
%define 	GO4K_USE_DLL
%define 	GO4K_USE_PAN
%define 	GO4K_USE_GLOBAL_DLL
%define 	GO4K_USE_ENV_CHECK
%define 	GO4K_USE_ENV_MOD_GM
%define 	GO4K_USE_VCO_CHECK
%define 	GO4K_USE_VCO_PHASE_OFFSET
%define 	GO4K_USE_VCO_SHAPE
%define 	GO4K_USE_VCO_MOD_TM
%define 	GO4K_USE_VCO_MOD_DM
%define 	GO4K_USE_VCO_MOD_CM
%define 	GO4K_USE_VCF_CHECK
%define 	GO4K_USE_VCF_MOD_FM
%define 	GO4K_USE_VCF_MOD_RM
%define 	GO4K_USE_VCF_HIGH
%define 	GO4K_USE_VCF_BAND
%define 	GO4K_USE_VCF_PEAK
%define 	GO4K_USE_DST_CHECK
%define 	GO4K_USE_DST_SH
%define		GO4K_USE_DLL_CHORUS
%define		GO4K_USE_DLL_CHORUS_CLAMP
%define 	GO4K_USE_DLL_DAMP
%define 	GO4K_USE_DLL_DC_FILTER
%define 	GO4K_USE_FSTG_CHECK
%define 	GO4K_USE_PAN_MOD
%define 	GO4K_USE_OUT_MOD_GM
%define		GO4K_USE_WAVESHAPER_CLIP
%define	MAX_DELAY			65536
%define MAX_UNITS			64
%define	MAX_UNIT_SLOTS	    16
%define GO4K_BEGIN_CMDDEF(def_name)
%define GO4K_END_CMDDEF db 0
%define GO4K_BEGIN_PARAMDEF(def_name)
%define GO4K_END_PARAMDEF
GO4K_ENV_ID		equ		1
%macro	GO4K_ENV 5
	db	%1
	db	%2
	db	%3
	db	%4
	db	%5
%endmacro
%define	ATTAC(val)		val	
%define	DECAY(val)		val	
%define	SUSTAIN(val)	val	
%define	RELEASE(val)	val	
%define	GAIN(val)		val	
struc	go4kENV_val
	.attac		resd	1
	.decay		resd	1
	.sustain	resd	1
	.release	resd	1
	.gain		resd	1
	.size
endstruc
struc	go4kENV_wrk
	.state		resd	1
	.level		resd	1
	.gm			resd	1
	.am			resd	1
	.dm			resd	1
	.sm			resd	1
	.rm			resd	1
	.size
endstruc
%define ENV_STATE_ATTAC		0
%define ENV_STATE_DECAY		1
%define ENV_STATE_SUSTAIN	2
%define ENV_STATE_RELEASE	3
%define ENV_STATE_OFF		4
GO4K_VCO_ID		equ		2
%macro	GO4K_VCO 8
	db	%1
	db	%2
%ifdef GO4K_USE_VCO_PHASE_OFFSET	
	db	%3
%endif	
%ifdef GO4K_USE_VCO_GATE	
	db	%4
%endif	
	db	%5
%ifdef GO4K_USE_VCO_SHAPE	
	db	%6
%endif	
	db	%7
	db	%8
%endmacro
%define	TRANSPOSE(val)	val	
%define	DETUNE(val)		val	
%define	PHASE(val)		val	
%define	GATES(val)		val	
%define	COLOR(val)		val	
%define	SHAPE(val)		val 
%define	FLAGS(val)		val	
%define SINE		0x01
%define TRISAW		0x02
%define PULSE		0x04
%define NOISE		0x08
%define LFO			0x10
%define GATE		0x20
%define	VCO_STEREO	0x40
struc	go4kVCO_val
	.transpose	resd	1
	.detune		resd	1
%ifdef GO4K_USE_VCO_PHASE_OFFSET	
	.phaseofs	resd	1
%endif	
%ifdef GO4K_USE_VCO_GATE	
	.gate		resd	1
%endif	
	.color		resd	1
%ifdef GO4K_USE_VCO_SHAPE	
	.shape		resd	1
%endif	
	.gain		resd	1
	.flags		resd	1	
	.size
endstruc
struc	go4kVCO_wrk
	.phase		resd	1
	.tm			resd	1
	.dm			resd	1
	.fm			resd	1
	.pm			resd	1
	.cm			resd	1
	.sm			resd	1
	.gm			resd	1
	.phase2		resd	1
	.size
endstruc
GO4K_VCF_ID		equ		3
%macro	GO4K_VCF 3
	db	%1
	db	%2
	db	%3
%endmacro
%define LOWPASS		0x1
%define HIGHPASS	0x2
%define BANDPASS	0x4
%define	BANDSTOP	0x3
%define ALLPASS		0x7
%define	PEAK		0x8
%define STEREO		0x10
%define	FREQUENCY(val)	val
%define	RESONANCE(val)	val
%define	VCFTYPE(val)	val
struc	go4kVCF_val
	.freq		resd	1
	.res		resd	1
	.type		resd	1
	.size
endstruc
struc	go4kVCF_wrk
	.low		resd	1
	.high		resd	1
	.band		resd	1
	.freq		resd	1
	.fm			resd	1
	.rm			resd	1
	.low2		resd	1
	.high2		resd	1
	.band2		resd	1
	.size
endstruc
GO4K_DST_ID		equ		4
%macro	GO4K_DST 3
	db	%1
%ifdef GO4K_USE_DST_SH
	db	%2
%ifdef GO4K_USE_DST_STEREO
	db	%3
%endif
%else
%ifdef GO4K_USE_DST_STEREO
	db	%3
%endif
%endif
%endmacro
%define	DRIVE(val)		val
%define	SNHFREQ(val)	val
%define	FLAGS(val)		val
struc	go4kDST_val
	.drive		resd	1
%ifdef GO4K_USE_DST_SH	
	.snhfreq	resd	1
%endif	
	.flags		resd	1
	.size
endstruc
struc	go4kDST_wrk
	.out		resd	1
	.snhphase	resd	1
	.dm			resd	1
	.sm			resd	1
	.out2		resd	1
	.size
endstruc
GO4K_DLL_ID		equ		5
%macro	GO4K_DLL 8
	db	%1
	db	%2
	db	%3
%ifdef GO4K_USE_DLL_DAMP	
	db	%4
%endif		
%ifdef GO4K_USE_DLL_CHORUS	
	db	%5
	db	%6
%endif
	db	%7
	db	%8
%endmacro
%define PREGAIN(val)	val
%define	DRY(val)		val
%define	FEEDBACK(val)	val
%define	DEPTH(val)		val
%define DAMP(val)		val
%define	DELAY(val)		val
%define	COUNT(val)		val
struc	go4kDLL_val
	.pregain	resd	1
	.dry		resd	1
	.feedback	resd	1
%ifdef GO4K_USE_DLL_DAMP	
	.damp		resd	1	
%endif
%ifdef GO4K_USE_DLL_CHORUS
	.freq		resd	1
	.depth
%endif
	.delay		resd	1
	.count		resd	1
	.size
endstruc
struc	go4kDLL_wrk
	.index		resd	1
	.store		resd	1
	.dcin		resd	1
	.dcout		resd	1
%ifdef GO4K_USE_DLL_CHORUS
	.phase		resd	1
%endif
	.buffer		resd	MAX_DELAY
	.size
endstruc
struc	go4kDLL_wrk2
 .pm			resd	1
 .fm			resd	1
 .im			resd	1
 .dm			resd	1
 .sm			resd	1
 .am			resd	1
 .size
endstruc
GO4K_FOP_ID	equ			6
%macro	GO4K_FOP 1
	db	%1
%endmacro
%define	OP(val)			val
%define FOP_POP			0x1
%define FOP_ADDP		0x2
%define FOP_MULP		0x3
%define FOP_PUSH		0x4
%define FOP_XCH			0x5
%define FOP_ADD			0x6
%define FOP_MUL			0x7
%define FOP_ADDP2		0x8
%define FOP_LOADNOTE	0x9
%define FOP_MULP2		0xa
struc	go4kFOP_val
	.flags		resd	1
	.size
endstruc
struc	go4kFOP_wrk
	.size
endstruc
GO4K_FST_ID		equ		7
%macro	GO4K_FST 2
	db	%1
	dw	%2
%endmacro
%define	AMOUNT(val)		val
%define	DEST(val)		val
%define	FST_SET			0x0000
%define	FST_ADD			0x4000
%define	FST_POP			0x8000
struc	go4kFST_val
	.amount		resd	1
	.op1		resd	1
	.size
endstruc
struc	go4kFST_wrk
	.size
endstruc
GO4K_PAN_ID		equ		8
%macro	GO4K_PAN 1
%ifdef GO4K_USE_PAN
	db	%1
%endif
%endmacro
%define	PANNING(val)	val
struc	go4kPAN_val
%ifdef GO4K_USE_PAN
	.panning	resd	1
%endif
	.size
endstruc
struc	go4kPAN_wrk
	.pm			resd	1
	.size
endstruc
GO4K_OUT_ID		equ		9
%macro	GO4K_OUT 2
	db	%1
%ifdef GO4K_USE_GLOBAL_DLL	
	db	%2
%endif	
%endmacro
%define	AUXSEND(val)	val
struc	go4kOUT_val
	.gain		resd	1
%ifdef GO4K_USE_GLOBAL_DLL	
	.auxsend	resd	1
%endif
	.size
endstruc
struc	go4kOUT_wrk
	.am			resd	1
	.gm			resd	1
	.size
endstruc
GO4K_ACC_ID		equ		10
%macro	GO4K_ACC 1
	db	%1
%endmacro
%define OUTPUT			0
%define	AUX				8
%define ACCTYPE(val)	val
struc	go4kACC_val
	.acctype	resd	1
	.size
endstruc
struc	go4kACC_wrk
	.size
endstruc
%ifdef GO4K_USE_FLD
GO4K_FLD_ID	equ		11
%macro	GO4K_FLD 1
	db	%1
%endmacro
%define	VALUE(val)	val
struc	go4kFLD_val
	.value		resd	1
	.size
endstruc
struc	go4kFLD_wrk
	.vm			resd	1
	.size
endstruc
%endif
%ifdef GO4K_USE_GLITCH
GO4K_GLITCH_ID		equ		12
%macro	GO4K_GLITCH 5
	db	%1
	db	%2
	db	%3
	db	%4
	db	%5
%endmacro
%define	ACTIVE(val)		val
%define	SLICEFACTOR(val)val
%define	PITCHFACTOR(val)val
%define	SLICESIZE(val)	val
struc	go4kGLITCH_val
	.active		resd	1
	.dry		resd	1
	.dsize		resd	1
	.dpitch		resd	1
	.slicesize	resd	1
	.size
endstruc
struc	go4kGLITCH_wrk
	.index		resd	1
	.store		resd	1
	.slizesize	resd	1
	.slicepitch	resd	1
	.unused		resd	1
	.buffer		resd	MAX_DELAY
	.size
endstruc
struc	go4kGLITCH_wrk2
	.am			resd	1
	.dm			resd	1
	.sm			resd	1
	.pm			resd	1
	.size
endstruc
%endif
%ifdef GO4K_USE_FSTG
GO4K_FSTG_ID	equ		13
%macro	GO4K_FSTG 2
	db	%1
	dw	%2
%endmacro
struc	go4kFSTG_val
	.amount		resd	1
	.op1		resd	1
	.size
endstruc
struc	go4kFSTG_wrk
	.size
endstruc
%endif
struc	go4k_instrument
	.release	resd	1
	.note		resd	1
	.workspace	resd	MAX_UNITS*MAX_UNIT_SLOTS
	.dlloutl	resd	1
	.dlloutr	resd	1
	.outl		resd	1
	.outr		resd	1
	.size
endstruc
struc	go4k_synth
	.instruments	resb	go4k_instrument.size * MAX_INSTRUMENTS * MAX_VOICES
	.global			resb	go4k_instrument.size * MAX_VOICES
	.size
endstruc
%ifdef USE_SECTIONS
section .g4kmuc1 data align=1
%else
section .data align=1
%endif
go4k_patterns
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 
	db	67, HLD, 58, HLD, 0, 0, 67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	67, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 67, HLD, 0, 0, 55, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, HLD, HLD, 63, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 76, HLD, 0, 0, 
	db	0, 0, 75, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, HLD, 
	db	0, 0, 0, 0, 0, 0, 79, 0, 0, 0, 64, HLD, 0, 0, 63, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, HLD, 76, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 0, 0, 55, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 58, HLD, 70, HLD, 
	db	67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 51, HLD, 63, HLD, 
	db	67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, 0, 0, 67, HLD, 
	db	55, HLD, 0, 0, 55, HLD, 67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	67, HLD, 58, HLD, 70, HLD, 67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, HLD, HLD, 51, HLD, HLD, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, 0, 0, 0, 64, HLD, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, HLD, 0, 0, 63, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, 
	db	0, 0, 67, HLD, HLD, HLD, 0, 0, 76, HLD, 64, HLD, 0, 0, 63, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 
	db	67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 
	db	0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 67, HLD, 51, HLD, 63, HLD, 
	db	0, 0, 0, 0, 55, HLD, 67, HLD, 0, 0, 67, HLD, 58, HLD, 70, HLD, 
	db	64, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	67, HLD, HLD, HLD, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 0, 0, 
	db	67, HLD, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 67, HLD, 0, 0, 
	db	67, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 67, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, HLD, HLD, 
	db	67, HLD, 0, 0, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 0, 0, 
	db	67, HLD, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 64, HLD, 0, 0, 
	db	67, HLD, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	64, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 64, HLD, HLD, HLD, HLD, HLD, 55, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 55, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, 0, 0, 67, 0, 0, 0, 
	db	0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 62, HLD, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 76, 0, 0, 0, 76, HLD, 74, HLD, HLD, HLD, 67, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 67, HLD, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 67, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 60, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, 60, HLD, 60, HLD, HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 12, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, 
	db	HLD, HLD, 60, HLD, 60, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 60, HLD, HLD, HLD, 
	db	54, HLD, 49, HLD, 57, HLD, 49, HLD, 54, HLD, 49, HLD, 43, HLD, 52, HLD, 
	db	54, HLD, 49, HLD, 57, HLD, 49, HLD, 54, HLD, 56, HLD, 57, HLD, 52, HLD, 
	db	54, HLD, 49, HLD, 57, HLD, 49, HLD, 54, HLD, HLD, HLD, 57, HLD, HLD, HLD, 
	db	48, HLD, 51, HLD, 52, HLD, 55, HLD, 58, HLD, 55, HLD, 52, HLD, 51, HLD, 
	db	54, HLD, 49, HLD, 57, HLD, 49, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	74, HLD, HLD, HLD, 67, HLD, 77, HLD, HLD, HLD, 74, HLD, 84, HLD, HLD, HLD, 
	db	79, HLD, 86, HLD, HLD, HLD, 82, HLD, HLD, HLD, 79, HLD, 70, HLD, 82, HLD, 
	db	74, HLD, HLD, HLD, 67, HLD, 77, HLD, HLD, HLD, 74, HLD, 86, HLD, HLD, HLD, 
	db	79, HLD, 91, HLD, HLD, HLD, 86, HLD, HLD, HLD, 79, HLD, 75, HLD, 87, HLD, 
	db	0, 0, 0, 0, 67, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 
	db	0, 0, 55, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 67, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 
	db	67, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 
	db	79, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	79, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	55, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 70, HLD, 0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 55, HLD, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 0, 0, 0, 0, 55, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 64, HLD, 0, 0, 55, HLD, 
	db	0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	0, 0, 75, HLD, 55, HLD, HLD, 0, 0, 0, 64, HLD, 0, 0, 75, HLD, 
	db	67, HLD, 0, 0, 55, HLD, 0, 0, 0, 0, 55, HLD, 0, 0, 67, HLD, 
	db	0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 55, HLD, 0, 0, 67, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 64, 0, 76, HLD, 55, HLD, 
	db	0, 0, 75, HLD, 55, HLD, HLD, 0, 0, 0, 64, HLD, 0, 0, 63, HLD, 
	db	0, 0, 0, 0, 55, HLD, 79, 0, 0, 0, 64, HLD, 0, 0, 63, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 64, 0, 76, 0, 55, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 55, HLD, 0, 0, 55, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, 0, 0, 0, 64, HLD, 0, 0, 67, HLD, 
	db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 55, HLD, 0, 0, 0, 0, 
	db	55, HLD, 0, 0, 55, HLD, 67, HLD, 0, 0, 67, HLD, 51, HLD, 63, HLD, 
	db	55, HLD, 0, 0, 55, HLD, 67, HLD, 0, 0, 67, HLD, 58, HLD, 70, HLD, 
	db	67, HLD, 0, 0, 55, HLD, 0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 
	db	0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 55, HLD, 0, 0, 0, 0, 
	db	55, HLD, 0, 0, 0, 0, 67, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	55, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	db	55, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, HLD, 
	db	0, 0, 0, 0, 55, HLD, HLD, HLD, 0, 0, 67, HLD, 0, 0, 0, 0, 
	db	76, HLD, 64, HLD, 0, 0, 63, HLD, 0, 0, 0, 0, 0, 0, 0, 0, 
go4k_patterns_end
%ifdef USE_SECTIONS
section .g4kmuc2 data align=1
%else
section .data
%endif
go4k_pattern_lists
Instrument0List		db	0, 1, 2, 0, 0, 1, 3, 4, 5, 6, 0, 7, 8, 0, 9, 4, 0, 10, 11, 12, 11, 10, 13, 14, 0, 1, 2, 0, 0, 1, 15, 16, 0, 1, 2, 0, 0, 1, 15, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 7, 8, 0, 9, 4, 0, 17, 0, 17, 0, 18, 19, 20, 0, 17, 0, 17, 0, 18, 19, 20, 0, 17, 0, 17, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 10, 22, 23, 21, 24, 22, 23, 21, 10, 22, 23, 21, 24, 22, 23, 21, 10, 22, 23, 21, 24, 22, 23, 0, 0, 0, 0, 0, 0, 
Instrument1List		db	25, 0, 0, 0, 25, 0, 26, 27, 26, 26, 26, 26, 26, 26, 26, 27, 26, 26, 26, 26, 26, 26, 28, 29, 25, 0, 0, 0, 0, 0, 0, 29, 25, 0, 0, 0, 0, 0, 0, 29, 25, 0, 0, 30, 26, 31, 26, 26, 26, 31, 26, 32, 26, 31, 26, 26, 26, 31, 26, 33, 34, 35, 26, 26, 26, 26, 26, 32, 26, 31, 26, 26, 26, 26, 26, 32, 26, 31, 26, 26, 26, 26, 0, 32, 26, 31, 26, 26, 26, 26, 26, 32, 26, 31, 26, 26, 26, 26, 26, 32, 26, 31, 26, 26, 26, 26, 26, 32, 26, 31, 26, 26, 26, 26, 26, 32, 25, 0, 0, 0, 0, 0, 
Instrument2List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 37, 37, 37, 37, 37, 37, 37, 38, 37, 37, 37, 37, 37, 37, 37, 39, 0, 0, 0, 0, 0, 0, 0, 40, 41, 41, 41, 41, 41, 41, 0, 42, 43, 44, 44, 44, 44, 44, 0, 45, 43, 44, 44, 44, 44, 44, 44, 45, 43, 46, 46, 46, 46, 46, 46, 45, 43, 46, 46, 46, 46, 46, 46, 45, 43, 46, 46, 46, 46, 46, 46, 45, 0, 0, 0, 0, 0, 0, 
Instrument3List		db	0, 0, 0, 0, 0, 0, 47, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 49, 48, 49, 49, 50, 53, 49, 49, 49, 48, 49, 49, 49, 54, 49, 49, 49, 48, 49, 49, 49, 54, 49, 49, 49, 48, 49, 49, 49, 54, 49, 49, 49, 48, 49, 49, 49, 54, 49, 49, 49, 48, 49, 49, 49, 54, 0, 0, 0, 0, 0, 0, 
Instrument4List		db	55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 56, 55, 57, 55, 56, 55, 56, 55, 56, 55, 57, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 55, 56, 59, 0, 0, 0, 
Instrument5List		db	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 61, 62, 63, 60, 61, 62, 63, 60, 61, 62, 63, 60, 61, 62, 63, 60, 61, 62, 63, 60, 61, 62, 63, 60, 61, 62, 63, 60, 61, 62, 63, 0, 0, 0, 0, 0, 0, 
Instrument6List		db	0, 0, 0, 0, 0, 0, 64, 65, 64, 0, 64, 0, 64, 0, 64, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 0, 65, 0, 65, 0, 0, 0, 65, 0, 65, 0, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 64, 0, 64, 0, 64, 65, 64, 0, 64, 0, 64, 0, 64, 65, 66, 0, 64, 0, 64, 0, 64, 65, 66, 0, 64, 0, 64, 0, 64, 65, 66, 0, 64, 0, 64, 0, 64, 65, 0, 0, 0, 0, 0, 0, 
Instrument11List		db	67, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 67, 0, 0, 0, 67, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 68, 0, 0, 0, 68, 0, 0, 0, 68, 0, 0, 0, 68, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 0, 0, 69, 0, 70, 0, 0, 0, 0, 0, 
Instrument15List		db	71, 72, 73, 0, 71, 72, 72, 74, 75, 17, 76, 77, 75, 78, 72, 74, 79, 14, 80, 14, 80, 14, 77, 12, 71, 72, 73, 0, 71, 72, 81, 0, 71, 72, 73, 0, 71, 72, 81, 0, 71, 0, 0, 0, 82, 83, 76, 84, 85, 83, 86, 87, 75, 17, 76, 77, 75, 78, 72, 74, 76, 88, 76, 88, 76, 74, 89, 0, 76, 88, 76, 88, 76, 74, 89, 0, 76, 88, 76, 88, 76, 74, 80, 90, 79, 91, 79, 90, 79, 91, 79, 90, 92, 14, 93, 94, 92, 95, 93, 94, 92, 14, 93, 94, 92, 95, 93, 94, 92, 14, 93, 94, 92, 95, 93, 94, 96, 97, 98, 0, 0, 0, 
go4k_pattern_lists_end
%ifdef USE_SECTIONS
section .g4kmuc3 data align=1
%else
section .data
%endif
go4k_synth_instructions
GO4K_BEGIN_CMDDEF(Instrument0)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument1)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_DST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument2)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument3)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_PAN_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument4)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_DST_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument5)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_FST_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument6)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_DST_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_VCF_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument11)
	db GO4K_ENV_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_VCO_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_FOP_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Instrument15)
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_VCO_ID
	db GO4K_VCO_ID
	db GO4K_FOP_ID
	db GO4K_ENV_ID
	db GO4K_FST_ID
	db GO4K_FST_ID
	db GO4K_FOP_ID
	db GO4K_VCF_ID
	db GO4K_VCF_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_PAN_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
GO4K_BEGIN_CMDDEF(Global)
	db GO4K_ACC_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_DLL_ID
	db GO4K_FOP_ID
	db GO4K_ACC_ID
	db GO4K_FOP_ID
	db GO4K_OUT_ID
GO4K_END_CMDDEF
go4k_synth_instructions_end
%ifdef USE_SECTIONS
section .g4kmuc4 data align=1
%else
section .data
%endif
go4k_synth_parameter_values
GO4K_BEGIN_PARAMDEF(Instrument0)
	GO4K_ENV	ATTAC(0),DECAY(64),SUSTAIN(64),RELEASE(0),GAIN(128)
	GO4K_FST	AMOUNT(112),DEST(0*MAX_UNIT_SLOTS+2+FST_SET)
	GO4K_VCO	TRANSPOSE(52),DETUNE(71),PHASE(0),GATES(85),COLOR(94),SHAPE(127),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(85),COLOR(128),SHAPE(1),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_ENV	ATTAC(0),DECAY(64),SUSTAIN(18),RELEASE(64),GAIN(128)
	GO4K_FST	AMOUNT(96),DEST(9*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(88),DEST(10*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCF	FREQUENCY(18),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(17),RESONANCE(74),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(33),DRY(128),FEEDBACK(8),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(75), AUXSEND(4)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument1)
	GO4K_ENV	ATTAC(0),DECAY(69),SUSTAIN(84),RELEASE(24),GAIN(128)
	GO4K_FST	AMOUNT(128),DEST(0*MAX_UNIT_SLOTS+2+FST_SET)
	GO4K_ENV	ATTAC(0),DECAY(64),SUSTAIN(12),RELEASE(22),GAIN(128)
	GO4K_DST	DRIVE(50), SNHFREQ(128), FLAGS(0)
	GO4K_FST	AMOUNT(77),DEST(6*MAX_UNIT_SLOTS+1+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(38),DETUNE(64),PHASE(32),GATES(85),COLOR(127),SHAPE(65),GAIN(128),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(128), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument2)
	GO4K_ENV	ATTAC(0),DECAY(72),SUSTAIN(0),RELEASE(47),GAIN(128)
	GO4K_FST	AMOUNT(128),DEST(0*MAX_UNIT_SLOTS+2+FST_SET)
	GO4K_ENV	ATTAC(0),DECAY(52),SUSTAIN(0),RELEASE(0),GAIN(128)
	GO4K_FST	AMOUNT(80),DEST(5*MAX_UNIT_SLOTS+1+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(48),DETUNE(64),PHASE(0),GATES(85),COLOR(128),SHAPE(74),GAIN(64),FLAGS(SINE)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(64),GATES(85),COLOR(64),SHAPE(64),GAIN(64),FLAGS(NOISE)
	GO4K_VCF	FREQUENCY(112),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(14),RESONANCE(22),VCFTYPE(HIGHPASS)
	GO4K_DLL	PREGAIN(25),DRY(64),FEEDBACK(64),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(9),COUNT(8)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(48), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument3)
	GO4K_ENV	ATTAC(0),DECAY(59),SUSTAIN(0),RELEASE(0),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(64),GATES(85),COLOR(64),SHAPE(64),GAIN(128),FLAGS(NOISE)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCF	FREQUENCY(128),RESONANCE(128),VCFTYPE(BANDPASS)
	GO4K_PAN	PANNING(44)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_OUT	GAIN(64), AUXSEND(0)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument4)
	GO4K_ENV	ATTAC(0),DECAY(53),SUSTAIN(0),RELEASE(48),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(44),PHASE(0),GATES(85),COLOR(0),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(74),PHASE(0),GATES(85),COLOR(32),SHAPE(64),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_DST	DRIVE(112), SNHFREQ(128), FLAGS(0)
	GO4K_VCF	FREQUENCY(53),RESONANCE(31),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(50),RESONANCE(32),VCFTYPE(HIGHPASS)
	GO4K_DST	DRIVE(64), SNHFREQ(66), FLAGS(0)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(26),DRY(128),FEEDBACK(30),DAMP(100),FREQUENCY(0),DEPTH(0),DELAY(18),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(64), AUXSEND(31)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument5)
	GO4K_ENV	ATTAC(0),DECAY(67),SUSTAIN(0),RELEASE(68),GAIN(128)
	GO4K_VCO	TRANSPOSE(64),DETUNE(66),PHASE(0),GATES(0),COLOR(128),SHAPE(31),GAIN(128),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(50),PHASE(0),GATES(0),COLOR(70),SHAPE(25),GAIN(108),FLAGS(SINE)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_VCO	TRANSPOSE(80),DETUNE(65),PHASE(0),GATES(0),COLOR(128),SHAPE(1),GAIN(128),FLAGS(TRISAW|LFO)
	GO4K_VCF	FREQUENCY(25),RESONANCE(60),VCFTYPE(BANDPASS)
	GO4K_FST	AMOUNT(81),DEST(18*MAX_UNIT_SLOTS+1+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(64),DETUNE(60),PHASE(44),GATES(154),COLOR(128),SHAPE(1),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(73),DEST(1*MAX_UNIT_SLOTS+5+FST_SET)
	GO4K_FST	AMOUNT(79),DEST(3*MAX_UNIT_SLOTS+5+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCF	FREQUENCY(77),RESONANCE(89),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(3),RESONANCE(12),VCFTYPE(HIGHPASS)
	GO4K_FST	AMOUNT(104),DEST(17*MAX_UNIT_SLOTS+0+FST_SET)
	GO4K_DLL	PREGAIN(75),DRY(87),FEEDBACK(86),DAMP(40),FREQUENCY(35),DEPTH(64),DELAY(19),COUNT(1)
	GO4K_PAN	PANNING(54)
	GO4K_OUT	GAIN(128), AUXSEND(128)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument6)
	GO4K_ENV	ATTAC(71),DECAY(124),SUSTAIN(128),RELEASE(3),GAIN(128)
	GO4K_VCO	TRANSPOSE(8),DETUNE(64),PHASE(0),GATES(85),COLOR(112),SHAPE(20),GAIN(128),FLAGS(TRISAW|LFO)
	GO4K_FST	AMOUNT(63),DEST(10*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(0),DETUNE(64),PHASE(0),GATES(85),COLOR(75),SHAPE(127),GAIN(128),FLAGS(SINE|LFO)
	GO4K_FST	AMOUNT(53),DEST(12*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(72),DEST(11*MAX_UNIT_SLOTS+2+FST_SET)
	GO4K_FST	AMOUNT(69),DEST(14*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(67),DETUNE(64),PHASE(0),GATES(85),COLOR(93),SHAPE(20),GAIN(72),FLAGS(SINE)
	GO4K_VCF	FREQUENCY(16),RESONANCE(59),VCFTYPE(LOWPASS)
	GO4K_VCO	TRANSPOSE(71),DETUNE(60),PHASE(0),GATES(85),COLOR(128),SHAPE(93),GAIN(64),FLAGS(TRISAW)
	GO4K_VCF	FREQUENCY(25),RESONANCE(128),VCFTYPE(PEAK)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(85),COLOR(111),SHAPE(91),GAIN(96),FLAGS(SINE)
	GO4K_VCF	FREQUENCY(43),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_ENV	ATTAC(75),DECAY(61),SUSTAIN(84),RELEASE(63),GAIN(128)
	GO4K_FST	AMOUNT(32),DEST(21*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_DST	DRIVE(64), SNHFREQ(128), FLAGS(0)
	GO4K_VCF	FREQUENCY(14),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_DLL	PREGAIN(21),DRY(96),FEEDBACK(35),DAMP(104),FREQUENCY(0),DEPTH(0),DELAY(19),COUNT(1)
	GO4K_VCF	FREQUENCY(28),RESONANCE(128),VCFTYPE(HIGHPASS)
	GO4K_PAN	PANNING(46)
	GO4K_OUT	GAIN(62), AUXSEND(68)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument11)
	GO4K_ENV	ATTAC(10),DECAY(80),SUSTAIN(79),RELEASE(83),GAIN(128)
	GO4K_VCO	TRANSPOSE(0),DETUNE(60),PHASE(100),GATES(85),COLOR(128),SHAPE(127),GAIN(128),FLAGS(TRISAW|LFO)
	GO4K_FST	AMOUNT(113),DEST(10*MAX_UNIT_SLOTS+5+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(8),DETUNE(64),PHASE(101),GATES(85),COLOR(0),SHAPE(1),GAIN(128),FLAGS(TRISAW|LFO)
	GO4K_FST	AMOUNT(105),DEST(12*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(60),DEST(11*MAX_UNIT_SLOTS+2+FST_SET)
	GO4K_FST	AMOUNT(97),DEST(14*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCO	TRANSPOSE(67),DETUNE(64),PHASE(113),GATES(85),COLOR(109),SHAPE(47),GAIN(72),FLAGS(SINE)
	GO4K_VCF	FREQUENCY(36),RESONANCE(31),VCFTYPE(LOWPASS)
	GO4K_VCO	TRANSPOSE(71),DETUNE(64),PHASE(70),GATES(85),COLOR(103),SHAPE(100),GAIN(64),FLAGS(TRISAW)
	GO4K_VCF	FREQUENCY(40),RESONANCE(24),VCFTYPE(LOWPASS)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(107),GATES(85),COLOR(113),SHAPE(102),GAIN(96),FLAGS(TRISAW)
	GO4K_VCF	FREQUENCY(40),RESONANCE(69),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_ENV	ATTAC(45),DECAY(88),SUSTAIN(96),RELEASE(96),GAIN(128)
	GO4K_FST	AMOUNT(88),DEST(20*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCF	FREQUENCY(32),RESONANCE(16),VCFTYPE(BANDSTOP)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(75),DRY(96),FEEDBACK(127),DAMP(114),FREQUENCY(0),DEPTH(0),DELAY(20),COUNT(1)
	GO4K_PAN	PANNING(44)
	GO4K_OUT	GAIN(12), AUXSEND(16)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Instrument15)
	GO4K_ENV	ATTAC(0),DECAY(64),SUSTAIN(64),RELEASE(76),GAIN(128)
	GO4K_FST	AMOUNT(112),DEST(0*MAX_UNIT_SLOTS+2+FST_SET)
	GO4K_VCO	TRANSPOSE(52),DETUNE(71),PHASE(0),GATES(85),COLOR(25),SHAPE(127),GAIN(128),FLAGS(TRISAW)
	GO4K_VCO	TRANSPOSE(64),DETUNE(64),PHASE(0),GATES(85),COLOR(124),SHAPE(84),GAIN(128),FLAGS(TRISAW)
	GO4K_FOP	OP(FOP_ADDP)
	GO4K_ENV	ATTAC(0),DECAY(64),SUSTAIN(18),RELEASE(64),GAIN(128)
	GO4K_FST	AMOUNT(96),DEST(9*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FST	AMOUNT(88),DEST(10*MAX_UNIT_SLOTS+4+FST_SET)
	GO4K_FOP	OP(FOP_POP)
	GO4K_VCF	FREQUENCY(18),RESONANCE(128),VCFTYPE(LOWPASS)
	GO4K_VCF	FREQUENCY(17),RESONANCE(74),VCFTYPE(LOWPASS)
	GO4K_FOP	OP(FOP_MULP)
	GO4K_DLL	PREGAIN(33),DRY(128),FEEDBACK(8),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(17),COUNT(1)
	GO4K_PAN	PANNING(64)
	GO4K_OUT	GAIN(47), AUXSEND(4)
GO4K_END_PARAMDEF
GO4K_BEGIN_PARAMDEF(Global)
	GO4K_ACC	ACCTYPE(AUX)
	GO4K_DLL	PREGAIN(24),DRY(111),FEEDBACK(39),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(1),COUNT(8)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_DLL	PREGAIN(40),DRY(128),FEEDBACK(75),DAMP(64),FREQUENCY(0),DEPTH(0),DELAY(9),COUNT(8)
	GO4K_FOP	OP(FOP_XCH)
	GO4K_ACC	ACCTYPE(OUTPUT)
	GO4K_FOP	OP(FOP_ADDP2)
	GO4K_OUT	GAIN(64), AUXSEND(0)
GO4K_END_PARAMDEF
go4k_synth_parameter_values_end
%ifdef USE_SECTIONS
section .g4kmuc5 data align=1
%else
section .data
%endif
%ifdef GO4K_USE_DLL
global _go4k_delay_times
_go4k_delay_times
	dw 0
	dw 1116
	dw 1188
	dw 1276
	dw 1356
	dw 1422
	dw 1492
	dw 1556
	dw 1618
	dw 1140
	dw 1212
	dw 1300
	dw 1380
	dw 1446
	dw 1516
	dw 1580
	dw 1642
	dw 11025
	dw 3675
	dw 16537
	dw 22050
%endif
