#version 450
layout(local_size_x = 4, local_size_y = 4, local_size_z = 2) in;

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InputData
{
    uint data[];
} in_data;

layout(set = 0, binding = 5) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 2, rgba16f) uniform writeonly image3D imTarget0;
layout(set = 0, binding = 3, rgba16f) uniform writeonly image3D imTarget1;
layout(set = 0, binding = 4, rgba16f) uniform writeonly image3D imTarget2;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal_32bit(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 2147483648u;
    vec2 _83 = (v * 2.0) - vec2(1.0);
    vec3 n;
    n.x = _83.x;
    n.y = _83.y;
    n.z = sqrt(max(0.0, 1.0 - dot(n.xy, n.xy))) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

float rt_hash(vec2 p)
{
    float h = dot(p, vec2(127.09999847412109375, 311.70001220703125));
    return (-1.0) + (2.0 * fract(sin(h) * 43758.546875));
}

vec3 randomSpherePoint(vec3 rand)
{
    float ang1 = (rand.x + 1.0) * 3.1415927410125732421875;
    float u = rand.y;
    float u2 = u * u;
    float sqrt1MinusU2 = sqrt(1.0 - u2);
    float x = sqrt1MinusU2 * cos(ang1);
    float y = sqrt1MinusU2 * sin(ang1);
    float z = u;
    return vec3(x, y, z);
}

vec3 randomHemispherePoint(vec3 rand, vec3 n)
{
    vec3 param = rand;
    vec3 v = randomSpherePoint(param);
    return v * sign(dot(v, n));
}

vec4 local_rt_cone_trace_occlusion(vec2 screen_pos, sampler3D voxel_texture, int grid_res, inout vec3 origin, vec3 dir, float range)
{
    float occ = 0.0;
    vec3 occ_color = vec3(0.0);
    origin += (dir * 4.0);
    vec2 param = screen_pos;
    float hash1 = rt_hash(param);
    vec2 param_1 = screen_pos.yx;
    float hash2 = rt_hash(param_1);
    for (int si = 0; uint(si) < 4u; si++)
    {
        vec3 p = origin;
        vec4 c = vec4(0.0);
        vec3 param_2 = vec3(hash1, hash2, 0.0);
        vec3 param_3 = dir;
        vec3 d = randomHemispherePoint(param_2, param_3);
        float lod = 0.0;
        d = normalize(mix(d, dir, vec3(0.550000011920928955078125)));
        vec2 param_4 = screen_pos + vec2(hash1, hash2);
        hash1 = rt_hash(param_4);
        vec2 param_5 = screen_pos.yx + vec2(hash2, hash1);
        hash2 = rt_hash(param_5);
        for (int i = 0; i < 64; i++)
        {
            vec3 grid_p = p;
            vec4 gc = textureLod(voxel_texture, grid_p / vec3(float(grid_res)), min(lod, 2.0));
            float blend = 1.0 - c.w;
            c.w += (gc.w * max(0.0, blend));
            vec4 _276 = c;
            vec3 _278 = _276.xyz + (gc.xyz * max(0.0, blend));
            c.x = _278.x;
            c.y = _278.y;
            c.z = _278.z;
            p = origin + ((d * float(i)) * range);
            lod *= 1.0099999904632568359375;
        }
        occ += c.w;
        occ_color += (c.xyz * dot(d, dir));
        occ += c.w;
    }
    return vec4(occ_color / vec3(4.0), occ / 4.0);
}

void main()
{
    ivec3 grid_pos_16x16x16 = ivec3(gl_WorkGroupID);
    ivec3 grid_pos = (grid_pos_16x16x16 * ivec3(16, 16, 8)) + (ivec3(gl_LocalInvocationID) * ivec3(4));
    int grid_size = int((4u * gl_NumWorkGroups.x) * 4u);
    int clear = 0;
    vec4 cube_samples_mip1[2][2][2];
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                cube_samples_mip1[iz][iy][ix] = vec4(0.0);
            }
        }
    }
    ivec3 store_pos = grid_pos;
    for (int iz_1 = 0; iz_1 < 4; iz_1++)
    {
        for (int iy_1 = 0; iy_1 < 4; iy_1++)
        {
            for (int ix_1 = 0; ix_1 < 4; ix_1++)
            {
                int source_off = (store_pos.x + (store_pos.y * grid_size)) + ((store_pos.z * grid_size) * grid_size);
                uint vi = in_data.data[source_off];
                uint param = vi;
                vec4 v = vec4(decode_normal_32bit(param), 0.0);
                clear |= int(vi != 0u);
                if (vi != 0u)
                {
                    vec2 param_1 = vec2(store_pos.xy + ivec2(store_pos.z));
                    int param_2 = 256;
                    vec3 param_3 = vec3(store_pos);
                    vec3 param_4 = -v.xyz;
                    float param_5 = 0.449999988079071044921875;
                    vec4 _487 = local_rt_cone_trace_occlusion(param_1, s_voxel_colors_filtered, param_2, param_3, param_4, param_5);
                    vec4 occlusion = _487;
                    v = occlusion;
                    vec4 _500 = v;
                    vec3 _502 = _500.xyz + textureLod(s_voxel_colors_filtered, (vec3(store_pos) + vec3(0.5)) / vec3(256.0), 0.0).xyz;
                    v.x = _502.x;
                    v.y = _502.y;
                    v.z = _502.z;
                    v.w = textureLod(s_voxel_colors_filtered, (vec3(store_pos) + vec3(0.5)) / vec3(256.0), 0.0).w;
                }
                else
                {
                    v = vec4(0.0);
                }
                imageStore(imTarget0, store_pos, v);
                int _527 = iz_1 / 2;
                int _529 = iy_1 / 2;
                int _531 = ix_1 / 2;
                cube_samples_mip1[_527][_529][_531] += v;
                store_pos.x++;
            }
            store_pos.x -= 4;
            store_pos.y++;
        }
        store_pos.y -= 4;
        store_pos.z++;
    }
    vec4 cube_samples_mip2 = vec4(0.0);
    for (int iz_2 = 0; iz_2 < 2; iz_2++)
    {
        for (int iy_2 = 0; iy_2 < 2; iy_2++)
        {
            for (int ix_2 = 0; ix_2 < 2; ix_2++)
            {
                store_pos = (grid_pos / ivec3(2)) + ivec3(ix_2, iy_2, iz_2);
                vec4 samples_color = vec4(0.0);
                samples_color.w = cube_samples_mip1[iz_2][iy_2][ix_2].w;
                if (samples_color.w > 0.0)
                {
                    float _612 = samples_color.w;
                    vec3 _614 = cube_samples_mip1[iz_2][iy_2][ix_2].xyz / vec3(_612);
                    samples_color.x = _614.x;
                    samples_color.y = _614.y;
                    samples_color.z = _614.z;
                }
                samples_color.w *= 0.25;
                imageStore(imTarget1, store_pos, samples_color);
                cube_samples_mip2 += samples_color;
            }
        }
    }
    vec4 samples_color_1 = vec4(0.0);
    samples_color_1.w = cube_samples_mip2.w;
    if (samples_color_1.w > 0.0)
    {
        float _651 = samples_color_1.w;
        vec3 _653 = cube_samples_mip2.xyz / vec3(_651);
        samples_color_1.x = _653.x;
        samples_color_1.y = _653.y;
        samples_color_1.z = _653.z;
    }
    samples_color_1.w *= 0.25;
    imageStore(imTarget2, grid_pos / ivec3(4), samples_color_1);
    if (clear == 0)
    {
        return;
    }
    store_pos = grid_pos;
    for (int iz_3 = 0; iz_3 < 4; iz_3++)
    {
        for (int iy_3 = 0; iy_3 < 4; iy_3++)
        {
            int source_off_1 = (store_pos.x + (store_pos.y * grid_size)) + ((store_pos.z * grid_size) * grid_size);
            for (int ix_3 = 0; ix_3 < 4; ix_3++)
            {
                in_data.data[source_off_1 + ix_3] = 0u;
            }
            store_pos.y++;
        }
        store_pos.y -= 4;
        store_pos.z++;
    }
}

 