#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _183
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _165;

layout(set = 1, binding = 2, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _193;

layout(location = 1) in _183 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _139 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _139.x;
    o.y = _139.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU material;
    material.diffuse = _165.colorDiffuse.xyz;
    material.emissive = vec3(0.0);
    material.metalness = 0.0;
    material.roughness = 0.5;
    material.transparency = 0.0;
    material.refraction = 0.0;
    material.flags = 0u;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _193.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos);
        vec3 dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdxFine(vtx_input.vLocalPos);
        dFdyPos = dFdyFine(vtx_input.vLocalPos);
        norm = cross(dFdyPos, dFdxPos);
        worldNorm = -worldNorm;
        norm = -norm;
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param = normal;
    int param_1 = _165.materialId;
    outNormalMaterial = encode_normal_material(param, param_1);
    float factor = 1.0;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _165.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    outAlbedo = vec4(material.diffuse, _165.colorDiffuse.w);
    outAlbedo.x = _165.colorDiffuse.xyz.x;
    outAlbedo.y = _165.colorDiffuse.xyz.y;
    outAlbedo.z = _165.colorDiffuse.xyz.z;
    vec4 _355 = outAlbedo;
    vec3 _357 = _355.xyz * vtx_input.vColor.xyz;
    outAlbedo.x = _357.x;
    outAlbedo.y = _357.y;
    outAlbedo.z = _357.z;
    outEmissive = vec4(0.0);
    float roughness = material.roughness;
    float metalness = material.metalness;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_165.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_165.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_2 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_2);
}

 