#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct InstanceModifierFactorToColor_Params
{
    vec3 color;
    int use_gradient;
    int color_gradient_idx;
    int mixing_mode;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 6, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _1370;

layout(set = 0, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1383;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1395;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1418;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1443;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1451;

layout(set = 0, binding = 8, std140) uniform VM0
{
    InstanceModifierRandomizerV2_Params VM0_params;
} _1485;

layout(set = 0, binding = 9, std140) uniform VM1
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM1_params;
} _1511;

layout(set = 0, binding = 10, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _1526;

layout(set = 0, binding = 11, std140) uniform VM3
{
    ModifierFactorRangeRemap_Params VM3_params;
} _1541;

layout(set = 0, binding = 12, std140) uniform VM4
{
    InstanceModifierRandomizerV2_Params VM4_params;
} _1553;

layout(set = 0, binding = 13, std140) uniform VM5
{
    ModifierFactorRangeRemap_Params VM5_params;
} _1577;

layout(set = 0, binding = 14, std140) uniform VM6
{
    layout(row_major) ModifierFactorNoise_Params VM6_params;
} _1588;

layout(set = 0, binding = 15, std140) uniform VM7
{
    InstanceModifierRandomizerV2_Params VM7_params;
} _1601;

layout(set = 0, binding = 5, std430) buffer VM8
{
    InstanceModifierFactorToColor_Params VM8_params;
} _1618;

layout(set = 0, binding = 16) uniform sampler2D s_Curves;
layout(set = 0, binding = 17) uniform sampler2D s_Gradients;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _253 = hash(param);
    uint param_1 = v.z;
    uint _258 = hash(param_1);
    uint param_2 = (v.x ^ _253) ^ _258;
    uint _261 = hash(param_2);
    return _261;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _290 = floatConstruct(param_1);
    return _290;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _280 = hash(param);
    uint param_1 = _280;
    float _282 = floatConstruct(param_1);
    return _282;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_factor_to_color(InstanceModifierFactorToColor_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    vec3 c = vec3(1.0);
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = fract(modifier_factor.factor);
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color * modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 0)
    {
        instance.c.x = c.x;
        instance.c.y = c.y;
        instance.c.z = c.z;
    }
    if (modifier_params.mixing_mode == 1)
    {
        vec4 _1330 = instance.c;
        vec3 _1336 = mix(_1330.xyz, c, vec3(modifier_factor.factor));
        instance.c.x = _1336.x;
        instance.c.y = _1336.y;
        instance.c.z = _1336.z;
    }
    if (modifier_params.mixing_mode == 2)
    {
        vec4 _1350 = instance.c;
        vec3 _1352 = _1350.xyz + c;
        instance.c.x = _1352.x;
        instance.c.y = _1352.y;
        instance.c.z = _1352.z;
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_1370.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_1383.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _1395.instance_transform[(id * 3u) + 0u];
    instance.m1 = _1395.instance_transform[(id * 3u) + 1u];
    instance.m2 = _1395.instance_transform[(id * 3u) + 2u];
    vec2 _1425 = unpackHalf2x16(_1418.instance_color[(id * 2u) + 0u]);
    instance.c.x = _1425.x;
    instance.c.y = _1425.y;
    vec2 _1435 = unpackHalf2x16(_1418.instance_color[(id * 2u) + 1u]);
    instance.c.z = _1435.x;
    instance.c.w = _1435.y;
    instance.flipbook_card = _1443.instance_flipbook_card[id];
    instance.hash = _1451.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    InstanceModifierRandomizerV2_Params _1490;
    _1490.replace_previous_rotation_scale = _1485.VM0_params.replace_previous_rotation_scale;
    _1490.randomness_seed = _1485.VM0_params.randomness_seed;
    _1490.replace_previous_position = _1485.VM0_params.replace_previous_position;
    _1490.randomization_input = _1485.VM0_params.randomization_input;
    _1490.position_modifier_base = _1485.VM0_params.position_modifier_base;
    _1490.position_modifier_base_modifier_factor = _1485.VM0_params.position_modifier_base_modifier_factor;
    _1490.position_modifier_range = _1485.VM0_params.position_modifier_range;
    _1490.position_modifier_range_modifier_factor = _1485.VM0_params.position_modifier_range_modifier_factor;
    _1490.rotation_modifier_base = _1485.VM0_params.rotation_modifier_base;
    _1490.rotation_modifier_base_modifier_factor = _1485.VM0_params.rotation_modifier_base_modifier_factor;
    _1490.rotation_modifier_range = _1485.VM0_params.rotation_modifier_range;
    _1490.rotation_modifier_range_modifier_factor = _1485.VM0_params.rotation_modifier_range_modifier_factor;
    _1490.scale_modifier_base = _1485.VM0_params.scale_modifier_base;
    _1490.scale_modifier_base_modifier_factor = _1485.VM0_params.scale_modifier_base_modifier_factor;
    _1490.scale_modifier_range = _1485.VM0_params.scale_modifier_range;
    _1490.scale_modifier_range_modifier_factor = _1485.VM0_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param = _1490;
    ModifierFactor param_1 = modifier_factor;
    Instance param_2 = instance;
    uint param_3 = id;
    instance_modifier_randomizer_v2(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    instance = param_2;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorDistanceRadial_Params _1516;
    _1516.transform_local_to_gizmo = _1511.VM1_params.transform_local_to_gizmo;
    _1516.falloff_curve_idx = _1511.VM1_params.falloff_curve_idx;
    _1516.falloff_inverse = _1511.VM1_params.falloff_inverse;
    _1516.domain_repeat_x = _1511.VM1_params.domain_repeat_x;
    _1516.domain_repeat_y = _1511.VM1_params.domain_repeat_y;
    _1516.domain_repeat_z = _1511.VM1_params.domain_repeat_z;
    _1516.influence_scope = _1511.VM1_params.influence_scope;
    _1516.modifier_function = _1511.VM1_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_4 = _1516;
    ModifierFactor param_5 = modifier_factor;
    CoordinateSystemTrasforms param_6 = cs_transforms;
    modifier_factor_distance_radial(param_4, param_5, param_6);
    modifier_factor = param_5;
    ModifierFactorNoise_Params _1531;
    _1531.transform_local_to_gizmo = _1526.VM2_params.transform_local_to_gizmo;
    _1531.noise_domain_scale = _1526.VM2_params.noise_domain_scale;
    _1531.modifier_function = _1526.VM2_params.modifier_function;
    _1531.noise_domain_offset = _1526.VM2_params.noise_domain_offset;
    _1531.noise_value_scale = _1526.VM2_params.noise_value_scale;
    _1531.noise_value_offset = _1526.VM2_params.noise_value_offset;
    _1531.influence_scope = _1526.VM2_params.influence_scope;
    _1531._pad0 = _1526.VM2_params._pad0;
    _1531._pad1 = _1526.VM2_params._pad1;
    ModifierFactorNoise_Params param_7 = _1531;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_noise(param_7, param_8, param_9);
    modifier_factor = param_8;
    ModifierFactorRangeRemap_Params _1546;
    _1546.input_min = _1541.VM3_params.input_min;
    _1546.input_max = _1541.VM3_params.input_max;
    _1546.output_min = _1541.VM3_params.output_min;
    _1546.output_max = _1541.VM3_params.output_max;
    _1546.min_out_of_bounds_mode = _1541.VM3_params.min_out_of_bounds_mode;
    _1546.max_out_of_bounds_mode = _1541.VM3_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_10 = _1546;
    ModifierFactor param_11 = modifier_factor;
    modifier_factor_range_remap(param_10, param_11);
    modifier_factor = param_11;
    InstanceModifierRandomizerV2_Params _1557;
    _1557.replace_previous_rotation_scale = _1553.VM4_params.replace_previous_rotation_scale;
    _1557.randomness_seed = _1553.VM4_params.randomness_seed;
    _1557.replace_previous_position = _1553.VM4_params.replace_previous_position;
    _1557.randomization_input = _1553.VM4_params.randomization_input;
    _1557.position_modifier_base = _1553.VM4_params.position_modifier_base;
    _1557.position_modifier_base_modifier_factor = _1553.VM4_params.position_modifier_base_modifier_factor;
    _1557.position_modifier_range = _1553.VM4_params.position_modifier_range;
    _1557.position_modifier_range_modifier_factor = _1553.VM4_params.position_modifier_range_modifier_factor;
    _1557.rotation_modifier_base = _1553.VM4_params.rotation_modifier_base;
    _1557.rotation_modifier_base_modifier_factor = _1553.VM4_params.rotation_modifier_base_modifier_factor;
    _1557.rotation_modifier_range = _1553.VM4_params.rotation_modifier_range;
    _1557.rotation_modifier_range_modifier_factor = _1553.VM4_params.rotation_modifier_range_modifier_factor;
    _1557.scale_modifier_base = _1553.VM4_params.scale_modifier_base;
    _1557.scale_modifier_base_modifier_factor = _1553.VM4_params.scale_modifier_base_modifier_factor;
    _1557.scale_modifier_range = _1553.VM4_params.scale_modifier_range;
    _1557.scale_modifier_range_modifier_factor = _1553.VM4_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_12 = _1557;
    ModifierFactor param_13 = modifier_factor;
    Instance param_14 = instance;
    uint param_15 = id;
    instance_modifier_randomizer_v2(param_12, param_13, param_14, param_15);
    modifier_factor = param_13;
    instance = param_14;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    ModifierFactorRangeRemap_Params _1581;
    _1581.input_min = _1577.VM5_params.input_min;
    _1581.input_max = _1577.VM5_params.input_max;
    _1581.output_min = _1577.VM5_params.output_min;
    _1581.output_max = _1577.VM5_params.output_max;
    _1581.min_out_of_bounds_mode = _1577.VM5_params.min_out_of_bounds_mode;
    _1581.max_out_of_bounds_mode = _1577.VM5_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_16 = _1581;
    ModifierFactor param_17 = modifier_factor;
    modifier_factor_range_remap(param_16, param_17);
    modifier_factor = param_17;
    ModifierFactorNoise_Params _1592;
    _1592.transform_local_to_gizmo = _1588.VM6_params.transform_local_to_gizmo;
    _1592.noise_domain_scale = _1588.VM6_params.noise_domain_scale;
    _1592.modifier_function = _1588.VM6_params.modifier_function;
    _1592.noise_domain_offset = _1588.VM6_params.noise_domain_offset;
    _1592.noise_value_scale = _1588.VM6_params.noise_value_scale;
    _1592.noise_value_offset = _1588.VM6_params.noise_value_offset;
    _1592.influence_scope = _1588.VM6_params.influence_scope;
    _1592._pad0 = _1588.VM6_params._pad0;
    _1592._pad1 = _1588.VM6_params._pad1;
    ModifierFactorNoise_Params param_18 = _1592;
    ModifierFactor param_19 = modifier_factor;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    modifier_factor_noise(param_18, param_19, param_20);
    modifier_factor = param_19;
    InstanceModifierRandomizerV2_Params _1605;
    _1605.replace_previous_rotation_scale = _1601.VM7_params.replace_previous_rotation_scale;
    _1605.randomness_seed = _1601.VM7_params.randomness_seed;
    _1605.replace_previous_position = _1601.VM7_params.replace_previous_position;
    _1605.randomization_input = _1601.VM7_params.randomization_input;
    _1605.position_modifier_base = _1601.VM7_params.position_modifier_base;
    _1605.position_modifier_base_modifier_factor = _1601.VM7_params.position_modifier_base_modifier_factor;
    _1605.position_modifier_range = _1601.VM7_params.position_modifier_range;
    _1605.position_modifier_range_modifier_factor = _1601.VM7_params.position_modifier_range_modifier_factor;
    _1605.rotation_modifier_base = _1601.VM7_params.rotation_modifier_base;
    _1605.rotation_modifier_base_modifier_factor = _1601.VM7_params.rotation_modifier_base_modifier_factor;
    _1605.rotation_modifier_range = _1601.VM7_params.rotation_modifier_range;
    _1605.rotation_modifier_range_modifier_factor = _1601.VM7_params.rotation_modifier_range_modifier_factor;
    _1605.scale_modifier_base = _1601.VM7_params.scale_modifier_base;
    _1605.scale_modifier_base_modifier_factor = _1601.VM7_params.scale_modifier_base_modifier_factor;
    _1605.scale_modifier_range = _1601.VM7_params.scale_modifier_range;
    _1605.scale_modifier_range_modifier_factor = _1601.VM7_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_21 = _1605;
    ModifierFactor param_22 = modifier_factor;
    Instance param_23 = instance;
    uint param_24 = id;
    instance_modifier_randomizer_v2(param_21, param_22, param_23, param_24);
    modifier_factor = param_22;
    instance = param_23;
    InstanceModifierFactorToColor_Params _1623;
    _1623.color = _1618.VM8_params.color;
    _1623.use_gradient = _1618.VM8_params.use_gradient;
    _1623.color_gradient_idx = _1618.VM8_params.color_gradient_idx;
    _1623.mixing_mode = _1618.VM8_params.mixing_mode;
    InstanceModifierFactorToColor_Params param_25 = _1623;
    ModifierFactor param_26 = modifier_factor;
    Instance param_27 = instance;
    instance_modifier_factor_to_color(param_25, param_26, param_27);
    modifier_factor = param_26;
    instance = param_27;
    _1395.instance_transform[(id * 3u) + 0u] = instance.m0;
    _1395.instance_transform[(id * 3u) + 1u] = instance.m1;
    _1395.instance_transform[(id * 3u) + 2u] = instance.m2;
    _1418.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1418.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1443.instance_flipbook_card[id] = instance.flipbook_card;
}

 