#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _803
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _925;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _939;

layout(set = 1, binding = 4, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _1272;

layout(set = 1, binding = 5, std140) uniform VM1
{
    ModifierFactorRangeRemap_Params VM1_params;
} _1287;

layout(set = 1, binding = 6, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _1300;

layout(set = 1, binding = 7) uniform sampler2D s_Curves;
layout(set = 1, binding = 8) uniform sampler2D material_textures[64];

layout(location = 1) in _803 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

vec3 mapping_triplanar_normal(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec3 axis_sign = sign(n);
    vec3 xaxis = (texture(smpl, coords.zy * scale.zy).xyz * 2.0) - vec3(1.0);
    vec3 yaxis = (texture(smpl, coords.xz * scale.xz).xyz * 2.0) - vec3(1.0);
    vec3 zaxis = (texture(smpl, coords.xy * scale.xy).xyz * 2.0) - vec3(1.0);
    xaxis.z *= axis_sign.x;
    yaxis.z *= axis_sign.y;
    zaxis.z *= axis_sign.z;
    vec3 tex = normalize(((xaxis.zyx * blending.x) + (yaxis.xzy * blending.y)) + (zaxis * blending.z));
    return tex;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _779 = material.albedo_sampler >= 0;
    bool _786;
    if (_779)
    {
        _786 = material.albedo_sampler < 16;
    }
    else
    {
        _786 = _779;
    }
    if (_786)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], param, param_1, param_2);
        }
        else
        {
            material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    bool _829 = material.emissive_sampler >= 0;
    bool _835;
    if (_829)
    {
        _835 = material.emissive_sampler < 16;
    }
    else
    {
        _835 = _829;
    }
    if (_835)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_3 = vtx_input.vLocalPos;
            vec3 param_4 = norm;
            vec3 param_5 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param_3, param_4, param_5).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
    bool _870 = material.metalic_roughness_sampler >= 0;
    bool _876;
    if (_870)
    {
        _876 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _876 = _870;
    }
    if (_876)
    {
        vec2 metalic_roughness = vec2(1.0);
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_6 = vtx_input.vLocalPos;
            vec3 param_7 = norm;
            vec3 param_8 = material.triplanar_factor;
            metalic_roughness = mapping_triplanar(material_textures[material.metalic_roughness_sampler], param_6, param_7, param_8).xy;
        }
        else
        {
            metalic_roughness = texture(material_textures[material.metalic_roughness_sampler], uv0).xy;
        }
        material_eval.metalness_texture = clamp(metalic_roughness.x, 0.0, 1.0);
        material_eval.roughness_texture = clamp(metalic_roughness.y, 0.0, 1.0);
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    float factor = eval_input.modifier_factor;
    eval.is_discarded = fract(factor) > 0.800000011920928955078125;
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _245 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _245.x;
    o.y = _245.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _932;
    _932.diffuse = materials.material_properties[_925.materialIndex].diffuse;
    _932.transparency = materials.material_properties[_925.materialIndex].transparency;
    _932.emissive = materials.material_properties[_925.materialIndex].emissive;
    _932.roughness = materials.material_properties[_925.materialIndex].roughness;
    _932.triplanar_factor = materials.material_properties[_925.materialIndex].triplanar_factor;
    _932.refraction = materials.material_properties[_925.materialIndex].refraction;
    _932.normal_factor = materials.material_properties[_925.materialIndex].normal_factor;
    _932.emissive_factor = materials.material_properties[_925.materialIndex].emissive_factor;
    _932.temporal_accumulation_factor = materials.material_properties[_925.materialIndex].temporal_accumulation_factor;
    _932.shadowmap_bias = materials.material_properties[_925.materialIndex].shadowmap_bias;
    _932.metalness = materials.material_properties[_925.materialIndex].metalness;
    _932.albedo_sampler = materials.material_properties[_925.materialIndex].albedo_sampler;
    _932.emissive_sampler = materials.material_properties[_925.materialIndex].emissive_sampler;
    _932.normal_sampler = materials.material_properties[_925.materialIndex].normal_sampler;
    _932.metalic_roughness_sampler = materials.material_properties[_925.materialIndex].metalic_roughness_sampler;
    _932.flags = materials.material_properties[_925.materialIndex].flags;
    _932._pad0 = materials.material_properties[_925.materialIndex]._pad0;
    _932._pad1 = materials.material_properties[_925.materialIndex]._pad1;
    MaterialPropertiesGPU material = _932;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _939.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos);
        vec3 dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdxFine(vtx_input.vLocalPos);
        dFdyPos = dFdyFine(vtx_input.vLocalPos);
        norm = cross(dFdyPos, dFdxPos);
        worldNorm = -worldNorm;
        norm = -norm;
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    bool _1042 = material.normal_sampler >= 0;
    bool _1048;
    if (_1042)
    {
        _1048 = material.normal_sampler < 16;
    }
    else
    {
        _1048 = _1042;
    }
    if (_1048)
    {
        if ((material.flags & 1024u) == 0u)
        {
            vec3 pos_dx = dFdxFine(worldPos);
            vec3 pos_dy = dFdyFine(worldPos);
            vec3 tex_dx = dFdxFine(vec3(vtx_input.vUV0, 0.0));
            vec3 tex_dy = dFdyFine(vec3(vtx_input.vUV0, 0.0));
            float denom = (tex_dx.x * tex_dy.y) - (tex_dy.x * tex_dx.y);
            if (abs(denom) >= 1.0000000133514319600180897396058e-10)
            {
                vec3 t = ((pos_dx * tex_dy.y) - (pos_dy * tex_dx.y)) / vec3(denom);
                vec3 ng = normal;
                t = normalize(t - (ng * dot(ng, t)));
                vec3 b = normalize(cross(ng, t));
                mat3 tbn = mat3(vec3(t), vec3(b), vec3(ng));
                vec3 n = (texture(material_textures[material.normal_sampler], vtx_input.vUV0).xyz * 2.0) - vec3(1.0);
                n = mix(normal, n, vec3(material.normal_factor));
                n = normalize(n * transpose(tbn));
                normal = n;
            }
        }
        else
        {
            vec3 param_11 = vtx_input.vLocalPos;
            vec3 param_12 = norm;
            vec3 param_13 = material.triplanar_factor;
            vec3 n_1 = mapping_triplanar_normal(material_textures[material.normal_sampler], param_11, param_12, param_13);
            vec3 param_14 = n_1;
            mat4 param_15 = _939.transform_params.mModelNormal;
            n_1 = vector_transform_by_mat33(param_14, param_15);
            mat4 m = _939.transform_params.mModelNormal;
            vec3 scale;
            scale.x = length(vec3(m[0].x, m[0].y, m[0].z));
            scale.y = length(vec3(m[1].x, m[1].y, m[1].z));
            scale.z = length(vec3(m[2].x, m[2].y, m[2].z));
            n_1 *= (vec3(1.0) / scale);
            n_1 = normalize(n_1);
            n_1 = normalize(mix(normal, n_1, vec3(material.normal_factor)));
            normal = n_1;
        }
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_16 = normal;
    int param_17 = _925.materialId;
    outNormalMaterial = encode_normal_material(param_16, param_17);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _939.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _939.transform_params.mModelInv;
    ModifierFactorDistanceRadial_Params _1277;
    _1277.transform_local_to_gizmo = _1272.VM0_params.transform_local_to_gizmo;
    _1277.falloff_curve_idx = _1272.VM0_params.falloff_curve_idx;
    _1277.falloff_inverse = _1272.VM0_params.falloff_inverse;
    _1277.domain_repeat_x = _1272.VM0_params.domain_repeat_x;
    _1277.domain_repeat_y = _1272.VM0_params.domain_repeat_y;
    _1277.domain_repeat_z = _1272.VM0_params.domain_repeat_z;
    _1277.influence_scope = _1272.VM0_params.influence_scope;
    _1277.modifier_function = _1272.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_18 = _1277;
    ModifierFactor param_19 = modifier_factor;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    modifier_factor_distance_radial(param_18, param_19, param_20);
    modifier_factor = param_19;
    ModifierFactorRangeRemap_Params _1292;
    _1292.input_min = _1287.VM1_params.input_min;
    _1292.input_max = _1287.VM1_params.input_max;
    _1292.output_min = _1287.VM1_params.output_min;
    _1292.output_max = _1287.VM1_params.output_max;
    _1292.min_out_of_bounds_mode = _1287.VM1_params.min_out_of_bounds_mode;
    _1292.max_out_of_bounds_mode = _1287.VM1_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_21 = _1292;
    ModifierFactor param_22 = modifier_factor;
    modifier_factor_range_remap(param_21, param_22);
    modifier_factor = param_22;
    ModifierFactorMulAdd_Params _1305;
    _1305.multiply_value = _1300.VM2_params.multiply_value;
    _1305.add_value = _1300.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_23 = _1305;
    ModifierFactor param_24 = modifier_factor;
    modifier_factor_mul_add(param_23, param_24);
    modifier_factor = param_24;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _925.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param_25 = material;
    MaterialEval param_26 = material_eval;
    MaterialEvalInput param_27 = eval_input;
    material_evaluate(param_25, param_26, param_27);
    material_eval = param_26;
    eval_input = param_27;
    if ((material_eval.flag_overrides & 2u) != 0u)
    {
        material_flag_overrides = material_eval.flag_overrides;
    }
    if (material_eval.is_discarded)
    {
        discard;
    }
    outAlbedo = material_eval.albedo * material_eval.albedo_texture;
    vec3 _1397 = material_eval.emissive * material_eval.emissive_texture;
    outEmissive.x = _1397.x;
    outEmissive.y = _1397.y;
    outEmissive.z = _1397.z;
    outEmissive.w = 0.0;
    float roughness = material_eval.roughness * material_eval.roughness_texture;
    float metalness = material_eval.metalness * material_eval.metalness_texture;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_925.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_925.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_28 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_28);
}

 