#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _42;

layout(set = 0, binding = 2, std430) buffer GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _70;

layout(set = 0, binding = 6, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _78;

layout(set = 0, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _101;

layout(set = 0, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _138;

layout(set = 0, binding = 4, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _175;

layout(set = 0, binding = 5, std430) buffer IndexBuffer
{
    uint vtx_indices[];
} _184;

layout(set = 0, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

void rt_set_face_idx_material_flags(uint face_idx, inout uint v0, inout uint v1, uint v2, uint flags)
{
    uint flags0 = (flags >> uint(0)) & 255u;
    uint flags1 = (flags >> uint(8)) & 255u;
    v0 = (flags0 << uint(24)) | v0;
    v1 = (flags1 << uint(24)) | v1;
    _42.transformed_data_indices[(face_idx * 3u) + 0u] = v0;
    _42.transformed_data_indices[(face_idx * 3u) + 1u] = v1;
    _42.transformed_data_indices[(face_idx * 3u) + 2u] = v2;
}

void main()
{
    uint faces_per_instance = _70.geometry_information.faces_num_per_surface[_78.transform_geometry_params.surface_idx];
    uint points_per_instance = _70.geometry_information.vtx_num;
    uint instance_id = gl_GlobalInvocationID.x / faces_per_instance;
    if (instance_id >= uint(_101.instance_params.instance_count))
    {
        return;
    }
    uint in_face_idx = gl_GlobalInvocationID.x - (instance_id * faces_per_instance);
    uint prim_idx = _78.transform_geometry_params.instance_idx;
    uint out_face_idx = gl_GlobalInvocationID.x;
    uint base_vtx_idx = 0u;
    if (prim_idx == 0u)
    {
        out_face_idx = out_face_idx;
    }
    else
    {
        out_face_idx = (_138.transformed_data_location[prim_idx - 1u].last_face_idx + out_face_idx) + 1u;
        if (((int(prim_idx) - 1) - int(_78.transform_geometry_params.surface_idx)) >= 0)
        {
            base_vtx_idx = _138.transformed_data_location[(prim_idx - 1u) - _78.transform_geometry_params.surface_idx].last_vtx_idx + 1u;
        }
    }
    uint instance_base_vtx = instance_id * points_per_instance;
    base_vtx_idx += instance_base_vtx;
    _175.transformed_data_faces[out_face_idx].material_idx = _78.transform_geometry_params.material_idx;
    uint param = out_face_idx;
    uint param_1 = _184.vtx_indices[(in_face_idx * 3u) + 0u] + base_vtx_idx;
    uint param_2 = _184.vtx_indices[(in_face_idx * 3u) + 1u] + base_vtx_idx;
    uint param_3 = _184.vtx_indices[(in_face_idx * 3u) + 2u] + base_vtx_idx;
    uint param_4 = materials.material_properties[_78.transform_geometry_params.material_idx].flags;
    rt_set_face_idx_material_flags(param, param_1, param_2, param_3, param_4);
}

 