#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct VertexModifierFaceUnwrapParams
{
    float unwrap_factor;
    float face_stretch;
    float unwrap_spacing;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _1137
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) buffer VTXTweenIdx
{
    uint tween_idx[];
} vtx_tween_idx;

layout(set = 0, binding = 10, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _793;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _804;

layout(set = 0, binding = 11, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _815;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _901;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1093;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1111;

layout(set = 0, binding = 13, std140) uniform VM0
{
    VertexModifierFaceUnwrapParams VM0_params;
} _1124;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1228;

layout(location = 1) out _1137 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_tween_idx_load(uint idx)
{
    return vtx_tween_idx.tween_idx[idx];
}

uint face_unwrap_decode_tween_distance(uint tween)
{
    return tween >> uint(2);
}

uint face_unwrap_decode_tween_edge(uint tween)
{
    return tween & 3u;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

vec3 _TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void vertex_modifier_face_unwrap_apply(VertexModifierFaceUnwrapParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    uint param = vtx.id;
    uint tween = vtx_tween_idx_load(param);
    uint param_1 = tween;
    uint tween_distance = face_unwrap_decode_tween_distance(param_1);
    uint param_2 = tween;
    uint tween_edge = face_unwrap_decode_tween_edge(param_2);
    uint v_idx = vtx.id;
    uint v_idx_in_face = v_idx % 3u;
    uint axis_v0_idx;
    uint axis_v1_idx;
    if (tween_edge == 0u)
    {
        axis_v0_idx = (v_idx - v_idx_in_face) + 0u;
        axis_v1_idx = (v_idx - v_idx_in_face) + 1u;
    }
    else
    {
        if (tween_edge == 1u)
        {
            axis_v0_idx = (v_idx - v_idx_in_face) + 1u;
            axis_v1_idx = (v_idx - v_idx_in_face) + 2u;
        }
        else
        {
            axis_v0_idx = (v_idx - v_idx_in_face) + 2u;
            axis_v1_idx = (v_idx - v_idx_in_face) + 0u;
        }
    }
    uint param_3 = axis_v0_idx;
    vec3 axis_v0 = vtx_coords_load(param_3);
    uint param_4 = axis_v1_idx;
    vec3 axis_v1 = vtx_coords_load(param_4);
    float tween_factor = clamp((modifier_params.unwrap_factor * modifier_params.unwrap_spacing) - (float(tween_distance) * modifier_params.unwrap_spacing), 0.0, 1.0);
    float angle_in_radians = tween_factor * 3.1415927410125732421875;
    float face_scale = tween_factor;
    if (face_scale <= 9.9999997473787516355514526367188e-06)
    {
        vtx.pos = axis_v0;
    }
    vec3 param_5 = normalize(axis_v1 - axis_v0);
    float param_6 = angle_in_radians + 3.1415927410125732421875;
    vec4 q = quaternion_from_axis_angle(param_5, param_6);
    vec3 v = vtx.pos;
    vec3 vc = (axis_v0 + axis_v1) * 0.5;
    if ((v_idx != axis_v0_idx) && (v_idx != axis_v1_idx))
    {
        float enlarge = 1.0 + (sin(face_scale * 3.1415927410125732421875) * modifier_params.face_stretch);
        float f = face_scale * enlarge;
        v = mix(vc, v, vec3(f));
    }
    vec3 param_7 = vtx.norm;
    vec4 param_8 = q;
    vtx.norm = vector_rotate_by_quaternion(param_7, param_8);
    vec3 param_9 = v - axis_v0;
    vec4 param_10 = q;
    v = vector_rotate_by_quaternion(param_9, param_10);
    v += axis_v0;
    if ((v_idx != axis_v0_idx) && (v_idx != axis_v1_idx))
    {
    }
    float f_1 = fract(float(tween_distance) * 0.01730999909341335296630859375);
    float param_11 = face_scale;
    vec3 _556 = _TurboColormap(param_11);
    vec3 c = _556;
    vtx.color.x = 1.0;
    vtx.color.y = 1.0;
    vtx.color.z = 1.0;
    vtx.pos = v;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    m[2].x = 0.0;
    m[2].y = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_793.instance_params.stride > 0)
    {
        uint flipbook_card = _804.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_815.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_815.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_815.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_815.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_815.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_793.instance_params.stride > 0)
    {
        vec4 inst_m0 = _901.instance_transform[(gl_InstanceIndex * _793.instance_params.stride) + 0];
        vec4 inst_m1 = _901.instance_transform[(gl_InstanceIndex * _793.instance_params.stride) + 1];
        vec4 inst_m2 = _901.instance_transform[(gl_InstanceIndex * _793.instance_params.stride) + 2];
        vec3 _932 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _932.x;
        mat_instance_model[0].y = _932.y;
        mat_instance_model[0].z = _932.z;
        vec3 _945 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _945.x;
        mat_instance_model[1].y = _945.y;
        mat_instance_model[1].z = _945.z;
        vec3 _958 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _958.x;
        mat_instance_model[2].y = _958.y;
        mat_instance_model[2].z = _958.z;
        vec3 _971 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _971.x;
        mat_instance_model[3].y = _971.y;
        mat_instance_model[3].z = _971.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_793.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1093.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1111.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1111.transform_params.mModelInv;
    VertexModifierFaceUnwrapParams _1129;
    _1129.unwrap_factor = _1124.VM0_params.unwrap_factor;
    _1129.face_stretch = _1124.VM0_params.face_stretch;
    _1129.unwrap_spacing = _1124.VM0_params.unwrap_spacing;
    VertexModifierFaceUnwrapParams param_5 = _1129;
    ModifierFactor param_6 = modifier_factor;
    VertexInput param_7 = vtx_input;
    vertex_modifier_face_unwrap_apply(param_5, param_6, param_7);
    modifier_factor = param_6;
    vtx_input = param_7;
    vtx_output.vLocalPos = vtx_input.pos;
    if (_793.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _901.instance_transform[(gl_InstanceIndex * _793.instance_params.stride) + 0];
        vec4 inst_m1_1 = _901.instance_transform[(gl_InstanceIndex * _793.instance_params.stride) + 1];
        vec4 inst_m2_1 = _901.instance_transform[(gl_InstanceIndex * _793.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_8 = vtx_input.norm;
        mat4 param_9 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_8, param_9));
        vec2 _1234 = unpackHalf2x16(_1228.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1234.x;
        inst_c.y = _1234.y;
        vec2 _1244 = unpackHalf2x16(_1228.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1244.x;
        inst_c.w = _1244.y;
        vec4 _1250 = vtx_input.color;
        vec3 _1254 = _1250.xyz * inst_c.xyz;
        vtx_input.color.x = _1254.x;
        vtx_input.color.y = _1254.y;
        vtx_input.color.z = _1254.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vec3 param_10 = vtx_input.pos;
    mat4 param_11 = _1111.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_10, param_11);
    vec3 param_12 = vtx_input.norm;
    mat4 param_13 = _1111.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_12, param_13);
    vec3 param_14 = vPosModel;
    mat4 param_15 = _1111.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_14, param_15);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1111.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_1111.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1111.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1111.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    vec3 param_16 = vtx_output.vCoords;
    mat4 param_17 = _1111.transform_params.mProjection;
    vec4 _1356 = vector_transform_by_mat_projection(param_16, param_17);
    gl_Position = _1356;
}

 