#version 450
layout(local_size_x = 32, local_size_y = 1, local_size_z = 1) in;

struct DrawArraysIndirectParams
{
    uint count;
    uint instance_count;
    uint first_index;
    uint base_instance;
};

struct BuildDrawIndirectFromBufferParams
{
    uint indirect_buffer_idx;
    uint src_buffer_offset;
    uint src_buffer_data_numerator;
    uint src_buffer_data_denominator;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

layout(set = 0, binding = 1, std430) buffer DrawArraysIndirectParamsBuffer
{
    DrawArraysIndirectParams draw_indirect_params[];
} _27;

layout(set = 0, binding = 3, std140) uniform BuildDrawIndirectFromBufferParamsBuffer
{
    BuildDrawIndirectFromBufferParams params;
} _33;

layout(set = 0, binding = 2, std430) buffer DrawIndirectSourceBuffer
{
    uint draw_indirect_src_data[];
} _40;

layout(set = 0, binding = 4, std140) uniform DrawIndirectInstanceParamsBuffer
{
    InstanceParams draw_indirect_instance_params;
} _61;

void main()
{
    uint idx = gl_GlobalInvocationID.x;
    if (idx == 0u)
    {
        _27.draw_indirect_params[_33.params.indirect_buffer_idx].count = (_40.draw_indirect_src_data[_33.params.src_buffer_offset] * _33.params.src_buffer_data_numerator) / _33.params.src_buffer_data_denominator;
        _27.draw_indirect_params[_33.params.indirect_buffer_idx].instance_count = uint(min(_61.draw_indirect_instance_params.buffer_capacity, _61.draw_indirect_instance_params.instance_count));
        _27.draw_indirect_params[_33.params.indirect_buffer_idx].first_index = 0u;
        _27.draw_indirect_params[_33.params.indirect_buffer_idx].base_instance = 0u;
    }
}

 