#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceModifierLookAt_Params
{
    vec3 ref_position;
    int look_away;
    int axis;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 5, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _702;

layout(set = 0, binding = 6, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _715;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _727;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _750;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _776;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _784;

layout(set = 0, binding = 7, std140) uniform VM0
{
    InstanceModifierLookAt_Params VM0_params;
} _820;

layout(set = 0, binding = 8, std140) uniform VM1
{
    InstanceModifierRandomizerV2_Params VM1_params;
} _838;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void instance_modifier_look_at(InstanceModifierLookAt_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    vec3 ref_position = modifier_params.ref_position;
    vec3 pos = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    vec3 nx = vec3(instance.m0.x, instance.m1.x, instance.m2.x);
    vec3 ny = vec3(instance.m0.y, instance.m1.y, instance.m2.y);
    vec3 nz = vec3(instance.m0.z, instance.m1.z, instance.m2.z);
    vec3 dir = normalize(pos - ref_position);
    if (modifier_params.look_away != 0)
    {
        dir *= (-1.0);
    }
    vec3 nnx;
    vec3 nny;
    vec3 nnz;
    if (modifier_params.axis == 0)
    {
        nnx = dir;
        nny = normalize(ny);
        nnz = normalize(cross(nnx, nny));
        nny = cross(nnx, nnz);
    }
    else
    {
        if (modifier_params.axis == 1)
        {
            nny = dir;
            nnx = normalize(nx);
            nnz = normalize(cross(nny, nnx));
            nnx = cross(nny, nnz);
        }
        else
        {
            nnz = dir;
            nnx = normalize(nx);
            nny = normalize(cross(nnz, nnx));
            nnx = cross(nny, nnz);
        }
    }
    nnx *= length(nx);
    nny *= length(ny);
    nnz *= length(nz);
    vec3 _293 = vec3(nnx.x, nny.x, nnz.x);
    instance.m0.x = _293.x;
    instance.m0.y = _293.y;
    instance.m0.z = _293.z;
    vec3 _306 = vec3(nnx.y, nny.y, nnz.y);
    instance.m1.x = _306.x;
    instance.m1.y = _306.y;
    instance.m1.z = _306.z;
    vec3 _319 = vec3(nnx.z, nny.z, nnz.z);
    instance.m2.x = _319.x;
    instance.m2.y = _319.y;
    instance.m2.z = _319.z;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _139 = hash(param);
    uint param_1 = v.z;
    uint _145 = hash(param_1);
    uint param_2 = (v.x ^ _139) ^ _145;
    uint _148 = hash(param_2);
    return _148;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _177 = floatConstruct(param_1);
    return _177;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _167 = hash(param);
    uint param_1 = _167;
    float _169 = floatConstruct(param_1);
    return _169;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_702.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_715.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _727.instance_transform[(id * 3u) + 0u];
    instance.m1 = _727.instance_transform[(id * 3u) + 1u];
    instance.m2 = _727.instance_transform[(id * 3u) + 2u];
    vec2 _758 = unpackHalf2x16(_750.instance_color[(id * 2u) + 0u]);
    instance.c.x = _758.x;
    instance.c.y = _758.y;
    vec2 _768 = unpackHalf2x16(_750.instance_color[(id * 2u) + 1u]);
    instance.c.z = _768.x;
    instance.c.w = _768.y;
    instance.flipbook_card = _776.instance_flipbook_card[id];
    instance.hash = _784.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    InstanceModifierLookAt_Params _825;
    _825.ref_position = _820.VM0_params.ref_position;
    _825.look_away = _820.VM0_params.look_away;
    _825.axis = _820.VM0_params.axis;
    InstanceModifierLookAt_Params param = _825;
    ModifierFactor param_1 = modifier_factor;
    Instance param_2 = instance;
    uint param_3 = id;
    instance_modifier_look_at(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    instance = param_2;
    InstanceModifierRandomizerV2_Params _843;
    _843.replace_previous_rotation_scale = _838.VM1_params.replace_previous_rotation_scale;
    _843.randomness_seed = _838.VM1_params.randomness_seed;
    _843.replace_previous_position = _838.VM1_params.replace_previous_position;
    _843.randomization_input = _838.VM1_params.randomization_input;
    _843.position_modifier_base = _838.VM1_params.position_modifier_base;
    _843.position_modifier_base_modifier_factor = _838.VM1_params.position_modifier_base_modifier_factor;
    _843.position_modifier_range = _838.VM1_params.position_modifier_range;
    _843.position_modifier_range_modifier_factor = _838.VM1_params.position_modifier_range_modifier_factor;
    _843.rotation_modifier_base = _838.VM1_params.rotation_modifier_base;
    _843.rotation_modifier_base_modifier_factor = _838.VM1_params.rotation_modifier_base_modifier_factor;
    _843.rotation_modifier_range = _838.VM1_params.rotation_modifier_range;
    _843.rotation_modifier_range_modifier_factor = _838.VM1_params.rotation_modifier_range_modifier_factor;
    _843.scale_modifier_base = _838.VM1_params.scale_modifier_base;
    _843.scale_modifier_base_modifier_factor = _838.VM1_params.scale_modifier_base_modifier_factor;
    _843.scale_modifier_range = _838.VM1_params.scale_modifier_range;
    _843.scale_modifier_range_modifier_factor = _838.VM1_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_4 = _843;
    ModifierFactor param_5 = modifier_factor;
    Instance param_6 = instance;
    uint param_7 = id;
    instance_modifier_randomizer_v2(param_4, param_5, param_6, param_7);
    modifier_factor = param_5;
    instance = param_6;
    _727.instance_transform[(id * 3u) + 0u] = instance.m0;
    _727.instance_transform[(id * 3u) + 1u] = instance.m1;
    _727.instance_transform[(id * 3u) + 2u] = instance.m2;
    _750.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _750.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _776.instance_flipbook_card[id] = instance.flipbook_card;
}

 