#version 450

struct TonemapParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 color_lift;
    vec4 color_inv_gamma;
    vec4 color_gain;
    vec4 color_contrast;
    float color_saturation;
    float exposure;
    float tonemap_blend;
    uint tonemap_type;
};

layout(set = 1, binding = 1, std140) uniform TonemapParamsBuffer
{
    TonemapParams tonemap_params;
} _360;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;
float A;
float B;
float C;
float D;
float E;
float F;
float W;

vec3 basic(vec3 base_color)
{
    return pow(base_color, vec3(0.4545454680919647216796875));
}

vec3 Uncharted2Tonemap(vec3 x)
{
    return (((x * ((x * A) + vec3(C * B))) + vec3(D * E)) / ((x * ((x * A) + vec3(B))) + vec3(D * F))) - vec3(E / F);
}

vec3 uncharted(inout vec3 base_color)
{
    base_color = max(vec3(0.0), base_color);
    float ExposureBias = 2.2999999523162841796875;
    vec3 param = base_color * ExposureBias;
    vec3 curr = Uncharted2Tonemap(param);
    vec3 param_1 = vec3(W);
    vec3 whiteScale = vec3(1.0) / Uncharted2Tonemap(param_1);
    vec3 color = curr * whiteScale;
    return pow(color, vec3(0.4545454680919647216796875));
}

vec3 aces(vec3 color)
{
    mat3 m1 = mat3(vec3(0.59719002246856689453125, 0.075999997556209564208984375, 0.0284000001847743988037109375), vec3(0.354579985141754150390625, 0.908339977264404296875, 0.13382999598979949951171875), vec3(0.048229999840259552001953125, 0.0156599991023540496826171875, 0.837769985198974609375));
    mat3 m2 = mat3(vec3(1.60475003719329833984375, -0.10208000242710113525390625, -0.00326999998651444911956787109375), vec3(-0.5310800075531005859375, 1.108129978179931640625, -0.07276000082492828369140625), vec3(-0.0736699998378753662109375, -0.00604999996721744537353515625, 1.0760200023651123046875));
    vec3 v = m1 * color;
    vec3 a = (v * (v + vec3(0.02457859925925731658935546875))) - vec3(9.0537003416102379560470581054688e-05);
    vec3 b = (v * ((v * 0.98372900485992431640625) + vec3(0.4329510033130645751953125))) + vec3(0.23808099329471588134765625);
    return pow(clamp(m2 * (a / b), vec3(0.0), vec3(1.0)), vec3(0.4545454680919647216796875));
}

vec3 reinhard(vec3 base_color)
{
    vec3 x = base_color / (vec3(1.0) + base_color);
    return pow(x, vec3(0.4545454680919647216796875));
}

vec3 haarm_approx(vec3 base_color)
{
    vec3 x = max(vec3(0.0), base_color - vec3(0.0040000001899898052215576171875));
    return (x * ((x * 6.19999980926513671875) + vec3(0.5))) / ((x * ((x * 6.19999980926513671875) + vec3(1.7000000476837158203125))) + vec3(0.0599999986588954925537109375));
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec2 v)
{
    uint param = v.y;
    uint _119 = hash(param);
    uint param_1 = v.x ^ _119;
    uint _122 = hash(param_1);
    return _122;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec2 v)
{
    uvec2 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _144 = floatConstruct(param_1);
    return _144;
}

vec3 EvalLogContrastFunc(vec3 x, float eps, float logMidpoint, vec3 contrast)
{
    vec3 logX = log2(x + vec3(eps));
    vec3 adjX = vec3(logMidpoint) + ((logX - vec3(logMidpoint)) * contrast);
    vec3 ret = max(vec3(0.0), exp2(adjX) - vec3(eps));
    return ret;
}

float ApplyLiftInvGammaGain(float lift, float invGamma, float gain, float v)
{
    float lerpV = clamp(pow(v, invGamma), 0.0, 1.0);
    float dst = mix(lift, gain, lerpV);
    return dst;
}

vec3 EvalLiftGammaGain(vec3 v)
{
    float param = v.x;
    vec3 ret;
    ret.x = ApplyLiftInvGammaGain(_360.tonemap_params.color_lift.x, _360.tonemap_params.color_inv_gamma.x, _360.tonemap_params.color_gain.x, param);
    float param_1 = v.y;
    ret.y = ApplyLiftInvGammaGain(_360.tonemap_params.color_lift.y, _360.tonemap_params.color_inv_gamma.y, _360.tonemap_params.color_gain.y, param_1);
    float param_2 = v.z;
    ret.z = ApplyLiftInvGammaGain(_360.tonemap_params.color_lift.z, _360.tonemap_params.color_inv_gamma.z, _360.tonemap_params.color_gain.z, param_2);
    return ret;
}

void main()
{
    A = 0.1500000059604644775390625;
    B = 0.5;
    C = 0.100000001490116119384765625;
    D = 0.20000000298023223876953125;
    E = 0.0199999995529651641845703125;
    F = 0.300000011920928955078125;
    W = 11.19999980926513671875;
    vec4 base_color = texelFetch(s_texture0, ivec2(vTexcoord0 * _360.tonemap_params.resolution), 0);
    base_color *= _360.tonemap_params.exposure;
    vec3 tonemapped_color = base_color.xyz;
    if (_360.tonemap_params.tonemap_type == 0u)
    {
        vec3 param = base_color.xyz;
        tonemapped_color = basic(param);
    }
    if (_360.tonemap_params.tonemap_type == 2u)
    {
        vec3 param_1 = base_color.xyz;
        vec3 _450 = uncharted(param_1);
        tonemapped_color = _450;
    }
    if (_360.tonemap_params.tonemap_type == 1u)
    {
        vec3 param_2 = base_color.xyz;
        tonemapped_color = aces(param_2);
    }
    if (_360.tonemap_params.tonemap_type == 3u)
    {
        vec3 param_3 = base_color.xyz;
        tonemapped_color = reinhard(param_3);
    }
    if (_360.tonemap_params.tonemap_type == 4u)
    {
        vec3 param_4 = base_color.xyz;
        tonemapped_color = haarm_approx(param_4);
    }
    vec2 param_5 = vTexcoord0;
    float dither = random(param_5);
    vec4 _483 = base_color;
    vec3 _490 = mix(_483.xyz, tonemapped_color, vec3(_360.tonemap_params.tonemap_blend));
    base_color.x = _490.x;
    base_color.y = _490.y;
    base_color.z = _490.z;
    vec3 param_6 = base_color.xyz;
    float param_7 = 0.001000000047497451305389404296875;
    float param_8 = 0.180000007152557373046875;
    vec3 param_9 = (vec3(1.0) - _360.tonemap_params.color_contrast.xyz) * _360.tonemap_params.color_contrast.w;
    vec3 _515 = EvalLogContrastFunc(param_6, param_7, param_8, param_9);
    base_color.x = _515.x;
    base_color.y = _515.y;
    base_color.z = _515.z;
    vec3 param_10 = base_color.xyz;
    vec3 _525 = EvalLiftGammaGain(param_10);
    base_color.x = _525.x;
    base_color.y = _525.y;
    base_color.z = _525.z;
    vec4 _535 = base_color;
    vec3 _538 = _535.xyz + vec3(dither / 256.0);
    base_color.x = _538.x;
    base_color.y = _538.y;
    base_color.z = _538.z;
    vec3 gray = vec3(dot(base_color.xyz, vec3(0.21199999749660491943359375, 0.714999973773956298828125, 0.0719999969005584716796875)));
    vec4 _555 = base_color;
    vec3 _561 = mix(gray, _555.xyz, vec3(_360.tonemap_params.color_saturation));
    base_color.x = _561.x;
    base_color.y = _561.y;
    base_color.z = _561.z;
    outColor = base_color;
}

 