#version 450

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct CopyRTMaterialPropertyToStencilParams
{
    int scale_denominator;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform CopyRTMaterialPropertyToStencilParamsBuffer
{
    CopyRTMaterialPropertyToStencilParams params;
} _105;

layout(set = 1, binding = 2, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 3, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

void main()
{
    ivec2 base_pos = ivec2(gl_FragCoord.xy);
    int is_rt_counter = 0;
    int sample_count = 0;
    if (_105.params.scale_denominator == 1)
    {
        sample_count = 1;
        uvec4 param = imageLoad(imMetalnessRoughnessMaterialTags, base_pos);
        MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
        uint materialIndex = metalness_roughness_material_tags.material_index;
        MaterialPropertiesGPU _139;
        _139.diffuse = materials.material_properties[materialIndex].diffuse;
        _139.transparency = materials.material_properties[materialIndex].transparency;
        _139.emissive = materials.material_properties[materialIndex].emissive;
        _139.roughness = materials.material_properties[materialIndex].roughness;
        _139.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _139.refraction = materials.material_properties[materialIndex].refraction;
        _139.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _139.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _139.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _139.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _139.metalness = materials.material_properties[materialIndex].metalness;
        _139.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _139.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _139.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _139.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _139.flags = materials.material_properties[materialIndex].flags;
        _139._pad0 = materials.material_properties[materialIndex]._pad0;
        _139._pad1 = materials.material_properties[materialIndex]._pad1;
        MaterialPropertiesGPU material = _139;
        uint material_flags = material.flags;
        if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
        {
            material_flags &= 4294967280u;
            material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
        }
        bool is_reflective = (material_flags & 1u) != 0u;
        if (is_reflective)
        {
            is_rt_counter++;
        }
    }
    if (_105.params.scale_denominator == 2)
    {
        sample_count = 4;
        base_pos *= ivec2(2);
        float param_2;
        float param_3;
        uint param_4;
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                uvec2 param_1 = imageLoad(imMetalnessRoughnessMaterialTags, base_pos + ivec2(ix, iy)).xy;
                decode_metalness_roughness_material(param_1, param_2, param_3, param_4);
                float metalness = param_2;
                float roughness = param_3;
                uint materialIndex_1 = param_4;
                MaterialPropertiesGPU _216;
                _216.diffuse = materials.material_properties[materialIndex_1].diffuse;
                _216.transparency = materials.material_properties[materialIndex_1].transparency;
                _216.emissive = materials.material_properties[materialIndex_1].emissive;
                _216.roughness = materials.material_properties[materialIndex_1].roughness;
                _216.triplanar_factor = materials.material_properties[materialIndex_1].triplanar_factor;
                _216.refraction = materials.material_properties[materialIndex_1].refraction;
                _216.normal_factor = materials.material_properties[materialIndex_1].normal_factor;
                _216.emissive_factor = materials.material_properties[materialIndex_1].emissive_factor;
                _216.temporal_accumulation_factor = materials.material_properties[materialIndex_1].temporal_accumulation_factor;
                _216.shadowmap_bias = materials.material_properties[materialIndex_1].shadowmap_bias;
                _216.metalness = materials.material_properties[materialIndex_1].metalness;
                _216.albedo_sampler = materials.material_properties[materialIndex_1].albedo_sampler;
                _216.emissive_sampler = materials.material_properties[materialIndex_1].emissive_sampler;
                _216.normal_sampler = materials.material_properties[materialIndex_1].normal_sampler;
                _216.metalic_roughness_sampler = materials.material_properties[materialIndex_1].metalic_roughness_sampler;
                _216.flags = materials.material_properties[materialIndex_1].flags;
                _216._pad0 = materials.material_properties[materialIndex_1]._pad0;
                _216._pad1 = materials.material_properties[materialIndex_1]._pad1;
                MaterialPropertiesGPU material_1 = _216;
                if ((material_1.flags & 1u) != 0u)
                {
                    is_rt_counter++;
                }
            }
        }
    }
    if (is_rt_counter < sample_count)
    {
        discard;
    }
}

 