#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    float color_lod;
    float occupancy_lod;
    float occupancy_threshold;
    int bbox_from_voxelizer;
    uvec3 resolution;
    int _pad2;
    vec3 bbox_position;
    int _pad3;
    vec3 bbox_dimensions;
    int _pad4;
    vec3 instance_scale_base;
    int _pad7;
    vec3 instance_scale_factor;
    int _pad8;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _101;

layout(set = 0, binding = 7, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _119;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _425;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _447;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _469;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _477;

layout(set = 0, binding = 8) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 9) uniform sampler3D s_voxel_occupancy_filtered;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _26 = v;
    float _31 = v.w;
    vec3 _34 = (_26.xyz * _31) * 128.0;
    v.x = _34.x;
    v.y = _34.y;
    v.z = _34.z;
    return v.xyz * v.xyz;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_101.instance_params.instance_count >= _101.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_119.instancing_generator_params.resolution.x * _119.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_119.instancing_generator_params.resolution.x * _119.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _119.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _119.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 instancing_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    if (_119.instancing_generator_params.bbox_from_voxelizer == 0)
    {
        instancing_bbox_origin = _119.instancing_generator_params.bbox_position;
        instancing_bbox_size = _119.instancing_generator_params.bbox_dimensions;
    }
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_119.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (instance_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _206 = source_voxel_position.x < 0.0;
    bool _213;
    if (!_206)
    {
        _213 = source_voxel_position.y < 0.0;
    }
    else
    {
        _213 = _206;
    }
    bool _220;
    if (!_213)
    {
        _220 = source_voxel_position.z < 0.0;
    }
    else
    {
        _220 = _213;
    }
    bool _227;
    if (!_220)
    {
        _227 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _227 = _220;
    }
    bool _234;
    if (!_227)
    {
        _234 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _234 = _227;
    }
    bool _241;
    if (!_234)
    {
        _241 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _241 = _234;
    }
    if (_241)
    {
        return;
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, _119.instancing_generator_params.color_lod);
    vec3 _257 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _257;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, _119.instancing_generator_params.occupancy_lod).x;
    if (voxel_occupancy <= _119.instancing_generator_params.occupancy_threshold)
    {
        return;
    }
    voxel_occupancy -= _119.instancing_generator_params.occupancy_threshold;
    vec3 instance_scale = _119.instancing_generator_params.instance_scale_base + (_119.instancing_generator_params.instance_scale_factor * (0.25 + (0.75 * voxel_occupancy)));
    voxel_color += vec3(voxel_occupancy * 0.00999999977648258209228515625);
    mat3 transform;
    transform[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform[1] = vec3(0.0, instance_scale.y, 0.0);
    transform[2] = vec3(0.0, 0.0, instance_scale.z);
    transform = transpose(transform);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
    {
        return;
    }
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(voxel_color, 1.0);
    instance.flipbook_card = 0u;
    bool _388 = length(instance.m0.xyz) < 9.9999997473787516355514526367188e-05;
    bool _397;
    if (!_388)
    {
        _397 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _397 = _388;
    }
    bool _406;
    if (!_397)
    {
        _406 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _406 = _397;
    }
    if (_406)
    {
        return;
    }
    int _412 = atomicAdd(_101.instance_params.instance_count, 1);
    uint instance_id = uint(_412);
    if (instance_id >= uint(_101.instance_params.buffer_capacity))
    {
        return;
    }
    _425.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _425.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _425.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _447.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _447.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _469.instance_hash[instance_id] = instance.hash;
    _477.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 