#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 3, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _46;

layout(set = 0, binding = 1, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _58;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

void main()
{
    if (gl_LocalInvocationIndex == 0u)
    {
        vec3 bbox_raytrace_min = vec3(-1.0);
        vec3 bbox_raytrace_max = vec3(1.0);
        vec3 bbox_voxelize_min = vec3(-1.0);
        vec3 bbox_voxelize_max = vec3(1.0);
        bool is_raytrace_bbox_present = false;
        bool is_voxelize_bbox_present = false;
        for (uint i = 0u; i < _46.transform_geometry_params.instance_idx; i++)
        {
            if (_58.transformed_data_location[i].raytrace != 0u)
            {
                if (is_raytrace_bbox_present == false)
                {
                    bbox_raytrace_min = vec3(_58.transformed_data_location[i].bbox_min.xyz);
                    bbox_raytrace_max = vec3(_58.transformed_data_location[i].bbox_max.xyz);
                    is_raytrace_bbox_present = true;
                }
                else
                {
                    bbox_raytrace_min = min(bbox_raytrace_min, vec3(_58.transformed_data_location[i].bbox_min.xyz));
                    bbox_raytrace_max = max(bbox_raytrace_max, vec3(_58.transformed_data_location[i].bbox_max.xyz));
                }
            }
            if (_58.transformed_data_location[i].voxelize != 0u)
            {
                if (is_voxelize_bbox_present == false)
                {
                    bbox_voxelize_min = vec3(_58.transformed_data_location[i].bbox_min.xyz);
                    bbox_voxelize_max = vec3(_58.transformed_data_location[i].bbox_max.xyz);
                    is_voxelize_bbox_present = true;
                }
                else
                {
                    bbox_voxelize_min = min(bbox_voxelize_min, vec3(_58.transformed_data_location[i].bbox_min.xyz));
                    bbox_voxelize_max = max(bbox_voxelize_max, vec3(_58.transformed_data_location[i].bbox_max.xyz));
                }
            }
        }
        if (is_raytrace_bbox_present)
        {
            in_bbox_data.bbox_raytrace_min.x = bbox_raytrace_min.x;
            in_bbox_data.bbox_raytrace_min.y = bbox_raytrace_min.y;
            in_bbox_data.bbox_raytrace_min.z = bbox_raytrace_min.z;
            in_bbox_data.bbox_raytrace_max.x = bbox_raytrace_max.x;
            in_bbox_data.bbox_raytrace_max.y = bbox_raytrace_max.y;
            in_bbox_data.bbox_raytrace_max.z = bbox_raytrace_max.z;
        }
        if (_46.transform_geometry_params.calculate_bbox_raytrace == 0)
        {
            in_bbox_data.bbox_raytrace_min.x = _46.transform_geometry_params.default_bbox_raytrace_min.xyz.x;
            in_bbox_data.bbox_raytrace_min.y = _46.transform_geometry_params.default_bbox_raytrace_min.xyz.y;
            in_bbox_data.bbox_raytrace_min.z = _46.transform_geometry_params.default_bbox_raytrace_min.xyz.z;
            in_bbox_data.bbox_raytrace_max.x = _46.transform_geometry_params.default_bbox_raytrace_max.xyz.x;
            in_bbox_data.bbox_raytrace_max.y = _46.transform_geometry_params.default_bbox_raytrace_max.xyz.y;
            in_bbox_data.bbox_raytrace_max.z = _46.transform_geometry_params.default_bbox_raytrace_max.xyz.z;
        }
        if (is_voxelize_bbox_present)
        {
            in_bbox_data.bbox_voxelize_min.x = bbox_voxelize_min.x;
            in_bbox_data.bbox_voxelize_min.y = bbox_voxelize_min.y;
            in_bbox_data.bbox_voxelize_min.z = bbox_voxelize_min.z;
            in_bbox_data.bbox_voxelize_max.x = bbox_voxelize_max.x;
            in_bbox_data.bbox_voxelize_max.y = bbox_voxelize_max.y;
            in_bbox_data.bbox_voxelize_max.z = bbox_voxelize_max.z;
        }
        if (_46.transform_geometry_params.calculate_bbox_voxelize == 0)
        {
            in_bbox_data.bbox_voxelize_min.x = _46.transform_geometry_params.default_bbox_voxelize_min.xyz.x;
            in_bbox_data.bbox_voxelize_min.y = _46.transform_geometry_params.default_bbox_voxelize_min.xyz.y;
            in_bbox_data.bbox_voxelize_min.z = _46.transform_geometry_params.default_bbox_voxelize_min.xyz.z;
            in_bbox_data.bbox_voxelize_max.x = _46.transform_geometry_params.default_bbox_voxelize_max.xyz.x;
            in_bbox_data.bbox_voxelize_max.y = _46.transform_geometry_params.default_bbox_voxelize_max.xyz.y;
            in_bbox_data.bbox_voxelize_max.z = _46.transform_geometry_params.default_bbox_voxelize_max.xyz.z;
        }
        vec3 mi = in_bbox_data.bbox_raytrace_min.xyz;
        vec3 ma = in_bbox_data.bbox_raytrace_max.xyz;
        vec3 mc = (ma + mi) / vec3(2.0);
        vec3 md = ma - mi;
        float max_md = max(md.x, max(md.y, md.z));
        md.x = max(md.x, max_md * 0.25);
        md.y = max(md.y, max_md * 0.25);
        md.z = max(md.z, max_md * 0.25);
        vec3 _287 = mc - (md * 0.50499999523162841796875);
        in_bbox_data.bbox_raytrace_min.x = _287.x;
        in_bbox_data.bbox_raytrace_min.y = _287.y;
        in_bbox_data.bbox_raytrace_min.z = _287.z;
        vec3 _297 = mc + (md * 0.50499999523162841796875);
        in_bbox_data.bbox_raytrace_max.x = _297.x;
        in_bbox_data.bbox_raytrace_max.y = _297.y;
        in_bbox_data.bbox_raytrace_max.z = _297.z;
        mi = in_bbox_data.bbox_raytrace_min.xyz;
        ma = in_bbox_data.bbox_raytrace_max.xyz;
        vec3 cell_size = (ma - mi) / vec3(256.0);
        ivec3 grid_shift = -ivec3(floor(mi / cell_size));
        vec3 _327 = vec3(grid_shift);
        in_bbox_data.grid_shift_raytrace.x = _327.x;
        in_bbox_data.grid_shift_raytrace.y = _327.y;
        in_bbox_data.grid_shift_raytrace.z = _327.z;
        in_bbox_data.grid_size_raytrace.x = cell_size.x;
        in_bbox_data.grid_size_raytrace.y = cell_size.y;
        in_bbox_data.grid_size_raytrace.z = cell_size.z;
        vec3 mi_1 = in_bbox_data.bbox_voxelize_min.xyz;
        vec3 ma_1 = in_bbox_data.bbox_voxelize_max.xyz;
        vec3 mc_1 = (ma_1 + mi_1) / vec3(2.0);
        vec3 md_1 = ma_1 - mi_1;
        vec3 _363 = mc_1 - (md_1 * 0.5);
        in_bbox_data.bbox_voxelize_min.x = _363.x;
        in_bbox_data.bbox_voxelize_min.y = _363.y;
        in_bbox_data.bbox_voxelize_min.z = _363.z;
        vec3 _373 = mc_1 + (md_1 * 0.5);
        in_bbox_data.bbox_voxelize_max.x = _373.x;
        in_bbox_data.bbox_voxelize_max.y = _373.y;
        in_bbox_data.bbox_voxelize_max.z = _373.z;
        vec4 _381 = in_bbox_data.bbox_voxelize_min;
        vec3 _383 = floor(_381.xyz);
        in_bbox_data.bbox_voxelize_min.x = _383.x;
        in_bbox_data.bbox_voxelize_min.y = _383.y;
        in_bbox_data.bbox_voxelize_min.z = _383.z;
        vec4 _391 = in_bbox_data.bbox_voxelize_max;
        vec3 _393 = ceil(_391.xyz);
        in_bbox_data.bbox_voxelize_max.x = _393.x;
        in_bbox_data.bbox_voxelize_max.y = _393.y;
        in_bbox_data.bbox_voxelize_max.z = _393.z;
        mi_1 = in_bbox_data.bbox_voxelize_min.xyz;
        ma_1 = in_bbox_data.bbox_voxelize_max.xyz;
        vec3 cell_size_1 = (ma_1 - mi_1) / vec3(256.0);
        float max_cell_size_edge = max(cell_size_1.x, max(cell_size_1.y, cell_size_1.z));
        cell_size_1 = vec3(max_cell_size_edge);
        ivec3 grid_shift_1 = -ivec3(floor(mi_1 / cell_size_1));
        vec3 _430 = vec3(grid_shift_1);
        in_bbox_data.grid_shift_voxelize.x = _430.x;
        in_bbox_data.grid_shift_voxelize.y = _430.y;
        in_bbox_data.grid_shift_voxelize.z = _430.z;
        in_bbox_data.grid_size_voxelize.x = cell_size_1.x;
        in_bbox_data.grid_size_voxelize.y = cell_size_1.y;
        in_bbox_data.grid_size_voxelize.z = cell_size_1.z;
        vec4 _445 = in_bbox_data.bbox_raytrace_min;
        vec4 _448 = in_bbox_data.bbox_voxelize_min;
        vec3 _450 = min(_445.xyz, _448.xyz);
        in_bbox_data.bbox_combined_min.x = _450.x;
        in_bbox_data.bbox_combined_min.y = _450.y;
        in_bbox_data.bbox_combined_min.z = _450.z;
        vec4 _459 = in_bbox_data.bbox_raytrace_max;
        vec4 _462 = in_bbox_data.bbox_voxelize_max;
        vec3 _464 = max(_459.xyz, _462.xyz);
        in_bbox_data.bbox_combined_max.x = _464.x;
        in_bbox_data.bbox_combined_max.y = _464.y;
        in_bbox_data.bbox_combined_max.z = _464.z;
        mi_1 = in_bbox_data.bbox_combined_min.xyz;
        ma_1 = in_bbox_data.bbox_combined_max.xyz;
        cell_size_1 = (ma_1 - mi_1) / vec3(256.0);
        grid_shift_1 = -ivec3(floor(mi_1 / cell_size_1));
        vec3 _488 = vec3(grid_shift_1);
        in_bbox_data.grid_shift_combined.x = _488.x;
        in_bbox_data.grid_shift_combined.y = _488.y;
        in_bbox_data.grid_shift_combined.z = _488.z;
        in_bbox_data.grid_size_combined.x = cell_size_1.x;
        in_bbox_data.grid_size_combined.y = cell_size_1.y;
        in_bbox_data.grid_size_combined.z = cell_size_1.z;
    }
}

 