#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct VertexModifierGerstnerWavesParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec4 wave_directions[32];
    vec4 noise_phase;
    vec3 domain_scale;
    int _pad0;
    vec3 strength;
    int _pad1;
    vec3 position;
    int noise_relative_to_modifier;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    float wave_length;
    float wave_steepness;
    int wave_octaves;
    float wave_octave_scale;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct _1033
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 9, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _291;

layout(set = 0, binding = 10, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _692;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _703;

layout(set = 0, binding = 11, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _715;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _801;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _993;

layout(set = 0, binding = 12, std140) uniform VM0
{
    layout(row_major) VertexModifierGerstnerWavesParams VM0_params;
} _1020;

layout(set = 0, binding = 8, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1124;

layout(location = 1) out _1033 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec2 gerstner_evaluate_single(vec2 p, float t, float steepness, float wave_length, vec2 wave_direction)
{
    float k = 6.283185482025146484375 / wave_length;
    float c = sqrt(9.80000019073486328125 / k);
    float f = k * (dot(wave_direction, p) - (c * t));
    float a = steepness / k;
    return vec2(a * cos(f), a * sin(f));
}

void vertex_modifier_gerstner_waves_apply(VertexModifierGerstnerWavesParams params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx.pos;
    vec3 param = vtx.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _291.transform_params.mModel;
    vec3 influence_pos = vector_transform_by_mat43(param, param_1);
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param_2 = noise_pos;
        mat4 param_3 = params.transform_local;
        noise_pos = vector_transform_by_mat43(param_2, param_3);
    }
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = modifier_factor.factor;
    if (influence > 0.0)
    {
        vec2 wave = vec2(0.0);
        float wave_length = params.wave_length;
        vec2 wave_direction;
        for (int wi = 0; wi < params.wave_octaves; wi++)
        {
            if ((wi & 1) != 0)
            {
                wave_direction = params.wave_directions[wi >> 1].xy;
            }
            else
            {
                wave_direction = params.wave_directions[wi >> 1].zw;
            }
            float steepness_modulated_by_strength = params.wave_steepness / params.strength.x;
            vec2 param_4 = (noise_pos.xz * params.domain_scale.xy) + (params.domain_scale.xy * float(wi));
            float param_5 = params.noise_phase.x;
            float param_6 = steepness_modulated_by_strength;
            float param_7 = wave_length;
            vec2 param_8 = wave_direction;
            wave += gerstner_evaluate_single(param_4, param_5, param_6, param_7, param_8);
            wave_length *= params.wave_octave_scale;
        }
        wave += vec2(params.noise_value_base);
        vec3 local_norm = vtx.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_9 = modifier_position;
            mat4 param_10 = params.transform_local;
            local_norm = normalize(base_pos - vector_transform_by_mat43(param_9, param_10));
        }
        vec3 new_pos = base_pos;
        new_pos.x += (wave.x * params.strength.x);
        new_pos.y += (wave.y * params.strength.y);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        vtx.pos = new_pos;
    }
    if (false)
    {
        vtx.color.x = 0.0;
        vtx.color.y = 0.0;
        vtx.color.z = 0.0;
        vtx.color.x = max(0.0, influence);
    }
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    m[2].x = 0.0;
    m[2].y = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_692.instance_params.stride > 0)
    {
        uint flipbook_card = _703.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_715.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_715.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_715.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_715.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_715.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_692.instance_params.stride > 0)
    {
        vec4 inst_m0 = _801.instance_transform[(gl_InstanceIndex * _692.instance_params.stride) + 0];
        vec4 inst_m1 = _801.instance_transform[(gl_InstanceIndex * _692.instance_params.stride) + 1];
        vec4 inst_m2 = _801.instance_transform[(gl_InstanceIndex * _692.instance_params.stride) + 2];
        vec3 _832 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _832.x;
        mat_instance_model[0].y = _832.y;
        mat_instance_model[0].z = _832.z;
        vec3 _845 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _845.x;
        mat_instance_model[1].y = _845.y;
        mat_instance_model[1].z = _845.z;
        vec3 _858 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _858.x;
        mat_instance_model[2].y = _858.y;
        mat_instance_model[2].z = _858.z;
        vec3 _871 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _871.x;
        mat_instance_model[3].y = _871.y;
        mat_instance_model[3].z = _871.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_692.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _993.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _291.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _291.transform_params.mModelInv;
    VertexModifierGerstnerWavesParams _1025;
    _1025.transform_world_to_local = _1020.VM0_params.transform_world_to_local;
    _1025.transform_local_to_world = _1020.VM0_params.transform_local_to_world;
    _1025.transform_local = _1020.VM0_params.transform_local;
    _1025.transform_local_inv = _1020.VM0_params.transform_local_inv;
    _1025.transform_parent = _1020.VM0_params.transform_parent;
    _1025.transform_parent_inv = _1020.VM0_params.transform_parent_inv;
    _1025.wave_directions[0] = _1020.VM0_params.wave_directions[0];
    _1025.wave_directions[1] = _1020.VM0_params.wave_directions[1];
    _1025.wave_directions[2] = _1020.VM0_params.wave_directions[2];
    _1025.wave_directions[3] = _1020.VM0_params.wave_directions[3];
    _1025.wave_directions[4] = _1020.VM0_params.wave_directions[4];
    _1025.wave_directions[5] = _1020.VM0_params.wave_directions[5];
    _1025.wave_directions[6] = _1020.VM0_params.wave_directions[6];
    _1025.wave_directions[7] = _1020.VM0_params.wave_directions[7];
    _1025.wave_directions[8] = _1020.VM0_params.wave_directions[8];
    _1025.wave_directions[9] = _1020.VM0_params.wave_directions[9];
    _1025.wave_directions[10] = _1020.VM0_params.wave_directions[10];
    _1025.wave_directions[11] = _1020.VM0_params.wave_directions[11];
    _1025.wave_directions[12] = _1020.VM0_params.wave_directions[12];
    _1025.wave_directions[13] = _1020.VM0_params.wave_directions[13];
    _1025.wave_directions[14] = _1020.VM0_params.wave_directions[14];
    _1025.wave_directions[15] = _1020.VM0_params.wave_directions[15];
    _1025.wave_directions[16] = _1020.VM0_params.wave_directions[16];
    _1025.wave_directions[17] = _1020.VM0_params.wave_directions[17];
    _1025.wave_directions[18] = _1020.VM0_params.wave_directions[18];
    _1025.wave_directions[19] = _1020.VM0_params.wave_directions[19];
    _1025.wave_directions[20] = _1020.VM0_params.wave_directions[20];
    _1025.wave_directions[21] = _1020.VM0_params.wave_directions[21];
    _1025.wave_directions[22] = _1020.VM0_params.wave_directions[22];
    _1025.wave_directions[23] = _1020.VM0_params.wave_directions[23];
    _1025.wave_directions[24] = _1020.VM0_params.wave_directions[24];
    _1025.wave_directions[25] = _1020.VM0_params.wave_directions[25];
    _1025.wave_directions[26] = _1020.VM0_params.wave_directions[26];
    _1025.wave_directions[27] = _1020.VM0_params.wave_directions[27];
    _1025.wave_directions[28] = _1020.VM0_params.wave_directions[28];
    _1025.wave_directions[29] = _1020.VM0_params.wave_directions[29];
    _1025.wave_directions[30] = _1020.VM0_params.wave_directions[30];
    _1025.wave_directions[31] = _1020.VM0_params.wave_directions[31];
    _1025.noise_phase = _1020.VM0_params.noise_phase;
    _1025.domain_scale = _1020.VM0_params.domain_scale;
    _1025._pad0 = _1020.VM0_params._pad0;
    _1025.strength = _1020.VM0_params.strength;
    _1025._pad1 = _1020.VM0_params._pad1;
    _1025.position = _1020.VM0_params.position;
    _1025.noise_relative_to_modifier = _1020.VM0_params.noise_relative_to_modifier;
    _1025.displacement_mode = _1020.VM0_params.displacement_mode;
    _1025.noise_value_base = _1020.VM0_params.noise_value_base;
    _1025.noise_value_absolute = _1020.VM0_params.noise_value_absolute;
    _1025.wave_length = _1020.VM0_params.wave_length;
    _1025.wave_steepness = _1020.VM0_params.wave_steepness;
    _1025.wave_octaves = _1020.VM0_params.wave_octaves;
    _1025.wave_octave_scale = _1020.VM0_params.wave_octave_scale;
    VertexModifierGerstnerWavesParams param_5 = _1025;
    ModifierFactor param_6 = modifier_factor;
    VertexInput param_7 = vtx_input;
    vertex_modifier_gerstner_waves_apply(param_5, param_6, param_7);
    modifier_factor = param_6;
    vtx_input = param_7;
    vtx_output.vLocalPos = vtx_input.pos;
    if (_692.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _801.instance_transform[(gl_InstanceIndex * _692.instance_params.stride) + 0];
        vec4 inst_m1_1 = _801.instance_transform[(gl_InstanceIndex * _692.instance_params.stride) + 1];
        vec4 inst_m2_1 = _801.instance_transform[(gl_InstanceIndex * _692.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_8 = vtx_input.norm;
        mat4 param_9 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_8, param_9));
        vec2 _1130 = unpackHalf2x16(_1124.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1130.x;
        inst_c.y = _1130.y;
        vec2 _1140 = unpackHalf2x16(_1124.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1140.x;
        inst_c.w = _1140.y;
        vec4 _1146 = vtx_input.color;
        vec3 _1150 = _1146.xyz * inst_c.xyz;
        vtx_input.color.x = _1150.x;
        vtx_input.color.y = _1150.y;
        vtx_input.color.z = _1150.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vec3 param_10 = vtx_input.pos;
    mat4 param_11 = _291.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_10, param_11);
    vec3 param_12 = vtx_input.norm;
    mat4 param_13 = _291.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_12, param_13);
    vec3 param_14 = vPosModel;
    mat4 param_15 = _291.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_14, param_15);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _291.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_291.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_291.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_291.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    vec3 param_16 = vtx_output.vCoords;
    mat4 param_17 = _291.transform_params.mProjection;
    vec4 _1252 = vector_transform_by_mat_projection(param_16, param_17);
    gl_Position = _1252;
}

 