#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
    float time_step;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM1Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _436;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _460;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _483;

layout(set = 0, binding = 9, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1276;

layout(set = 0, binding = 10, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1483;

layout(set = 0, binding = 4, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _1527;

layout(set = 0, binding = 11, std140) uniform VM1
{
    VM1Params VM1_params;
} _1557;

layout(set = 0, binding = 5, std430) buffer VM2
{
    ParticleModifierSwirl_Params VM2_params;
} _1582;

layout(set = 0, binding = 6, std430) buffer VM3
{
    ParticleModifierCurl_Params VM3_params;
} _1607;

layout(set = 0, binding = 12, std140) uniform VM4
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM4_params;
} _1629;

layout(set = 0, binding = 7, std430) buffer VM5
{
    ParticleModifierAttractor_Params VM5_params;
} _1650;

layout(set = 0, binding = 8, std430) buffer VM6
{
    ParticleModifierCurl_Params VM6_params;
} _1676;

layout(set = 0, binding = 13) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_483.prt_prev_positions[(id * 3u) + 0u], _483.prt_prev_positions[(id * 3u) + 1u], _483.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _442;
    _442.life_time = _436.prt_states[id].life_time;
    _442.life_span = _436.prt_states[id].life_span;
    _442.generation_id = _436.prt_states[id].generation_id;
    _442.color = _436.prt_states[id].color;
    ParticleState _441 = _442;
    return _441;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _505 = color_convert_rgb_float3_uint(param);
    uint v = _505;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    pos = vector_transform_by_mat43(param_6, param_7);
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _416 = hash(param);
    uint param_1 = _416;
    float _418 = floatConstruct(param_1);
    return _418;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (lifecycle_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(lifecycle_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1276.globals.time, _1276.globals.time * 0.3014999926090240478515625, (-_1276.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1298 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1298 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _449;
    _449.life_time = state.life_time;
    _449.life_span = state.life_span;
    _449.generation_id = state.generation_id;
    _449.color = state.color;
    _436.prt_states[id] = _449;
}

void prt_set_position(uint id, vec3 p)
{
    _460.prt_positions[(id * 3u) + 0u] = p.x;
    _460.prt_positions[(id * 3u) + 1u] = p.y;
    _460.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_1483.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _1532 = atomicAdd(_1527.VM0_params.pending, -1);
        int pending = _1532;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _1541;
            _1541.transform = _1527.VM0_params.transform;
            _1541.particle_color = _1527.VM0_params.particle_color;
            _1541.primitive_size = _1527.VM0_params.primitive_size;
            _1541.perimeter_only = _1527.VM0_params.perimeter_only;
            _1541.primitive_type = _1527.VM0_params.primitive_type;
            _1541.particle_lifetime = _1527.VM0_params.particle_lifetime;
            _1541.particle_lifetime_randomness = _1527.VM0_params.particle_lifetime_randomness;
            _1541.rate = _1527.VM0_params.rate;
            _1541.seed = _1527.VM0_params.seed;
            _1541.pending = _1527.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_4 = _1541;
            ParticleLifecycleParams _1546;
            _1546.time_step = _1483.lifecycle_params.time_step;
            _1546.max_lifetime = _1483.lifecycle_params.max_lifetime;
            _1546.reset = _1483.lifecycle_params.reset;
            _1546._pad1 = _1483.lifecycle_params._pad1;
            ParticleLifecycleParams param_5 = _1546;
            Particle param_6 = p;
            uint param_7 = id;
            particle_emitter_primitive_emit(param_4, param_5, param_6, param_7);
            p = param_6;
        }
    }
    vec3 modifier_position = _1557.VM1_params.position;
    p.pos += ((_1557.VM1_params.velocity * _1483.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_8 = p.state;
    if (prt_is_alive(param_8))
    {
        ParticleModifierSwirl_Params _1587;
        _1587.position = _1582.VM2_params.position;
        _1587.falloff_curve_idx = _1582.VM2_params.falloff_curve_idx;
        _1587.radius = _1582.VM2_params.radius;
        _1587.falloff_inverse = _1582.VM2_params.falloff_inverse;
        _1587.velocity = _1582.VM2_params.velocity;
        _1587.velocity_randomness = _1582.VM2_params.velocity_randomness;
        _1587.time_step = _1582.VM2_params.time_step;
        _1587.axis_randomness = _1582.VM2_params.axis_randomness;
        _1587.axis = _1582.VM2_params.axis;
        _1587._pad0 = _1582.VM2_params._pad0;
        _1587.scale = _1582.VM2_params.scale;
        _1587._pad1 = _1582.VM2_params._pad1;
        ParticleModifierSwirl_Params param_9 = _1587;
        ParticleLifecycleParams _1591;
        _1591.time_step = _1483.lifecycle_params.time_step;
        _1591.max_lifetime = _1483.lifecycle_params.max_lifetime;
        _1591.reset = _1483.lifecycle_params.reset;
        _1591._pad1 = _1483.lifecycle_params._pad1;
        ParticleLifecycleParams param_10 = _1591;
        Particle param_11 = p;
        uint param_12 = id;
        particle_modifier_swirl(param_9, param_10, param_11, param_12);
        p = param_11;
    }
    ParticleState param_13 = p.state;
    if (prt_is_alive(param_13))
    {
        ParticleModifierCurl_Params _1612;
        _1612.position = _1607.VM3_params.position;
        _1612.falloff_mode = _1607.VM3_params.falloff_mode;
        _1612.radius = _1607.VM3_params.radius;
        _1612.falloff_inverse = _1607.VM3_params.falloff_inverse;
        _1612.noise_strength = _1607.VM3_params.noise_strength;
        _1612.noise_speed = _1607.VM3_params.noise_speed;
        _1612.noise_scale = _1607.VM3_params.noise_scale;
        _1612.time_step = _1607.VM3_params.time_step;
        ParticleModifierCurl_Params param_14 = _1612;
        ParticleLifecycleParams _1616;
        _1616.time_step = _1483.lifecycle_params.time_step;
        _1616.max_lifetime = _1483.lifecycle_params.max_lifetime;
        _1616.reset = _1483.lifecycle_params.reset;
        _1616._pad1 = _1483.lifecycle_params._pad1;
        ParticleLifecycleParams param_15 = _1616;
        ModifierFactor param_16 = modifier_factor;
        Particle param_17 = p;
        uint param_18 = id;
        particle_modifier_curl(param_14, param_15, param_16, param_17, param_18);
        modifier_factor = param_16;
        p = param_17;
    }
    ModifierFactorDistanceRadial_Params _1634;
    _1634.transform_local_to_gizmo = _1629.VM4_params.transform_local_to_gizmo;
    _1634.falloff_curve_idx = _1629.VM4_params.falloff_curve_idx;
    _1634.falloff_inverse = _1629.VM4_params.falloff_inverse;
    _1634.domain_repeat_x = _1629.VM4_params.domain_repeat_x;
    _1634.domain_repeat_y = _1629.VM4_params.domain_repeat_y;
    _1634.domain_repeat_z = _1629.VM4_params.domain_repeat_z;
    _1634.influence_scope = _1629.VM4_params.influence_scope;
    _1634.modifier_function = _1629.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_19 = _1634;
    ModifierFactor param_20 = modifier_factor;
    CoordinateSystemTrasforms param_21 = cs_transforms;
    modifier_factor_distance_radial(param_19, param_20, param_21);
    modifier_factor = param_20;
    ParticleState param_22 = p.state;
    if (prt_is_alive(param_22))
    {
        ParticleModifierAttractor_Params _1655;
        _1655.position = _1650.VM5_params.position;
        _1655.radius = _1650.VM5_params.radius;
        _1655.velocity = _1650.VM5_params.velocity;
        ParticleModifierAttractor_Params param_23 = _1655;
        ModifierFactor param_24 = modifier_factor;
        ParticleLifecycleParams _1661;
        _1661.time_step = _1483.lifecycle_params.time_step;
        _1661.max_lifetime = _1483.lifecycle_params.max_lifetime;
        _1661.reset = _1483.lifecycle_params.reset;
        _1661._pad1 = _1483.lifecycle_params._pad1;
        ParticleLifecycleParams param_25 = _1661;
        Particle param_26 = p;
        uint param_27 = id;
        particle_modifier_attractor(param_23, param_24, param_25, param_26, param_27);
        p = param_26;
    }
    ParticleState param_28 = p.state;
    if (prt_is_alive(param_28))
    {
        ParticleModifierCurl_Params _1680;
        _1680.position = _1676.VM6_params.position;
        _1680.falloff_mode = _1676.VM6_params.falloff_mode;
        _1680.radius = _1676.VM6_params.radius;
        _1680.falloff_inverse = _1676.VM6_params.falloff_inverse;
        _1680.noise_strength = _1676.VM6_params.noise_strength;
        _1680.noise_speed = _1676.VM6_params.noise_speed;
        _1680.noise_scale = _1676.VM6_params.noise_scale;
        _1680.time_step = _1676.VM6_params.time_step;
        ParticleModifierCurl_Params param_29 = _1680;
        ParticleLifecycleParams _1684;
        _1684.time_step = _1483.lifecycle_params.time_step;
        _1684.max_lifetime = _1483.lifecycle_params.max_lifetime;
        _1684.reset = _1483.lifecycle_params.reset;
        _1684._pad1 = _1483.lifecycle_params._pad1;
        ParticleLifecycleParams param_30 = _1684;
        ModifierFactor param_31 = modifier_factor;
        Particle param_32 = p;
        uint param_33 = id;
        particle_modifier_curl(param_29, param_30, param_31, param_32, param_33);
        modifier_factor = param_31;
        p = param_32;
    }
    ParticleState param_34 = p.state;
    float param_35 = _1483.lifecycle_params.time_step;
    float param_36 = _1483.lifecycle_params.max_lifetime;
    prt_advance_life(param_34, param_35, param_36);
    p.state = param_34;
    uint param_37 = id;
    ParticleState param_38 = p.state;
    prt_set_state(param_37, param_38);
    uint param_39 = id;
    vec3 param_40 = p.pos;
    prt_set_position(param_39, param_40);
}

 