#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
    float time_step;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct ParticleModifierGeometryAttractorParams
{
    float strength;
    float strength_modifier_factor;
    float min_distance;
    float min_distance_modifier_factor;
    float search_distance;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int iteration;
    int _pad0;
    int _pad1;
    int _pad2;
    uint nearest_face_buffer_size;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ParticleModifierKill_Params
{
    float modifier_factor_base;
    float modifier_factor_range;
    float min_lifetime;
    float max_lifetime;
};

struct ParticleModifierColorize_Params
{
    int mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
    vec4 color;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _475;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _499;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _522;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _932;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _986;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1045;

layout(set = 0, binding = 12, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1485;

layout(set = 0, binding = 13, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2288;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _2332;

layout(set = 0, binding = 8, std430) buffer VM1
{
    ParticleModifierCurl_Params VM1_params;
} _2367;

layout(set = 0, binding = 9, std430) buffer VM2
{
    ParticleModifierGeometryAttractorParams VM2_params;
    uint VM2_closest_face_idx[];
} _2398;

layout(set = 0, binding = 14, std140) uniform VM3
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM3_params;
} _2436;

layout(set = 0, binding = 10, std430) buffer VM4
{
    ParticleModifierAttractor_Params VM4_params;
} _2457;

layout(set = 0, binding = 15, std140) uniform VM5
{
    layout(row_major) ModifierFactorNoise_Params VM5_params;
} _2478;

layout(set = 0, binding = 16, std140) uniform VM6
{
    ParticleModifierKill_Params VM6_params;
} _2499;

layout(set = 0, binding = 11, std430) buffer VM7
{
    ParticleModifierColorize_Params VM7_params;
} _2522;

layout(set = 0, binding = 17) uniform sampler2D s_Curves;
layout(set = 0, binding = 18) uniform sampler2D s_Gradients;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_522.prt_prev_positions[(id * 3u) + 0u], _522.prt_prev_positions[(id * 3u) + 1u], _522.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _481;
    _481.life_time = _475.prt_states[id].life_time;
    _481.life_span = _475.prt_states[id].life_span;
    _481.generation_id = _475.prt_states[id].generation_id;
    _481.color = _475.prt_states[id].color;
    ParticleState _480 = _481;
    return _480;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1045.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1045.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _455 = hash(param);
    uint param_1 = _455;
    float _457 = floatConstruct(param_1);
    return _457;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _986.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _986.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _986.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_932.in_vtx_data[coord_offset + 0u], _932.in_vtx_data[coord_offset + 1u], _932.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_932.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _559 = color_convert_rgb_float3_uint(param);
    uint v = _559;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

void particle_emitter_geometry_emit(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    for (int iteration = 0; iteration < 5; iteration++)
    {
        float fid = float((id + uint(iteration * 45827)) & 16777215u);
        float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed * 5.131999969482421875;
        float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
        float param_3 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
        face_idx += first_face_idx;
        uint param_4 = face_idx;
        RTFace rt_face = rt_get_face(param_4);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_5 = p0_idx;
        vec3 p0 = rt_get_vertex(param_5);
        uint param_6 = p1_idx;
        vec3 p1 = rt_get_vertex(param_6);
        uint param_7 = p2_idx;
        vec3 p2 = rt_get_vertex(param_7);
        uint param_8 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_8);
        uint param_9 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_9);
        uint param_10 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_10);
        float param_11 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_11);
        float param_12 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_12);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        float alpha = ((c0.w * bc.x) + (c1.w * bc.y)) + (c2.w * ((1.0 - bc.x) - bc.y));
        float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
        if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
        {
            if (emitter_params.surface_distance > 0.0)
            {
                vec3 n = normalize(cross(p0 - p1, p0 - p2));
                pos += (n * emitter_params.surface_distance);
            }
            if (pos.x == 1234567.0)
            {
                pos += vec3(fid_seed);
            }
            p.pos = pos;
            ParticleState param_13 = p.state;
            vec3 param_14 = emitter_params.particle_color.xyz;
            prt_set_color(param_13, param_14);
            p.state = param_13;
            ParticleState param_15 = p.state;
            float param_16 = lifetime;
            prt_spawn(param_15, param_16);
            p.state = param_15;
            if (emitter_params.alpha_to_modifier_factor != 0)
            {
                modifier_factor.factor = alpha;
            }
            emitted = true;
            break;
        }
    }
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1485.globals.time, _1485.globals.time * 0.3014999926090240478515625, (-_1485.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1508 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1508 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

uint particle_modifier_geometry_attractor_get_first_face_idx(ParticleModifierGeometryAttractorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1045.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_modifier_geometry_attractor_get_last_face_idx(ParticleModifierGeometryAttractorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1045.transformed_data_location[tdl_idx].last_face_idx;
}

void particle_modifier_geometry_attractor(ParticleModifierGeometryAttractorParams modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id, inout uint closest_face_idx)
{
    ParticleModifierGeometryAttractorParams param = modifier_params;
    uint first_face_idx = particle_modifier_geometry_attractor_get_first_face_idx(param);
    ParticleModifierGeometryAttractorParams param_1 = modifier_params;
    uint last_face_idx = particle_modifier_geometry_attractor_get_last_face_idx(param_1);
    if (first_face_idx >= last_face_idx)
    {
        return;
    }
    float fid = float((id * 45827u) & 16777215u);
    float param_2 = fid * 0.34130001068115234375;
    vec2 bc;
    bc.x = random(param_2);
    float param_3 = fid * 0.1412999927997589111328125;
    bc.y = random(param_3);
    if ((bc.x + bc.y) >= 1.0)
    {
        bc.x = 1.0 - bc.x;
        bc.y = 1.0 - bc.y;
    }
    float closest_face_distance = 100000000.0;
    vec3 o = p.pos;
    vec3 dir;
    for (int iteration = 0; iteration < 2; iteration++)
    {
        if ((closest_face_idx != 0u) && (iteration == 0))
        {
            uint param_4 = (first_face_idx + closest_face_idx) - 1u;
            RTFace rt_face = rt_get_face(param_4);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_5 = p0_idx;
            vec3 p0 = rt_get_vertex(param_5);
            uint param_6 = p1_idx;
            vec3 p1 = rt_get_vertex(param_6);
            uint param_7 = p2_idx;
            vec3 p2 = rt_get_vertex(param_7);
            vec3 closest_pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            closest_face_distance = length(closest_pos - o);
            dir = (closest_pos - o) / vec3(closest_face_distance + 9.9999997473787516355514526367188e-05);
        }
        else
        {
            float param_8 = fid + float(modifier_params.iteration & 65535);
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_8));
            uint param_9 = first_face_idx + face_idx;
            RTFace rt_face_1 = rt_get_face(param_9);
            uint p0_idx_1 = rt_face_1.v0;
            uint p1_idx_1 = rt_face_1.v1;
            uint p2_idx_1 = rt_face_1.v2;
            uint param_10 = p0_idx_1;
            vec3 p0_1 = rt_get_vertex(param_10);
            uint param_11 = p1_idx_1;
            vec3 p1_1 = rt_get_vertex(param_11);
            uint param_12 = p2_idx_1;
            vec3 p2_1 = rt_get_vertex(param_12);
            if (length(cross(p0_1 - p1_1, p0_1 - p2_1)) < 1.10000002384185791015625)
            {
                continue;
            }
            vec3 closest_pos_1 = ((p0_1 * bc.x) + (p1_1 * bc.y)) + (p2_1 * ((1.0 - bc.x) - bc.y));
            dir = normalize(closest_pos_1 - o);
            float d = length(closest_pos_1 - p.pos);
            if (d < modifier_params.search_distance)
            {
                float min_distance = mix(modifier_params.min_distance, modifier_params.min_distance * modifier_factor.factor, modifier_params.min_distance_modifier_factor);
                bool _1792 = (d < closest_face_distance) && (d > min_distance);
                bool _1803;
                if (!_1792)
                {
                    _1803 = (d > closest_face_distance) && (d < min_distance);
                }
                else
                {
                    _1803 = _1792;
                }
                if (_1803)
                {
                    closest_face_distance = d;
                    closest_face_idx = face_idx + 1u;
                }
            }
        }
    }
    if (closest_face_idx > 0u)
    {
        uint param_13 = (first_face_idx + closest_face_idx) - 1u;
        RTFace rt_face_2 = rt_get_face(param_13);
        uint p0_idx_2 = rt_face_2.v0;
        uint p1_idx_2 = rt_face_2.v1;
        uint p2_idx_2 = rt_face_2.v2;
        uint param_14 = p0_idx_2;
        vec3 p0_2 = rt_get_vertex(param_14);
        uint param_15 = p1_idx_2;
        vec3 p1_2 = rt_get_vertex(param_15);
        uint param_16 = p2_idx_2;
        vec3 p2_2 = rt_get_vertex(param_16);
        vec3 closest_pos_2 = ((p0_2 * bc.x) + (p1_2 * bc.y)) + (p2_2 * ((1.0 - bc.x) - bc.y));
        vec3 d_1 = closest_pos_2 - p.pos;
        float time_step = min(1.0, lifecycle_params.time_step);
        float strength = mix(modifier_params.strength * time_step, (modifier_params.strength * time_step) * modifier_factor.factor, modifier_params.strength_modifier_factor);
        float d_length = length(d_1);
        bool _1890 = d_length > 0.0;
        bool _1897;
        if (_1890)
        {
            _1897 = d_length < modifier_params.search_distance;
        }
        else
        {
            _1897 = _1890;
        }
        if (_1897)
        {
            d_1 = (d_1 / vec3(d_length)) * strength;
            p.pos += d_1;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void modifier_factor_noise(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        coords = vector_transform_by_mat43(param, param_1);
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_2, param_3);
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void particle_modifier_kill(ParticleModifierKill_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    bool _2132 = p.state.life_time >= modifier_params.min_lifetime;
    bool _2140;
    if (_2132)
    {
        _2140 = p.state.life_time <= modifier_params.max_lifetime;
    }
    else
    {
        _2140 = _2132;
    }
    if (_2140)
    {
        if (abs(modifier_factor.factor - modifier_params.modifier_factor_base) < modifier_params.modifier_factor_range)
        {
            ParticleState param = p.state;
            prt_kill(param);
            p.state = param;
        }
    }
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _546 = color_convert_uint_to_float3(param);
    c.x = _546.x;
    c.y = _546.y;
    c.z = _546.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    if (modifier_params.color_gradient_idx == (-1))
    {
        return;
    }
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    int param_2 = modifier_params.color_gradient_idx;
    float param_3 = v;
    vec3 color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    ParticleState param_4 = p.state;
    vec4 color_previous = prt_get_color(param_4);
    color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _488;
    _488.life_time = state.life_time;
    _488.life_span = state.life_span;
    _488.generation_id = state.generation_id;
    _488.color = state.color;
    _475.prt_states[id] = _488;
}

void prt_set_position(uint id, vec3 p)
{
    _499.prt_positions[(id * 3u) + 0u] = p.x;
    _499.prt_positions[(id * 3u) + 1u] = p.y;
    _499.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_2288.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _2336 = atomicAdd(_2332.VM0_params.pending, -1);
        int pending = _2336;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _2347;
            _2347.constrained = _2332.VM0_params.constrained;
            _2347.debug_counter = _2332.VM0_params.debug_counter;
            _2347.debug_counter2 = _2332.VM0_params.debug_counter2;
            _2347.debug_counter3 = _2332.VM0_params.debug_counter3;
            _2347.position = _2332.VM0_params.position;
            _2347.falloff_mode = _2332.VM0_params.falloff_mode;
            _2347.radius = _2332.VM0_params.radius;
            _2347.falloff_inverse = _2332.VM0_params.falloff_inverse;
            _2347.particle_color = _2332.VM0_params.particle_color;
            _2347.particle_lifetime = _2332.VM0_params.particle_lifetime;
            _2347.particle_lifetime_randomness = _2332.VM0_params.particle_lifetime_randomness;
            _2347.rate = _2332.VM0_params.rate;
            _2347.seed = _2332.VM0_params.seed;
            _2347.surface_distance = _2332.VM0_params.surface_distance;
            _2347.pending = _2332.VM0_params.pending;
            _2347.transformed_data_location_idx = _2332.VM0_params.transformed_data_location_idx;
            _2347.transformed_data_location_num = _2332.VM0_params.transformed_data_location_num;
            _2347.alpha_to_modifier_factor = _2332.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_4 = _2347;
            ModifierFactor param_5 = modifier_factor;
            Particle param_6 = p;
            uint param_7 = id;
            uint param_8 = uint(pending);
            particle_emitter_geometry_emit(param_4, param_5, param_6, param_7, param_8);
            modifier_factor = param_5;
            p = param_6;
        }
    }
    ParticleState param_9 = p.state;
    if (prt_is_alive(param_9))
    {
        ParticleModifierCurl_Params _2372;
        _2372.position = _2367.VM1_params.position;
        _2372.falloff_mode = _2367.VM1_params.falloff_mode;
        _2372.radius = _2367.VM1_params.radius;
        _2372.falloff_inverse = _2367.VM1_params.falloff_inverse;
        _2372.noise_strength = _2367.VM1_params.noise_strength;
        _2372.noise_speed = _2367.VM1_params.noise_speed;
        _2372.noise_scale = _2367.VM1_params.noise_scale;
        _2372.time_step = _2367.VM1_params.time_step;
        ParticleModifierCurl_Params param_10 = _2372;
        ParticleLifecycleParams _2377;
        _2377.time_step = _2288.lifecycle_params.time_step;
        _2377.max_lifetime = _2288.lifecycle_params.max_lifetime;
        _2377.reset = _2288.lifecycle_params.reset;
        _2377._pad1 = _2288.lifecycle_params._pad1;
        ParticleLifecycleParams param_11 = _2377;
        ModifierFactor param_12 = modifier_factor;
        Particle param_13 = p;
        uint param_14 = id;
        particle_modifier_curl(param_10, param_11, param_12, param_13, param_14);
        modifier_factor = param_12;
        p = param_13;
    }
    ParticleState param_15 = p.state;
    if (prt_is_alive(param_15))
    {
        if (id < _2398.VM2_params.nearest_face_buffer_size)
        {
            uint closest_face_idx = _2398.VM2_closest_face_idx[id];
            ParticleModifierGeometryAttractorParams _2413;
            _2413.strength = _2398.VM2_params.strength;
            _2413.strength_modifier_factor = _2398.VM2_params.strength_modifier_factor;
            _2413.min_distance = _2398.VM2_params.min_distance;
            _2413.min_distance_modifier_factor = _2398.VM2_params.min_distance_modifier_factor;
            _2413.search_distance = _2398.VM2_params.search_distance;
            _2413.transformed_data_location_idx = _2398.VM2_params.transformed_data_location_idx;
            _2413.transformed_data_location_num = _2398.VM2_params.transformed_data_location_num;
            _2413.iteration = _2398.VM2_params.iteration;
            _2413._pad0 = _2398.VM2_params._pad0;
            _2413._pad1 = _2398.VM2_params._pad1;
            _2413._pad2 = _2398.VM2_params._pad2;
            _2413.nearest_face_buffer_size = _2398.VM2_params.nearest_face_buffer_size;
            ParticleModifierGeometryAttractorParams param_16 = _2413;
            ParticleLifecycleParams _2417;
            _2417.time_step = _2288.lifecycle_params.time_step;
            _2417.max_lifetime = _2288.lifecycle_params.max_lifetime;
            _2417.reset = _2288.lifecycle_params.reset;
            _2417._pad1 = _2288.lifecycle_params._pad1;
            ParticleLifecycleParams param_17 = _2417;
            ModifierFactor param_18 = modifier_factor;
            Particle param_19 = p;
            uint param_20 = id;
            uint param_21 = closest_face_idx;
            particle_modifier_geometry_attractor(param_16, param_17, param_18, param_19, param_20, param_21);
            modifier_factor = param_18;
            p = param_19;
            closest_face_idx = param_21;
            _2398.VM2_closest_face_idx[id] = closest_face_idx;
        }
    }
    ModifierFactorDistanceRadial_Params _2441;
    _2441.transform_local_to_gizmo = _2436.VM3_params.transform_local_to_gizmo;
    _2441.falloff_curve_idx = _2436.VM3_params.falloff_curve_idx;
    _2441.falloff_inverse = _2436.VM3_params.falloff_inverse;
    _2441.domain_repeat_x = _2436.VM3_params.domain_repeat_x;
    _2441.domain_repeat_y = _2436.VM3_params.domain_repeat_y;
    _2441.domain_repeat_z = _2436.VM3_params.domain_repeat_z;
    _2441.influence_scope = _2436.VM3_params.influence_scope;
    _2441.modifier_function = _2436.VM3_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_22 = _2441;
    ModifierFactor param_23 = modifier_factor;
    CoordinateSystemTrasforms param_24 = cs_transforms;
    modifier_factor_distance_radial(param_22, param_23, param_24);
    modifier_factor = param_23;
    ParticleState param_25 = p.state;
    if (prt_is_alive(param_25))
    {
        ParticleModifierAttractor_Params _2462;
        _2462.position = _2457.VM4_params.position;
        _2462.radius = _2457.VM4_params.radius;
        _2462.velocity = _2457.VM4_params.velocity;
        ParticleModifierAttractor_Params param_26 = _2462;
        ModifierFactor param_27 = modifier_factor;
        ParticleLifecycleParams _2468;
        _2468.time_step = _2288.lifecycle_params.time_step;
        _2468.max_lifetime = _2288.lifecycle_params.max_lifetime;
        _2468.reset = _2288.lifecycle_params.reset;
        _2468._pad1 = _2288.lifecycle_params._pad1;
        ParticleLifecycleParams param_28 = _2468;
        Particle param_29 = p;
        uint param_30 = id;
        particle_modifier_attractor(param_26, param_27, param_28, param_29, param_30);
        p = param_29;
    }
    ModifierFactorNoise_Params _2483;
    _2483.transform_local_to_gizmo = _2478.VM5_params.transform_local_to_gizmo;
    _2483.noise_domain_scale = _2478.VM5_params.noise_domain_scale;
    _2483.modifier_function = _2478.VM5_params.modifier_function;
    _2483.noise_domain_offset = _2478.VM5_params.noise_domain_offset;
    _2483.noise_value_scale = _2478.VM5_params.noise_value_scale;
    _2483.noise_value_offset = _2478.VM5_params.noise_value_offset;
    _2483.influence_scope = _2478.VM5_params.influence_scope;
    _2483._pad0 = _2478.VM5_params._pad0;
    _2483._pad1 = _2478.VM5_params._pad1;
    ModifierFactorNoise_Params param_31 = _2483;
    ModifierFactor param_32 = modifier_factor;
    CoordinateSystemTrasforms param_33 = cs_transforms;
    modifier_factor_noise(param_31, param_32, param_33);
    modifier_factor = param_32;
    ParticleState param_34 = p.state;
    if (prt_is_alive(param_34))
    {
        ParticleModifierKill_Params _2504;
        _2504.modifier_factor_base = _2499.VM6_params.modifier_factor_base;
        _2504.modifier_factor_range = _2499.VM6_params.modifier_factor_range;
        _2504.min_lifetime = _2499.VM6_params.min_lifetime;
        _2504.max_lifetime = _2499.VM6_params.max_lifetime;
        ParticleModifierKill_Params param_35 = _2504;
        ModifierFactor param_36 = modifier_factor;
        Particle param_37 = p;
        uint param_38 = id;
        particle_modifier_kill(param_35, param_36, param_37, param_38);
        p = param_37;
    }
    ParticleState param_39 = p.state;
    if (prt_is_alive(param_39))
    {
        ParticleModifierColorize_Params _2527;
        _2527.mode = _2522.VM7_params.mode;
        _2527.color_gradient_idx = _2522.VM7_params.color_gradient_idx;
        _2527.randomness = _2522.VM7_params.randomness;
        _2527.blend_from_previous = _2522.VM7_params.blend_from_previous;
        _2527.color = _2522.VM7_params.color;
        ParticleModifierColorize_Params param_40 = _2527;
        ModifierFactor param_41 = modifier_factor;
        Particle param_42 = p;
        uint param_43 = id;
        particle_modifier_colorize(param_40, param_41, param_42, param_43);
        modifier_factor = param_41;
        p = param_42;
    }
    ParticleState param_44 = p.state;
    float param_45 = _2288.lifecycle_params.time_step;
    float param_46 = _2288.lifecycle_params.max_lifetime;
    prt_advance_life(param_44, param_45, param_46);
    p.state = param_44;
    uint param_47 = id;
    ParticleState param_48 = p.state;
    prt_set_state(param_47, param_48);
    uint param_49 = id;
    vec3 param_50 = p.pos;
    prt_set_position(param_49, param_50);
}

 