#version 450
#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
#extension GL_EXT_shader_16bit_storage : require
#extension GL_KHR_shader_subgroup_ballot : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
};

struct ray_state_user_data
{
    uint dummy;
};

struct ray_traversal_params
{
    float trace_range_primary;
    float trace_range_secondary;
};

struct ray_state
{
    vec3 color;
    vec3 normal;
    vec3 dir;
    vec3 origin;
    float transparency;
    bool running;
    int16_t bounces;
    int16_t material;
    int tests;
    int face_tests;
    bool hit;
    bool left;
    bool inside_transparent;
    uint active_threads_factor;
    uint active_threads_samples;
    float final_color_factor;
    ray_state_user_data user_data;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstancingTraceBouncesParams
{
    mat4 transform_local_to_gizmo;
    uint num_instances;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _275;

layout(set = 0, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _329;

layout(set = 0, binding = 3, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _342;

layout(set = 0, binding = 4, std430) buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _686;

layout(set = 0, binding = 5, std430) buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 0, binding = 6, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 7, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1586;

layout(set = 0, binding = 8, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1602;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1624;

layout(set = 0, binding = 10, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1644;

layout(set = 0, binding = 11, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1652;

layout(set = 0, binding = 13, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 14, std140) uniform InstancingTraceBouncesParamsBuffer
{
    layout(row_major) InstancingTraceBouncesParams instancing_generator_params;
} _1794;

layout(set = 0, binding = 12, std430) buffer SourceInstanceTransformBuffer
{
    vec4 source_instance_transform[];
} _1813;

layout(set = 0, binding = 15) uniform usampler3D s_grid_marker;

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

uint ballot_count(bool v)
{
    uvec4 ballot = subgroupBallot(v);
    uint cnt = uint(bitCount(ballot.x));
    cnt += uint(bitCount(ballot.y));
    return cnt;
}

bool is_pos_inside_grid(i16vec3 icell)
{
    int16_t icell_mask = (icell.x | icell.y) | icell.z;
    if ((int(icell_mask) & (-256)) == 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

void rt_pack_grid_marker_to_uint(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

bool rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u) ? true : false;
}

bool rt_read_grid_marker_low_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 2).x & uint(1 << int(bit))) != 0u) ? true : false;
}

bool fetch_grid_marker_for_cell(ivec3 icell, int mip)
{
    if (mip == 0)
    {
        ivec3 param = icell;
        return rt_read_grid_marker_high_res(s_grid_marker, param);
    }
    else
    {
        ivec3 param_1 = icell >> ivec3(2);
        return rt_read_grid_marker_low_res(s_grid_marker, param_1);
    }
}

ivec3 dda_step_from_dir(vec3 dir, vec3 cell_step)
{
    vec3 s = step(vec3(0.0), dir);
    vec3 sgn = ((s * cell_step) * 2.0) - cell_step;
    return ivec3(sgn);
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _342.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _342.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _342.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_275.in_vtx_data[coord_offset + 0u], _275.in_vtx_data[coord_offset + 1u], _275.in_vtx_data[coord_offset + 2u]);
    return p;
}

intersection intersectTriangle3(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        return it;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        return it;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _620 = v < 0.0;
    bool _628;
    if (!_620)
    {
        _628 = (u + v) > 1.0;
    }
    else
    {
        _628 = _620;
    }
    if (_628)
    {
        return it;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = vec3(normalize(cross(e2, e1)));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

void findClosestBucket2(ray_state_user_data user_data, uint list_index, bool bucket_full, uint max_tests, vec3 origin, vec3 dir, int skip_fi, float max_t, inout int closest_fi, inout uint material_flags, inout float closest_it, inout vec3 closest_norm, inout vec2 closest_bc, out int face_tests)
{
    face_tests = 0;
    closest_fi = -1;
    closest_it = max_t;
    uint head = _686.in_faces_list_tails_data[list_index];
    uint cnt = in_faces_list_data.node_buffer[head];
    if ((max_tests != 4294967295u) && (cnt >= max_tests))
    {
        closest_fi = -1;
        return;
    }
    face_tests = int(cnt);
    for (int fi_idx = 0; uint(fi_idx) < cnt; fi_idx++)
    {
        int fi = int(in_faces_list_data.node_buffer[(head + uint(fi_idx)) + 1u]);
        if (fi == skip_fi)
        {
            continue;
        }
        uint param = uint(fi);
        RTFace rt_face = rt_get_face(param);
        uint param_1 = rt_face.v0;
        vec3 p0 = rt_get_vertex(param_1);
        uint param_2 = rt_face.v1;
        vec3 p1 = rt_get_vertex(param_2);
        uint param_3 = rt_face.v2;
        vec3 p2 = rt_get_vertex(param_3);
        vec3 param_4 = origin;
        vec3 param_5 = dir;
        vec3 param_6 = p2;
        vec3 param_7 = p1;
        vec3 param_8 = p0;
        intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
        bool _769 = it1.t >= 0.0;
        bool _776;
        if (_769)
        {
            _776 = it1.t <= closest_it;
        }
        else
        {
            _776 = _769;
        }
        if (_776)
        {
            if ((rt_face.material_flags & 64u) == 0u)
            {
                if (dot(dir, it1.normal) >= 0.0)
                {
                    continue;
                }
            }
            closest_fi = fi;
            closest_it = it1.t;
        }
    }
    if (closest_fi != (-1))
    {
        uint param_9 = uint(closest_fi);
        RTFace rt_face_1 = rt_get_face(param_9);
        uint param_10 = rt_face_1.v0;
        vec3 p0_1 = rt_get_vertex(param_10);
        uint param_11 = rt_face_1.v1;
        vec3 p1_1 = rt_get_vertex(param_11);
        uint param_12 = rt_face_1.v2;
        vec3 p2_1 = rt_get_vertex(param_12);
        vec3 param_13 = origin;
        vec3 param_14 = dir;
        vec3 param_15 = p2_1;
        vec3 param_16 = p1_1;
        vec3 param_17 = p0_1;
        intersection it1_1 = intersectTriangle3(param_13, param_14, param_15, param_16, param_17);
        closest_norm = it1_1.normal;
        closest_bc = it1_1.bc;
        material_flags = rt_face_1.material_flags;
    }
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint param = uint(idx);
    RTFace rt_face = rt_get_face(param);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_1 = p0_idx;
    vec3 a = rt_get_vertex(param_1);
    uint param_2 = p1_idx;
    vec3 b = rt_get_vertex(param_2);
    uint param_3 = p2_idx;
    vec3 c = rt_get_vertex(param_3);
    vec3 param_4 = p;
    vec3 param_5 = a;
    vec3 param_6 = b;
    vec3 param_7 = c;
    return vec2(rt_barycentric_yz(param_4, param_5, param_6, param_7));
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _275.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _275.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec3 n0 = vec3(rt_get_vertex_normal(param_1));
    uint param_2 = i1;
    vec3 n1 = vec3(rt_get_vertex_normal(param_2));
    uint param_3 = i2;
    vec3 n2 = vec3(rt_get_vertex_normal(param_3));
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return vec3(normalize(smooth_normal));
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_329.transformed_data_faces[idx].material_idx);
    return p;
}

void emit_instance(ray_state state, vec3 p, vec3 n, float ray_distance)
{
    float w = 0.75;
    vec3 instance_scale = vec3(w / float(state.bounces), w / float(state.bounces), ray_distance * 0.5);
    vec3 instance_position = p;
    vec3 nz = n;
    vec3 nx = vec3(1.0, 0.0, 0.0);
    vec3 ny = normalize(cross(nz, nx));
    nx = normalize(cross(ny, nz));
    mat3 transform_scale;
    transform_scale[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform_scale[1] = vec3(0.0, instance_scale.y, 0.0);
    transform_scale[2] = vec3(0.0, 0.0, instance_scale.z);
    mat3 transform;
    transform[0] = vec3(nx.x, ny.x, nz.x);
    transform[1] = vec3(nx.y, ny.y, nz.y);
    transform[2] = vec3(nx.z, ny.z, nz.z);
    transform = transform_scale * transform;
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = 0u;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    bool _1560 = length(instance.m0.xyz) < 9.9999997473787516355514526367188e-05;
    bool _1569;
    if (!_1560)
    {
        _1569 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _1569 = _1560;
    }
    bool _1578;
    if (!_1569)
    {
        _1578 = length(instance.m1.xyz) < 9.9999997473787516355514526367188e-05;
    }
    else
    {
        _1578 = _1569;
    }
    if (_1578)
    {
        return;
    }
    int _1589 = atomicAdd(_1586.instance_params.instance_count, 1);
    uint instance_id = uint(_1589);
    if (instance_id >= uint(_1586.instance_params.buffer_capacity))
    {
        return;
    }
    _1602.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _1602.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _1602.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _1624.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1624.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1644.instance_hash[instance_id] = instance.hash;
    _1652.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(vec3(v), n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

void evaluate_material(inout ray_state state, vec3 prev_state_origin, int hit_face, uint hit_material_flags, vec2 bc, bool flip_normal_on_glass)
{
    uint param = uint(hit_face);
    int16_t hit_material = int16_t(rt_get_triangle_material(param));
    if ((hit_material_flags & 2048u) == 0u)
    {
    }
    float ray_length = length(prev_state_origin - state.origin);
    bool _1677 = int(state.bounces) > 2;
    bool _1689;
    if (!_1677)
    {
        _1689 = (int(state.bounces) == 1) && (ray_length > 1000.0);
    }
    else
    {
        _1689 = _1677;
    }
    if (_1689)
    {
        ray_state param_1 = state;
        vec3 param_2 = prev_state_origin;
        vec3 param_3 = state.dir;
        float param_4 = -ray_length;
        emit_instance(param_1, param_2, param_3, param_4);
    }
    if ((materials.material_properties[state.material].flags & 32u) == 0u)
    {
        bool _1730;
        if (!state.hit)
        {
            _1730 = int(state.bounces) == 4;
        }
        else
        {
            _1730 = state.hit;
        }
        state.hit = _1730;
    }
    if ((hit_material_flags & 32u) == 0u)
    {
        state.dir = reflect(state.dir, vec3(state.normal));
    }
    else
    {
        vec3 param_5 = state.dir;
        vec3 param_6 = state.normal;
        vec3 refracted_dir = glass_refract(param_5, param_6);
        state.dir = refracted_dir;
    }
    bool _1760 = (hit_material_flags & 1u) == 0u;
    bool _1766;
    if (_1760)
    {
        _1766 = (hit_material_flags & 32u) == 0u;
    }
    else
    {
        _1766 = _1760;
    }
    if (_1766)
    {
        state.hit = true;
    }
    if (int(state.bounces) > 4)
    {
        state.running = false;
    }
    state.material = hit_material;
}

int findClosestDDAMultibounce(ray_traversal_params traversal_params, inout ray_state state, inout int skip_fi, inout int closest_fi, inout float closest_it, int max_bounces)
{
    closest_fi = -1;
    closest_it = 1000000.0;
    vec3 cellDimension = vec3(in_bbox_data.grid_size_raytrace.xyz);
    float tmin = 0.0;
    float tmax = traversal_params.trace_range_primary;
    vec3 ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro_cell / cellDimension));
    vec3 s = step(vec3(0.0), state.dir);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 deltaT = (sgn * cellDimension) / state.dir;
    vec3 nextCrossingT = vec3(tmin) + ((((floor(ro_cell / cellDimension) + s) * cellDimension) - ro_cell) / state.dir);
    float rt = tmin;
    bool inside = false;
    bool prev_inside = inside;
    int max_iter = 96;
    bool param = true;
    int threads_running = int(ballot_count(param));
    int param_20;
    uint param_21;
    float param_22;
    vec3 param_23;
    vec2 param_24;
    int param_25;
    while ((rt < tmax) && (max_iter >= 0))
    {
        bool hit = false;
        max_iter--;
        state.tests++;
        if (state.running == false)
        {
            break;
        }
        rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
        prev_inside = prev_inside || inside;
        inside = false;
        bool search_bucket = false;
        uint icell_idx = 0u;
        bool bucket_full = false;
        i16vec3 param_1 = i16vec3(icell);
        if (is_pos_inside_grid(param_1))
        {
            inside = true;
            icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
            ivec3 param_2 = icell;
            int param_3 = 0;
            bucket_full = fetch_grid_marker_for_cell(param_2, param_3);
        }
        if (true)
        {
            bool _1062;
            if (!bucket_full)
            {
                _1062 = (prev_inside == true) && (inside == false);
            }
            else
            {
                _1062 = bucket_full;
            }
            bool done_criteria = _1062;
            bool param_4 = done_criteria;
            uint hit_threads = ballot_count(param_4);
            int ii = 0;
            while ((hit_threads < 16u) && (ii < 4))
            {
                state.tests++;
                if (done_criteria == false)
                {
                    max_iter--;
                    vec3 mm = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
                    vec3 param_5 = state.dir;
                    vec3 param_6 = mm;
                    icell += dda_step_from_dir(param_5, param_6);
                    nextCrossingT += (mm * deltaT);
                    rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
                    i16vec3 param_7 = i16vec3(icell);
                    inside = is_pos_inside_grid(param_7);
                    prev_inside = prev_inside || inside;
                    if (inside)
                    {
                        icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
                        ivec3 param_8 = icell;
                        int param_9 = 0;
                        bucket_full = fetch_grid_marker_for_cell(param_8, param_9);
                    }
                    bool _1156;
                    if (!bucket_full)
                    {
                        _1156 = (prev_inside == true) && (inside == false);
                    }
                    else
                    {
                        _1156 = bucket_full;
                    }
                    done_criteria = _1156;
                }
                ii++;
                bool param_10 = done_criteria;
                hit_threads = ballot_count(param_10);
            }
        }
        if (bucket_full)
        {
            bool param_11 = true;
            state.active_threads_factor += ballot_count(param_11);
            state.active_threads_samples++;
            int face_tests = 0;
            uint max_tests = 4294967295u;
            bool _1180 = closest_fi == (-1);
            bool _1188;
            if (_1180)
            {
                _1188 = state.face_tests > 512;
            }
            else
            {
                _1188 = _1180;
            }
            if (_1188)
            {
                max_tests = 16u;
            }
            ray_state_user_data param_12 = state.user_data;
            uint param_13 = icell_idx;
            bool param_14 = bucket_full;
            uint param_15 = max_tests;
            vec3 param_16 = state.origin;
            vec3 param_17 = state.dir;
            int param_18 = skip_fi;
            float param_19 = min(tmax, rt);
            findClosestBucket2(param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21, param_22, param_23, param_24, param_25);
            state.user_data = param_12;
            closest_fi = param_20;
            uint closest_material_flags = param_21;
            closest_it = param_22;
            vec3 closest_normal = param_23;
            vec2 closest_bc = param_24;
            face_tests = param_25;
            state.face_tests += face_tests;
            if (closest_fi != (-1))
            {
                state.bounces += 1s;
                state.normal = closest_normal;
                hit = true;
                skip_fi = closest_fi;
                bool _1252 = int(state.bounces) >= max_bounces;
                bool _1260;
                if (!_1252)
                {
                    _1260 = (closest_material_flags & 2048u) != 0u;
                }
                else
                {
                    _1260 = _1252;
                }
                if (_1260)
                {
                    state.running = false;
                }
                int param_26 = closest_fi;
                vec3 param_27 = state.origin + (state.dir * closest_it);
                vec2 bc = barycentric_for_face_yz(param_26, param_27);
                if ((closest_material_flags & 128u) == 0u)
                {
                    int param_28 = closest_fi;
                    vec2 param_29 = bc;
                    vec3 param_30 = state.normal;
                    state.normal = interpolate_normal_from_bc_yz(param_28, param_29, param_30);
                }
                bool flip_normal_on_glass = false;
                if ((closest_material_flags & 32u) != 0u)
                {
                    flip_normal_on_glass = (dot(state.normal, state.dir) > 0.0) ? true : false;
                }
                vec3 prev_state_origin = state.origin;
                state.origin += (state.dir * closest_it);
                ray_state param_31 = state;
                vec3 param_32 = prev_state_origin;
                int param_33 = closest_fi;
                uint param_34 = closest_material_flags;
                vec2 param_35 = bc;
                bool param_36 = flip_normal_on_glass;
                evaluate_material(param_31, param_32, param_33, param_34, param_35, param_36);
                state = param_31;
                if (max_bounces > 1)
                {
                    vec3 ird = vec3(1.0) / state.dir;
                    ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
                    vec3 s_1 = step(vec3(0.0), state.dir);
                    vec3 sgn_1 = (s_1 * 2.0) - vec3(1.0);
                    deltaT = (sgn_1 * cellDimension) * ird;
                    nextCrossingT = vec3(tmin) + ((((floor(ro_cell / cellDimension) + s_1) * cellDimension) - ro_cell) * ird);
                    tmax = traversal_params.trace_range_secondary;
                    rt = tmin;
                }
            }
        }
        if ((inside == false) && (prev_inside == true))
        {
            state.running = false;
            state.left = true;
        }
        if (!hit)
        {
            vec3 mm_1 = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
            vec3 param_37 = state.dir;
            vec3 param_38 = mm_1;
            icell += dda_step_from_dir(param_37, param_38);
            nextCrossingT += (mm_1 * deltaT);
        }
    }
    return 0;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id == 0u)
    {
    }
    if (id >= _1794.instancing_generator_params.num_instances)
    {
        return;
    }
    if (_1586.instance_params.instance_count >= _1586.instance_params.buffer_capacity)
    {
        return;
    }
    Instance src_instance;
    src_instance.m0 = _1813.source_instance_transform[(id * 3u) + 0u];
    src_instance.m1 = _1813.source_instance_transform[(id * 3u) + 1u];
    src_instance.m2 = _1813.source_instance_transform[(id * 3u) + 2u];
    vec3 param = vec3(0.0);
    mat4 param_1 = _1794.instancing_generator_params.transform_local_to_gizmo;
    vec3 base_position = vector_transform_by_mat43(param, param_1);
    vec3 instance_position = base_position + vec3(src_instance.m0.w, src_instance.m1.w, src_instance.m2.w);
    vec3 instance_scale = vec3(1.0);
    vec3 instance_dir = vec3(src_instance.m0.z, src_instance.m1.z, src_instance.m2.z);
    ray_traversal_params traversal_params;
    traversal_params.trace_range_primary = 2000.0;
    traversal_params.trace_range_secondary = 350.0;
    ray_state state;
    state.color = vec3(1.0);
    state.transparency = 1.0;
    state.normal = instance_dir;
    state.material = 0s;
    state.running = true;
    state.dir = instance_dir;
    state.origin = instance_position;
    state.bounces = 1s;
    state.hit = false;
    state.left = false;
    state.tests = 0;
    state.face_tests = 0;
    state.active_threads_factor = 0u;
    state.active_threads_samples = 0u;
    state.final_color_factor = 1.0;
    int closest_fi = -1;
    float closest_it = 0.0;
    ray_traversal_params param_2 = traversal_params;
    ray_state param_3 = state;
    int param_4 = closest_fi;
    int param_7 = 4;
    int param_5;
    float param_6;
    int _1895 = findClosestDDAMultibounce(param_2, param_3, param_4, param_5, param_6, param_7);
    state = param_3;
    closest_fi = param_5;
    closest_it = param_6;
    bool _1907;
    if (state.hit)
    {
        _1907 = int(state.bounces) < 5;
    }
    else
    {
        _1907 = state.hit;
    }
    if (_1907)
    {
    }
}

 