#version 450

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
};

struct _533
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _655;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _669;

layout(set = 1, binding = 4, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _701;

layout(set = 1, binding = 5, std140) uniform VM1
{
    ModifierFactorRangeRemap_Params VM1_params;
} _716;

layout(set = 1, binding = 6, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _729;

layout(set = 1, binding = 7) uniform sampler2D s_Curves;
layout(set = 1, binding = 8) uniform sampler2D material_textures[64];

layout(location = 1) in _533 vtx_input;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        coords = vector_transform_by_mat43(param, param_1);
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            coords = vector_transform_by_mat43(param_2, param_3);
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 rel_coords = vector_transform_by_mat43(param_4, param_5);
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _509 = material.albedo_sampler >= 0;
    bool _516;
    if (_509)
    {
        _516 = material.albedo_sampler < 16;
    }
    else
    {
        _516 = _509;
    }
    if (_516)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.albedo_texture = mapping_triplanar(material_textures[material.albedo_sampler], param, param_1, param_2);
        }
        else
        {
            material_eval.albedo_texture = texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    bool _559 = material.emissive_sampler >= 0;
    bool _565;
    if (_559)
    {
        _565 = material.emissive_sampler < 16;
    }
    else
    {
        _565 = _559;
    }
    if (_565)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_3 = vtx_input.vLocalPos;
            vec3 param_4 = norm;
            vec3 param_5 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param_3, param_4, param_5).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
    bool _600 = material.metalic_roughness_sampler >= 0;
    bool _606;
    if (_600)
    {
        _606 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _606 = _600;
    }
    if (_606)
    {
        vec2 metalic_roughness = vec2(1.0);
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_6 = vtx_input.vLocalPos;
            vec3 param_7 = norm;
            vec3 param_8 = material.triplanar_factor;
            metalic_roughness = mapping_triplanar(material_textures[material.metalic_roughness_sampler], param_6, param_7, param_8).xy;
        }
        else
        {
            metalic_roughness = texture(material_textures[material.metalic_roughness_sampler], uv0).xy;
        }
        material_eval.metalness_texture = clamp(metalic_roughness.x, 0.0, 1.0);
        material_eval.roughness_texture = clamp(metalic_roughness.y, 0.0, 1.0);
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    float factor = eval_input.modifier_factor;
    eval.is_discarded = fract(factor) > 0.800000011920928955078125;
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
}

void main()
{
    MaterialPropertiesGPU _662;
    _662.diffuse = materials.material_properties[_655.materialIndex].diffuse;
    _662.transparency = materials.material_properties[_655.materialIndex].transparency;
    _662.emissive = materials.material_properties[_655.materialIndex].emissive;
    _662.roughness = materials.material_properties[_655.materialIndex].roughness;
    _662.triplanar_factor = materials.material_properties[_655.materialIndex].triplanar_factor;
    _662.refraction = materials.material_properties[_655.materialIndex].refraction;
    _662.normal_factor = materials.material_properties[_655.materialIndex].normal_factor;
    _662.emissive_factor = materials.material_properties[_655.materialIndex].emissive_factor;
    _662.temporal_accumulation_factor = materials.material_properties[_655.materialIndex].temporal_accumulation_factor;
    _662.shadowmap_bias = materials.material_properties[_655.materialIndex].shadowmap_bias;
    _662.metalness = materials.material_properties[_655.materialIndex].metalness;
    _662.albedo_sampler = materials.material_properties[_655.materialIndex].albedo_sampler;
    _662.emissive_sampler = materials.material_properties[_655.materialIndex].emissive_sampler;
    _662.normal_sampler = materials.material_properties[_655.materialIndex].normal_sampler;
    _662.metalic_roughness_sampler = materials.material_properties[_655.materialIndex].metalic_roughness_sampler;
    _662.flags = materials.material_properties[_655.materialIndex].flags;
    _662._pad0 = materials.material_properties[_655.materialIndex]._pad0;
    _662._pad1 = materials.material_properties[_655.materialIndex]._pad1;
    MaterialPropertiesGPU material = _662;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _669.transform_params.vCameraPosition;
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _669.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _669.transform_params.mModelInv;
    ModifierFactorDistanceRadial_Params _706;
    _706.transform_local_to_gizmo = _701.VM0_params.transform_local_to_gizmo;
    _706.falloff_curve_idx = _701.VM0_params.falloff_curve_idx;
    _706.falloff_inverse = _701.VM0_params.falloff_inverse;
    _706.domain_repeat_x = _701.VM0_params.domain_repeat_x;
    _706.domain_repeat_y = _701.VM0_params.domain_repeat_y;
    _706.domain_repeat_z = _701.VM0_params.domain_repeat_z;
    _706.influence_scope = _701.VM0_params.influence_scope;
    _706.modifier_function = _701.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param = _706;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_distance_radial(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorRangeRemap_Params _721;
    _721.input_min = _716.VM1_params.input_min;
    _721.input_max = _716.VM1_params.input_max;
    _721.output_min = _716.VM1_params.output_min;
    _721.output_max = _716.VM1_params.output_max;
    _721.min_out_of_bounds_mode = _716.VM1_params.min_out_of_bounds_mode;
    _721.max_out_of_bounds_mode = _716.VM1_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_3 = _721;
    ModifierFactor param_4 = modifier_factor;
    modifier_factor_range_remap(param_3, param_4);
    modifier_factor = param_4;
    ModifierFactorMulAdd_Params _734;
    _734.multiply_value = _729.VM2_params.multiply_value;
    _734.add_value = _729.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_5 = _734;
    ModifierFactor param_6 = modifier_factor;
    modifier_factor_mul_add(param_5, param_6);
    modifier_factor = param_6;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _655.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = 0.0;
    material_eval.metalness = 0.0;
    material_eval.is_discarded = false;
    material_eval.normal = vec3(0.0);
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    MaterialEvalInput eval_input;
    eval_input.uv0 = vtx_input.vUV0;
    eval_input.normal = vtx_input.vNorm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    MaterialPropertiesGPU param_7 = material;
    MaterialEval param_8 = material_eval;
    MaterialEvalInput param_9 = eval_input;
    material_evaluate(param_7, param_8, param_9);
    material_eval = param_8;
    eval_input = param_9;
    if (material_eval.is_discarded)
    {
        discard;
    }
}

 