#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint material_idx;
    int _points_per_instance;
    int _faces_per_instance;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct DrawElementsIndirectParams
{
    uint count;
    uint instance_count;
    uint first_index;
    uint base_vertex;
    uint base_instance;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 3, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _32;

layout(set = 0, binding = 1, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _45;

layout(set = 0, binding = 2, std430) buffer TransformedDataDrawIndirectParamsBuffer
{
    DrawElementsIndirectParams transformed_data_draw_indirect_params[];
} _100;

void main()
{
    if (gl_LocalInvocationIndex == 0u)
    {
        for (uint i = 0u; i < _32.transform_geometry_params.instance_idx; i++)
        {
            uint num_faces = _45.transformed_data_location[i].last_face_idx + 1u;
            uint first_idx = 0u;
            if (i > 0u)
            {
                num_faces -= (_45.transformed_data_location[i - 1u].last_face_idx + 1u);
                first_idx = _45.transformed_data_location[i - 1u].last_face_idx + 1u;
            }
            bool _72 = _32.transform_geometry_params.raytrace != 0u;
            bool _79;
            if (_72)
            {
                _79 = _45.transformed_data_location[i].raytrace == 0u;
            }
            else
            {
                _79 = _72;
            }
            if (_79)
            {
                num_faces = 0u;
            }
            bool _85 = _32.transform_geometry_params.voxelize != 0u;
            bool _93;
            if (_85)
            {
                _93 = _45.transformed_data_location[i].voxelize == 0u;
            }
            else
            {
                _93 = _85;
            }
            if (_93)
            {
                num_faces = 0u;
            }
            _100.transformed_data_draw_indirect_params[i].count = num_faces * 3u;
            _100.transformed_data_draw_indirect_params[i].instance_count = 1u;
            _100.transformed_data_draw_indirect_params[i].first_index = first_idx * 3u;
            _100.transformed_data_draw_indirect_params[i].base_vertex = 0u;
            _100.transformed_data_draw_indirect_params[i].base_instance = 0u;
        }
    }
}

 