#version 450
layout(local_size_x = 8, local_size_y = 4, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct VXParams
{
    float average_position_factor;
    float average_normal_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    int filter_step;
};

const float _341[3] = float[](0.279009997844696044921875, 0.44198000431060791015625, 0.279009997844696044921875);
const int _357[3] = int[](-1, 0, 1);

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _114;

layout(set = 0, binding = 2, std140) uniform VoxelLightingParams
{
    VXParams voxel_lighting_setup;
} _296;

layout(set = 0, binding = 3, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 6) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 4, rgba16f) uniform readonly image2D imOcclusion;
layout(set = 0, binding = 5, rgba16) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _114.dispatch_setup.near_far_plane.z / ((_114.dispatch_setup.near_far_plane.y + _114.dispatch_setup.near_far_plane.x) - (d * _114.dispatch_setup.near_far_plane.w));
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

void world_normal_position(ivec2 pos, out vec3 world, out vec3 normal)
{
    vec3 view_direction;
    view_direction.x = (-_114.dispatch_setup.camera_projection_params.z) + ((_114.dispatch_setup.camera_projection_params.x * float(pos.x)) * _114.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_114.dispatch_setup.camera_projection_params.w) + ((_114.dispatch_setup.camera_projection_params.y * float(pos.y)) * _114.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
    float param = texelFetch(sTextureDepth, pos, 0).x;
    float depth = linearizeDepth(param);
    uint param_1 = encoded_normal_material;
    normal = decode_normal(param_1);
    vec3 param_2 = view_direction;
    float param_3 = depth;
    world = positionFromDepth(param_2, param_3);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u, 4u)) + gl_LocalInvocationID.xy;
    ivec2 pos = ivec2(pixel_pos);
    uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
    uint param = encoded_normal_material;
    int materialId = decode_material(param);
    float occlusion = 0.0;
    vec3 color = vec3(0.0);
    float sd = 0.0;
    if ((materialId & 1) == 1)
    {
    }
    else
    {
        vec3 view_direction;
        view_direction.x = (-_114.dispatch_setup.camera_projection_params.z) + ((_114.dispatch_setup.camera_projection_params.x * float(pos.x)) * _114.dispatch_setup.inv_resolution.x);
        view_direction.y = (-_114.dispatch_setup.camera_projection_params.w) + ((_114.dispatch_setup.camera_projection_params.y * float(pos.y)) * _114.dispatch_setup.inv_resolution.y);
        view_direction.z = 1.0;
        uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
        float param_1 = texelFetch(sTextureDepth, pos, 0).x;
        float depth = linearizeDepth(param_1);
        ivec2 param_2 = pos;
        vec3 param_3;
        vec3 param_4;
        world_normal_position(param_2, param_3, param_4);
        vec3 world = param_3;
        vec3 vNorm = param_4;
        sd = _296.voxel_lighting_setup.average_position_factor + 1.0;
        sd = 0.0;
        vec4 v = vec4(0.0);
        vec4 c_occlusion = imageLoad(imOcclusion, pos);
        occlusion = 0.0;
        color = vec3(0.0);
        float filter_step_squared = float(_296.voxel_lighting_setup.filter_step) * float(_296.voxel_lighting_setup.filter_step);
        vec3 param_7;
        vec3 param_8;
        for (int iy = 0; iy < 3; iy++)
        {
            for (int ix = 0; ix < 3; ix++)
            {
                float d_kernel = _341[ix] * _341[iy];
                uint x = uint(pos.x + (_357[ix] * _296.voxel_lighting_setup.filter_step));
                uint y = uint(pos.y + (_357[iy] * _296.voxel_lighting_setup.filter_step));
                uint encoded_normal_material_at_pos = imageLoad(imNormalMaterial, ivec2(int(x), int(y))).x;
                uint param_5 = encoded_normal_material_at_pos;
                int materialIdAtPos = decode_material(param_5);
                if ((materialIdAtPos & 1) == 1)
                {
                    continue;
                }
                ivec2 param_6 = ivec2(int(x), int(y));
                world_normal_position(param_6, param_7, param_8);
                vec3 p_world = param_7;
                vec3 p_normal = param_8;
                float position_diff = dot(world - p_world, world - p_world);
                float d_pos = min(exp((-position_diff) / _296.voxel_lighting_setup.average_position_factor), 1.0);
                float d_norm = max(dot(vNorm - p_normal, vNorm - p_normal) / filter_step_squared, 0.0);
                d_norm = min(exp((-d_norm) / _296.voxel_lighting_setup.average_normal_factor), 1.0);
                vec4 v_1 = imageLoad(imOcclusion, ivec2(int(x), int(y)));
                float d_color = 1.0;
                vec3 dc = abs(c_occlusion.xyz - v_1.xyz);
                dc /= (dc + vec3(1.0));
                d_color = dot(dc, dc);
                d_color = min(exp((-d_color) / _296.voxel_lighting_setup.average_colors_factor), 1.0);
                float d_occlusion = (c_occlusion.w - v_1.w) * (c_occlusion.w - v_1.w);
                float d = (d_pos * d_norm) * d_kernel;
                occlusion += (v_1.w * d);
                color += (v_1.xyz * d);
                sd += d;
            }
        }
        if (sd > 0.0)
        {
            occlusion /= sd;
            color /= vec3(sd);
        }
    }
    imageStore(imTarget, pos, vec4(color, occlusion));
}

 