#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

const float _279[7] = float[](0.071303434669971466064453125, 0.13151411712169647216796875, 0.189879238605499267578125, 0.2146064341068267822265625, 0.189879238605499267578125, 0.13151411712169647216796875, 0.071303434669971466064453125);

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float rt_strength;
    float ibl_intensity;
    float taa_blend;
    float taa_gamma;
    uint transparency_blend;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct CompositeParams
{
    float ssr_scaling_factor;
    int composite_output_mode;
    float raytrace_scaling_factor;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _191;

layout(set = 0, binding = 2, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _385;

layout(set = 0, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 4, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_params;
} _761;

layout(set = 0, binding = 6) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 7) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 8) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 9) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 10) uniform sampler2D sAlbedo;
layout(set = 0, binding = 11) uniform sampler2D sShadow;
layout(set = 0, binding = 12) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 13) uniform sampler2D sVoxelOcclusion;
layout(set = 0, binding = 14) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 15) uniform sampler2D sParticles;
layout(set = 0, binding = 5, rgba16f) uniform writeonly image2D imTarget;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data & 2147483647u;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _191.dispatch_setup.near_far_plane.z / ((_191.dispatch_setup.near_far_plane.y + _191.dispatch_setup.near_far_plane.x) - (d * _191.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_191.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _385.composite_setup.fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _385.composite_setup.fill_color.xyz) + specular, 1.0);
}

vec4 sample_volumetric_fog(uvec2 pixel_pos, float ref_depth, uint ref_material_idx)
{
    vec4 c0 = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
    vec4 vc = vec4(0.0);
    float total_w = 1.0;
    for (int y = -3; y <= 3; y++)
    {
        for (int x = -3; x <= 3; x++)
        {
            if ((x == 0) && (y == 0))
            {
                continue;
            }
            ivec2 sampling_pos = ivec2(pixel_pos) + ivec2(x, y);
            float w = _279[x + 3] * _279[y + 3];
            uvec4 param = texelFetch(sMetalnessRoughnessMaterialTags, sampling_pos, 0);
            MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
            if (ref_material_idx != metalness_roughness_material_tags.material_index)
            {
                w = 0.0;
            }
            float depth = texelFetch(sTextureDepth, sampling_pos, 0).x;
            if (abs(depth - ref_depth) > 0.00999999977648258209228515625)
            {
                w = 0.0;
            }
            if (w > 0.0)
            {
                vec4 c = texelFetch(sVolumetricFog, sampling_pos, 0);
                vc += (c * w);
                total_w += w;
            }
        }
    }
    return (c0 + vc) / vec4(total_w);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_191.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_191.dispatch_setup.camera_projection_params.z) + ((_191.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _191.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_191.dispatch_setup.camera_projection_params.w) + ((_191.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _191.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 normal = decode_normal(param);
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    float voxel_occlusion_diffuse = 0.0;
    float voxel_occlusion_specular = 0.0;
    float voxel_occlusion_combined = 0.0;
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _191.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _191.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _191.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        voxel_occlusion_combined = voxel_light.w;
        vec2 voxel_occlusion = texelFetch(sVoxelOcclusion, ivec2(pixel_pos), 0).xy;
        voxel_occlusion_diffuse = voxel_occlusion.x;
        voxel_occlusion_specular = voxel_occlusion.y;
        vec4 color_1 = vec4(0.0);
        vec3 _574 = abs(local_normal);
        color_1.x = _574.x;
        color_1.y = _574.y;
        color_1.z = _574.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_385.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _385.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec4 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_5);
    uint materialIndex = metalness_roughness_material_tags.material_index;
    if (is_background == false)
    {
        MaterialPropertiesGPU _644;
        _644.diffuse = materials.material_properties[materialIndex].diffuse;
        _644.transparency = materials.material_properties[materialIndex].transparency;
        _644.emissive = materials.material_properties[materialIndex].emissive;
        _644.roughness = materials.material_properties[materialIndex].roughness;
        _644.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _644.refraction = materials.material_properties[materialIndex].refraction;
        _644.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _644.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _644.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _644.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _644.metalness = materials.material_properties[materialIndex].metalness;
        _644.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _644.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _644.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _644.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _644.flags = materials.material_properties[materialIndex].flags;
        _644._pad0 = materials.material_properties[materialIndex]._pad0;
        _644._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _644;
    }
    vec4 _645 = shadow;
    vec4 _653 = shadow;
    vec3 _655 = _653.xyz + ((_645.xyz * voxel_light.xyz) * _385.composite_setup.global_illumination_strength);
    shadow.x = _655.x;
    shadow.y = _655.y;
    shadow.z = _655.z;
    vec4 _667 = shadow;
    vec3 _669 = _667.xyz + (voxel_light.xyz * _385.composite_setup.global_illumination_base_strength);
    shadow.x = _669.x;
    shadow.y = _669.y;
    shadow.z = _669.z;
    vec3 param_6 = world;
    vec3 param_7 = local_normal;
    vec3 param_8 = vec3(0.0);
    vec3 param_9 = vec3(0.0);
    float param_10 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_6, param_7, param_8, param_9, param_10);
    vec4 _692 = shadow;
    vec3 _694 = _692.xyz + fill_color.xyz;
    shadow.x = _694.x;
    shadow.y = _694.y;
    shadow.z = _694.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _717 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _385.composite_setup.ambient_color.xyz;
        color.x = _717.x;
        color.y = _717.y;
        color.z = _717.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _737 = color;
    vec3 _739 = _737.xyz + (ssr.xyz * 4.0);
    color.x = _739.x;
    color.y = _739.y;
    color.z = _739.z;
    vec4 _748 = color;
    vec3 _751 = _748.xyz + vec3(shadow.w);
    color.x = _751.x;
    color.y = _751.y;
    color.z = _751.z;
    if (_761.composite_params.composite_output_mode == 0)
    {
        float fog_density = linear_depth;
        if (_385.composite_setup.fog_range > 0.0)
        {
            fog_density /= _385.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _385.composite_setup.fog_height, 0.0, 1.0)) * _385.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _385.composite_setup.fog_color.xyz;
        vec4 _808 = color;
        vec3 _813 = mix(_808.xyz, fog_color, vec3(fog_density));
        color.x = _813.x;
        color.y = _813.y;
        color.z = _813.z;
        uvec2 param_11 = pixel_pos;
        float param_12 = depth;
        uint param_13 = materialIndex;
        vec4 volumetric_fog_color = sample_volumetric_fog(param_11, param_12, param_13);
        if (_385.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _834 = volumetric_fog_color;
            vec3 _839 = pow(_834.xyz, vec3(_385.composite_setup.volumetric_fog_intensity));
            volumetric_fog_color.x = _839.x;
            volumetric_fog_color.y = _839.y;
            volumetric_fog_color.z = _839.z;
        }
        float volumetric_fog_blend = volumetric_fog_color.w;
        if (true)
        {
            volumetric_fog_blend = 1.0 - volumetric_fog_blend;
            if (_385.composite_setup.volumetric_fog_strength > 0.0)
            {
                volumetric_fog_blend = exp((-volumetric_fog_blend) / _385.composite_setup.volumetric_fog_strength);
            }
            else
            {
                volumetric_fog_blend = 0.0;
            }
            volumetric_fog_blend = clamp(volumetric_fog_blend * _385.composite_setup.volumetric_fog_intensity, 0.0, 1.0);
        }
        vec4 _871 = color;
        vec3 _877 = mix(_871.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _877.x;
        color.y = _877.y;
        color.z = _877.z;
        if (_385.composite_setup.transparency_blend == 0u)
        {
            vec4 _896 = color;
            vec3 _898 = _896.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _898.x;
            color.y = _898.y;
            color.z = _898.z;
        }
        if (_385.composite_setup.transparency_blend == 1u)
        {
            vec4 _910 = color;
            vec3 _918 = mix(_910.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _918.x;
            color.y = _918.y;
            color.z = _918.z;
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 