#version 450

struct PostprocessParams
{
    vec2 resolution;
    vec2 inv_resolution;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
    int txt1_flip_y;
    int txt2_flip_y;
    int txt3_flip_y;
    int _pad2;
};

layout(set = 1, binding = 1, std140) uniform PostprocessParamsBuffer
{
    PostprocessParams params;
} _32;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;

layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;

void main()
{
    outColor = texture(s_texture0, vTexcoord0);
    vec2 vTexcoord1 = vTexcoord0;
    vec2 vTexcoord2 = vTexcoord0;
    vec2 vTexcoord3 = vTexcoord0;
    if (_32.params.txt1_flip_y != 0)
    {
        vTexcoord1.y = 1.0 - vTexcoord1.y;
    }
    if (_32.params.txt2_flip_y != 0)
    {
        vTexcoord2.y = 1.0 - vTexcoord2.y;
    }
    if (_32.params.txt3_flip_y != 0)
    {
        vTexcoord3.y = 1.0 - vTexcoord3.y;
    }
    vec2 uv = vTexcoord1;
    float fade = (abs((0.5 - uv.x) - (uv.y * 0.0500000007450580596923828125)) - _32.params.param1) + 1.0;
    uv *= (vec2(1.0) - uv.yx);
    float vig = (uv.x * uv.y) * 15.0;
    vig = pow(vig, _32.params.param2);
    float vig2 = clamp(fade, 0.0, 1.0);
    vec4 _114 = outColor;
    vec3 _121 = mix(_114.xyz, vec3(0.0), vec3(vig2 * vig2));
    outColor.x = _121.x;
    outColor.y = _121.y;
    outColor.z = _121.z;
    outColor *= vig;
}

 