#version 450

struct Image2DParams
{
    uint op;
    uint color_as_alpha;
    float color_scale;
    float color_base;
    float alpha_scale;
    float alpha_base;
    uint color_repeat;
    uint alpha_repeat;
    float color_transform_rotation;
    float alpha_transform_rotation;
    uint color_texture_valid;
    uint alpha_texture_valid;
    float color_aspect;
    float alpha_aspect;
    uint color_flip_y;
    uint alpha_flip_y;
    vec2 color_transform_translation;
    vec2 color_transform_scale;
    vec2 alpha_transform_translation;
    vec2 alpha_transform_scale;
    mat4 mat_color_rotation;
    mat4 mat_alpha_rotation;
    vec2 resolution;
    vec2 inv_resolution;
    float saturation;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform PostprocessParamsBuffer
{
    layout(row_major) Image2DParams image2d_params;
} _53;

layout(set = 1, binding = 2) uniform sampler2D sImageSource;
layout(set = 1, binding = 3) uniform sampler2D sImageColor;
layout(set = 1, binding = 4) uniform sampler2D sImageAlpha;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

vec2 vector_transform_by_mat22(vec2 v, mat4 m)
{
    return (m * vec4(v, 0.0, 0.0)).xy;
}

void main()
{
    vec2 flipped_texcoord = vTexcoord0;
    flipped_texcoord.y = 1.0 - flipped_texcoord.y;
    vec4 base_color = texelFetch(sImageSource, ivec2(vTexcoord0 * _53.image2d_params.resolution), 0);
    vec2 color_translation = _53.image2d_params.color_transform_translation;
    vec2 alpha_translation = _53.image2d_params.alpha_transform_translation;
    color_translation.y = -color_translation.y;
    alpha_translation.y = -alpha_translation.y;
    vec4 color = vec4(1.0);
    if (_53.image2d_params.color_texture_valid != 0u)
    {
        vec2 tc = vTexcoord0;
        vec2 param = (tc - vec2(0.5)) * vec2(_53.image2d_params.color_aspect, 1.0);
        mat4 param_1 = _53.image2d_params.mat_color_rotation;
        tc = (((vector_transform_by_mat22(param, param_1) / _53.image2d_params.color_transform_scale) / vec2(_53.image2d_params.color_aspect, 1.0)) + vec2(0.5)) + color_translation;
        if (_53.image2d_params.color_flip_y != 0u)
        {
            tc.y = 1.0 - tc.y;
        }
        color = textureLod(sImageColor, tc, 0.0);
    }
    float alpha = 1.0;
    if (_53.image2d_params.alpha_texture_valid != 0u)
    {
        vec2 tc_1 = vTexcoord0;
        vec2 param_2 = (tc_1 - vec2(0.5)) * vec2(_53.image2d_params.alpha_aspect, 1.0);
        mat4 param_3 = _53.image2d_params.mat_alpha_rotation;
        tc_1 = (((vector_transform_by_mat22(param_2, param_3) / _53.image2d_params.alpha_transform_scale) / vec2(_53.image2d_params.alpha_aspect, 1.0)) + vec2(0.5)) + alpha_translation;
        if (_53.image2d_params.alpha_flip_y != 0u)
        {
            tc_1.y = 1.0 - tc_1.y;
        }
        alpha = textureLod(sImageAlpha, tc_1, 0.0).x;
    }
    if (_53.image2d_params.color_as_alpha != 0u)
    {
        alpha = ((color.x * 0.699999988079071044921875) + (color.y * 0.20000000298023223876953125)) + (color.z * 0.100000001490116119384765625);
    }
    vec3 gray = vec3(dot(color.xyz, vec3(0.21199999749660491943359375, 0.714999973773956298828125, 0.0719999969005584716796875)));
    vec4 _220 = color;
    vec3 _226 = mix(gray, _220.xyz, vec3(_53.image2d_params.saturation));
    color.x = _226.x;
    color.y = _226.y;
    color.z = _226.z;
    vec4 _233 = color;
    vec3 _243 = (_233.xyz * _53.image2d_params.color_scale) + vec3(_53.image2d_params.color_base);
    color.x = _243.x;
    color.y = _243.y;
    color.z = _243.z;
    alpha = (alpha * _53.image2d_params.alpha_scale) + _53.image2d_params.alpha_base;
    alpha = clamp(alpha, 0.0, 1.0);
    if (_53.image2d_params.op == 0u)
    {
        base_color = color;
    }
    if (_53.image2d_params.op == 1u)
    {
        base_color += color;
    }
    if (_53.image2d_params.op == 2u)
    {
        base_color *= color;
    }
    if (_53.image2d_params.op == 3u)
    {
        base_color = mix(base_color, color, vec4(alpha));
    }
    if (_53.image2d_params.op == 4u)
    {
        base_color = mix(base_color, vec4(1.0) - base_color, vec4(color.xyz, 1.0));
    }
    base_color = max(base_color, vec4(0.0));
    outColor = base_color;
}

 