#version 450

struct VtxData
{
    float px;
    float py;
    float pz;
    float nx;
    float ny;
    float nz;
    float cr;
    float cg;
    float cb;
    float ca;
    float pad2_1;
    float pad1_1;
};

struct Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vsColor;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InVertexBuffer
{
    VtxData verts[];
} indata;

layout(set = 0, binding = 2, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _89;

layout(location = 0) out Vertex vtx_output;

void main()
{
    int vidx = gl_VertexIndex / 2;
    float offset_factor = float(gl_VertexIndex & 1);
    vec3 vInstPosition = vec3(indata.verts[vidx].px, indata.verts[vidx].py, indata.verts[vidx].pz);
    vec3 vInstPrevPosition = vec3(indata.verts[vidx].cr, indata.verts[vidx].cg, indata.verts[vidx].cb);
    vInstPosition += (((vInstPrevPosition - vInstPosition) * offset_factor) * 55.0);
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec4 vPos1 = vec4(pos, 1.0);
    vec4 vPos;
    vPos.x = dot(_89.transform_params.mModelView[0], vPos1);
    vPos.y = dot(_89.transform_params.mModelView[1], vPos1);
    vPos.z = dot(_89.transform_params.mModelView[2], vPos1);
    vPos.w = 1.0;
    vtx_output.vWorldPos = (_89.transform_params.mModel * vPos1).xyz;
    vtx_output.vWorldNorm = vec3(1.0);
    vtx_output.vNorm = vec3(1.0);
    vPos = _89.transform_params.mProjection * vPos;
    gl_Position = vPos;
    vtx_output.vCoords = vPos.xyz;
    vtx_output.vsColor = vec4(indata.verts[vidx].ca);
}

 